/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignatureTransform;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class XadesStepSignatureCorrectTransformationCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureCorrectTransformationCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (param.getSignature() == null || param.getSignature().getSignatureInfo() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null && param.getSignature().getSignerInfoData() instanceof XadesSignerInfoData) {
            XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
            boolean validTransform = true;
            if (data != null && data.getReferences() != null && data.getReferences().size() > 0) {
                for (XadesSignatureReference ref : data.getReferences()) {
                    if (ref.getTransforms() == null || ref.getTransforms().size() <= 0) continue;
                    boolean haveXSLTTransform = false;
                    String lastTransform = "";
                    for (XadesSignatureTransform transform : ref.getTransforms()) {
                        lastTransform = transform.getAlgorithm();
                        if (!transform.getAlgorithm().equalsIgnoreCase("http://www.w3.org/TR/1999/REC-xslt-19991116")) continue;
                        haveXSLTTransform = true;
                    }
                    if (!haveXSLTTransform || lastTransform.equalsIgnoreCase("http://www.w3.org/TR/1999/REC-xslt-19991116")) continue;
                    validTransform = false;
                }
                if (!validTransform) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0019_INVALID_TRANSFORM_ALGORITHM, new Object[]{((Object)((Object)this)).getClass().getName()});
                }
            }
        }
        return null;
    }
}

