/*
 * Decompiled with CFR 0.152.
 */
package esecurity.internal.asb.gw;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.arubacipherservice.DecryptReq;
import esecurity.arubacipherservice.DecryptRet;
import esecurity.internal.asb.gw.GwClientDefault;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestClient;
import it.actalis.ellips.capi.http.arubautils.rest.RestResponse;
import it.arubapec.signservice.ArssAudit;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.AutomaticSignatureControl;
import it.arubapec.signservice.AutomaticSignatureControlReturn;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CertsListRequestAuth;
import it.arubapec.signservice.ChangePassword;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import it.arubapec.signservice.GWReturn;
import it.arubapec.signservice.RetriveCredential;
import it.arubapec.signservice.RetriveCredentialReturn;
import it.arubapec.signservice.SendCredential;
import it.arubapec.signservice.SessionSignRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.StrongCredential;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import it.arubapec.signservice.TempPwdResponseEx;
import it.arubapec.signservice.TestCredential;
import it.arubapec.signservice.UserAuthenticationInfoRequest;
import it.arubapec.signservice.UserAuthenticationInfoResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwClientGson
extends GwClientI {
    private static final Logger logger2 = LoggerFactory.getLogger((String)GwClientDefault.class.getName());
    private static Logger logger = null;
    UrlClient client;
    RestClient rsclient = null;
    boolean debug = false;
    URLCredentials cred;
    boolean enforcemode;

    public GwClientGson(UrlClient client) throws CertDBException {
        this(client, logger2, null, null, false, true);
    }

    public GwClientGson(UrlClient client, Logger log, URLCredentials cred, KeyStore store, boolean ignorecert, boolean enforcemode) {
        this.client = client;
        logger = log != null ? log : logger2;
        this.cred = cred;
        this.enforcemode = enforcemode;
        this.rsclient = new RestClient(client, store, ignorecert, logger);
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.debug = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    @Override
    public void setEnforceMode(boolean enforce) {
        this.enforcemode = enforce;
    }

    @Override
    public SignResponse signop(String baseurl, SignRequest request) throws IOException {
        return this.makeCall(baseurl + "/signop", request, SignResponse.class);
    }

    @Override
    public SignResponse signop2(String baseurl, SessionSignRequest request) throws IOException {
        return this.makeCall(baseurl + "/signop2", request, SignResponse.class);
    }

    @Override
    public CertListResponse certlistop(String baseurl, CertsListRequest request) throws IOException {
        return this.makeCall(baseurl + "/certlistop", request, CertListResponse.class);
    }

    @Override
    public CertListResponse certlistopauth(String baseurl, CertsListRequestAuth request) throws IOException {
        return this.makeCall(baseurl + "/certlistopauth", request, CertListResponse.class);
    }

    @Override
    public GWReturn close_session(String baseurl, CloseSessionRequest request) throws IOException {
        return this.makeCall(baseurl + "/close_session", request, GWReturn.class);
    }

    @Override
    public CreateSessionReturn create_session(String baseurl, TempPwdRequestEx identity) throws IOException {
        return this.makeCall(baseurl + "/create_session", identity, CreateSessionReturn.class);
    }

    @Override
    public TempPwdResponse temppwd(String baseurl, TempPwdRequest request) throws IOException {
        return this.makeCall(baseurl + "/temppwd", request, TempPwdResponse.class);
    }

    @Override
    public String arssaudit(String baseurl, ArssAudit request) throws IOException {
        return this.makeCall(baseurl + "/arssaudit", request, String.class);
    }

    @Override
    public TempPwdResponseEx temppwd_ext(String baseurl, TempPwdRequestEx request) throws IOException {
        return this.makeCall(baseurl + "/temppwd_ext", request, TempPwdResponseEx.class);
    }

    @Override
    public String send_credential(String baseurl, SendCredential request) throws IOException {
        return this.makeCall(baseurl + "/send_credential", request, String.class);
    }

    @Override
    public String verify_credential(String baseurl, StrongCredential request) throws IOException {
        return this.makeCall(baseurl + "/verify_credential", request, String.class);
    }

    @Override
    public String verify_otp(String baseurl, StrongCredential request) throws IOException {
        return this.makeCall(baseurl + "/verify_otp", request, String.class);
    }

    @Override
    public AutomaticSignatureControlReturn enable_automatic_signature(String baseurl, AutomaticSignatureControl request) throws IOException {
        return this.makeCall(baseurl + "/temppwd_ext", request, AutomaticSignatureControlReturn.class);
    }

    @Override
    public RetriveCredentialReturn retrieve_credential(String baseurl, RetriveCredential retrive_request) throws IOException {
        return this.makeCall(baseurl + "/retrive_credential", retrive_request, RetriveCredentialReturn.class);
    }

    @Override
    public String[] auth_methods(String baseurl, Auth identity) throws IOException {
        return this.makeCall(baseurl + "/auth_methods", identity, String[].class);
    }

    @Override
    public String getInfoMiddlewareUrl() {
        return "";
    }

    @Override
    public CredentialListReturn credentials_query(String baseurl, CredentialListQuery credential_query) throws IOException {
        return this.makeCall(baseurl + "/credentials_query", credential_query, CredentialListReturn.class);
    }

    @Override
    public GWReturn test_otp(String baseurl, TestCredential test_credential) throws IOException {
        return this.makeCall(baseurl + "/test_otp", test_credential, GWReturn.class);
    }

    @Override
    public DecryptRet decrypt(String baseurl, DecryptReq request) throws IOException {
        return this.makeCall(baseurl + "/decrypt", request, DecryptRet.class);
    }

    public <T> T makeCall(String stringUrl, Object request, Class<T> type) throws IOException {
        if (!stringUrl.toUpperCase().startsWith("HTTPS")) {
            if (this.enforcemode) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
            if (!stringUrl.contains("http://localhost") && !stringUrl.contains("http://127.0.0.1")) {
                logger.error("Tentativo di connessione a un GW non sicuro");
                throw new IOException("Remote signature Must Be Secure...");
            }
        }
        Object result = null;
        try {
            logger.debug("endpoint richiesta " + stringUrl);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String objectreq = mapper.writeValueAsString(request);
            if (this.debug) {
                logger.debug("richiesta : {}", (Object)this.obfuscatePassword(objectreq));
            }
            RestResponse restResp = this.rsclient.sendRawJson(stringUrl, objectreq.getBytes(), this.cred);
            if (this.debug) {
                logger.info("{}", (Object)objectreq);
                logger.info("{}", (Object)restResp.getResponseData());
            }
            if (restResp.getResponseData() == null) {
                logger.error("Nessun risposta dal server: " + restResp.getMessage());
                throw new IOException(restResp.getMessage());
            }
            if (String.class.equals(type)) {
                return (T)new String(restResp.getResponseData());
            }
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(restResp.getResponseData()));
            result = mapper.readValue((Reader)reader, type);
            if (result == null) {
                throw new IOException("Null Response from Server");
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new IOException(t.getMessage(), t);
        }
        return (T)result;
    }

    private String obfuscatePassword(String objectreq) {
        String strReturn = objectreq;
        try {
            int i = 0;
            i = strReturn.indexOf("userPWD");
            if (i != -1) {
                strReturn = this.replaceToken(i, 10, strReturn);
            }
            if ((i = strReturn.indexOf("delegated_password")) != -1) {
                strReturn = this.replaceToken(i, 21, strReturn);
            }
            if ((i = strReturn.indexOf("otpPwd")) != -1) {
                strReturn = this.replaceToken(i, 9, strReturn);
            }
            if ((i = strReturn.indexOf("newpassword")) != -1) {
                strReturn = this.replaceToken(i, 14, strReturn);
            }
            if ((i = strReturn.indexOf("applicationpassword")) != -1) {
                strReturn = this.replaceToken(i, 22, strReturn);
            }
            if ((i = strReturn.indexOf("value")) != -1) {
                strReturn = this.replaceToken(i, 8, strReturn);
            }
        }
        catch (Exception ex) {
            return "";
        }
        return strReturn;
    }

    private String replaceToken(int index, int tokenSize, String strReturn) {
        String toEnd = "\",";
        if (strReturn.substring(index + tokenSize).indexOf("\",") == -1) {
            toEnd = "\"}";
        }
        String password = strReturn.substring(index + tokenSize, index + tokenSize + strReturn.substring(index + tokenSize).indexOf(toEnd));
        return strReturn.replace("\"" + password + "\"", "\"*****\"");
    }

    @Override
    public GWReturn changePassword(String baseurl, ChangePassword request) throws IOException {
        return this.makeCall(baseurl + "/change_password", request, GWReturn.class);
    }

    @Override
    public UserAuthenticationInfoResponse userAuthenticationInfo(String baseurl, UserAuthenticationInfoRequest request) throws IOException {
        return this.makeCall(baseurl + "/user_authentication_info", request, UserAuthenticationInfoResponse.class);
    }
}

