/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.rest.RestException;
import esecurity.rest.SimpleRest;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.RemoteHsmInitializeParameters;
import it.actalis.ellips.capi.rs.util.ArssReturn;
import it.actalis.ellips.capi.rs.util.Auth;
import it.actalis.ellips.capi.rs.util.AuthMethodsReturn;
import it.actalis.ellips.capi.rs.util.BodyRequestAuthMethod;
import it.actalis.ellips.capi.rs.util.BodyRequestListCert;
import it.actalis.ellips.capi.rs.util.BodyRequestOpenSession;
import it.actalis.ellips.capi.rs.util.BodyRequestSendCredential;
import it.actalis.ellips.capi.rs.util.Cert;
import it.actalis.ellips.capi.rs.util.CredentialsType;
import it.actalis.ellips.capi.rs.util.SignHashInnerRequest;
import it.actalis.ellips.capi.rs.util.SignHashRequest;
import it.actalis.ellips.capi.rs.util.SignHashReturn;
import it.actalis.ellips.capi.rs.util.UserCertList;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.TempPwdRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ARSSSignatureTokenV2
extends TokenSpi
implements VerifiedSignatureToken {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
    public static final String TOKEN_RS = "ARSSAutomaticSignatureToken";
    private static final LRUMap<String, LoginCache> resps = new LRUMap(50);
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private String user;
    private String domain;
    private String password;
    private String cns_otp;
    private boolean publicSessionOpen = false;
    private String delegatedUser;
    private String delegatedDomain;
    private String delegatedPassword;
    private LoginCache login = null;
    private String openSession = null;
    private UrlClient urlClient = null;
    protected String sessionOtp = null;
    private it.arubapec.signservice.Auth identity = null;
    private URLCredentials cred = null;
    private String cacheKey = "";
    private boolean useRestService = false;
    private SimpleRest simplerest = null;
    private HashMap<String, PrivateKey> keyCache = new HashMap();

    public ARSSSignatureTokenV2() {
    }

    public ARSSSignatureTokenV2(RemoteHsmInitializeParameters params) throws CapiException {
        this.initializeLib(params);
    }

    public void initializeLib(String[] args) throws CapiException {
        throw new CapiException("This token doesn't support this initialization mode", 1004);
    }

    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        throw new CapiException("This token doesn't support this initialization mode", 1004);
    }

    public void initializeLib(TokenParameters param) throws CapiException {
        RemoteHsmInitializeParameters hsmParams;
        String[] localArgs = new String[12];
        if (param instanceof RemoteHsmInitializeParameters) {
            hsmParams = (RemoteHsmInitializeParameters)param;
            if (hsmParams == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (hsmParams.getIdentity() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            if (hsmParams.getIdentity().getUserid() == null) {
                throw new CapiException("Wrong args usr", 1001);
            }
            if (hsmParams.getIdentity().getPassword() == null) {
                if (hsmParams.getIdentity().getDelegatedBy() == null) {
                    throw new CapiException("Wrong args pwd", 1001);
                }
                if (hsmParams.getIdentity().getDelegatedBy().getPassword() == null) {
                    throw new CapiException("Wrong args Delegated Password", 1001);
                }
            }
            if (hsmParams.getUrl1() == null) {
                throw new CapiException("Wrong args", 1001);
            }
            this.urlClient = new UrlClient(hsmParams.getNetworkConfig(), logger);
            String selectedUrl = hsmParams.getUrl2() != null ? (System.currentTimeMillis() % 2L == 0L ? hsmParams.getUrl1() : hsmParams.getUrl2()) : hsmParams.getUrl1();
            String userId = hsmParams.getIdentity().getUserid();
            int indexTok = userId.lastIndexOf("@");
            if (indexTok < 1 || indexTok == userId.length() - 1) {
                throw new CapiException("Invalid user domain, @ expected", 2012);
            }
            String domain = userId.substring(indexTok + 1);
            String user = userId.substring(0, indexTok);
            String password = hsmParams.getIdentity().getPassword();
            localArgs[0] = selectedUrl;
            localArgs[1] = selectedUrl;
            localArgs[3] = user;
            localArgs[4] = domain;
            localArgs[5] = password;
            if (hsmParams.getIdentity().getDelegatedBy() != null) {
                String delegatedId = hsmParams.getIdentity().getDelegatedBy().getUserid();
                int indexTok2 = delegatedId.lastIndexOf("@");
                if (indexTok2 < 1 || indexTok2 == userId.length() - 1) {
                    throw new CapiException("Invalid delegated user domain, @ expected", 2012);
                }
                localArgs[7] = delegatedId.substring(0, indexTok2);
                localArgs[8] = delegatedId.substring(indexTok2 + 1);
                localArgs[9] = hsmParams.getIdentity().getDelegatedBy().getPassword();
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        localArgs[10] = hsmParams.getBasicAuthUser();
        localArgs[11] = hsmParams.getBasicAuthPwd();
        this.initializeLib(localArgs, hsmParams.getNetworkConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLib(String[] args, NetworkConfig networkConfig) throws CapiException {
        String selected_url;
        String arss1_url;
        block49: {
            this.initProviders(this);
            this.urlClient = new UrlClient(networkConfig, logger);
            if (args == null || args.length < 5 || args[0] == null || args[1] == null || args[3] == null || args[4] == null) {
                throw new CapiException("Wrong args", 1001);
            }
            arss1_url = "";
            selected_url = "";
            try {
                arss1_url = this.argsResolver(args, 0);
                if (arss1_url != null && !arss1_url.trim().equals("")) {
                    new URL(arss1_url);
                    logger.debug("App1 url: " + arss1_url);
                    if (arss1_url.contains("/rest/ArubaSignService")) {
                        this.useRestService = true;
                        this.simplerest = new SimpleRest(this.urlClient, logger);
                    } else {
                        this.useRestService = false;
                    }
                    break block49;
                }
                throw new CapiException("Not valid URL: \"" + args[1] + "\"", 1002);
            }
            catch (MalformedURLException e) {
                throw new CapiException("Not valid URL: \"" + args[1] + "\"", 1002);
            }
        }
        String arss2_url = "";
        try {
            arss2_url = this.argsResolver(args, 1);
            if (arss2_url != null && !arss2_url.trim().equals("")) {
                new URL(arss2_url);
                logger.debug("App2 url: " + arss2_url);
            }
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + args[2] + "\"", 1002);
        }
        try {
            selected_url = this.argsResolver(args, 2);
            if (selected_url != null && !selected_url.trim().equals("")) {
                new URL(selected_url);
                logger.debug("Forced url: " + selected_url);
            }
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + args[2] + "\"", 1002);
        }
        this.user = this.argsResolver(args, 3);
        this.domain = this.argsResolver(args, 4);
        this.password = this.argsResolver(args, 5);
        this.cns_otp = this.argsResolver(args, 6);
        this.delegatedUser = this.argsResolver(args, 7);
        this.delegatedDomain = this.argsResolver(args, 8);
        this.delegatedPassword = this.argsResolver(args, 9);
        String remoteBasicAuthUser = this.argsResolver(args, 10);
        String remoteBasicAuthPassword = this.argsResolver(args, 11);
        if (remoteBasicAuthUser != null && !remoteBasicAuthUser.isEmpty() && remoteBasicAuthPassword != null && !remoteBasicAuthPassword.isEmpty()) {
            this.cred = new URLCredentials(remoteBasicAuthUser, remoteBasicAuthPassword, null, null);
        }
        this.urlClient.setTrustStore(ArubaTrustStore.getTSRS((String)this.domain));
        CertsListRequest req = new CertsListRequest();
        CertListResponse cert_resp = null;
        String[] auth_methods = null;
        this.identity = new it.arubapec.signservice.Auth();
        this.identity.setDomain(this.domain);
        this.identity.setUser(this.user);
        if (this.cns_otp != null) {
            this.identity.setOtpPwd(this.cns_otp);
        }
        if (this.password != null) {
            this.identity.setUserPWD(this.password);
        }
        if (this.delegatedPassword != null) {
            this.identity.setDelegated_user(this.delegatedUser);
            this.identity.setDelegated_domain(this.delegatedDomain);
            this.identity.setDelegated_password(this.delegatedPassword);
        }
        if (this.delegatedPassword == null && this.password == null) {
            throw new CapiException("Wrong password", 1002);
        }
        req.setIdentity(this.identity);
        this.cacheKey = this.user + this.domain + (this.delegatedUser != null ? this.delegatedUser : "-") + (this.delegatedDomain != null ? this.delegatedDomain : "-") + (this.password != null ? this.digestWithSalt(this.password) : this.digestWithSalt(this.delegatedPassword));
        this.login = (LoginCache)resps.get((Object)this.cacheKey);
        if (this.login != null) {
            return;
        }
        LRUMap<String, LoginCache> lRUMap = resps;
        synchronized (lRUMap) {
            this.login = (LoginCache)resps.get((Object)this.cacheKey);
            if (this.login != null) {
                return;
            }
            if (selected_url == null || selected_url.trim().equals("")) {
                if (System.currentTimeMillis() % 2L == 0L || arss2_url == null || arss2_url.trim().equals("")) {
                    try {
                        cert_resp = this.certlistop(arss1_url, req);
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    if (cert_resp == null) {
                        if (arss2_url != null) {
                            try {
                                cert_resp = this.certlistop(arss2_url, req);
                                if (cert_resp == null) {
                                    throw new CapiException("Network Error", -2147483136);
                                }
                                selected_url = arss2_url;
                            }
                            catch (IOException ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    } else {
                        selected_url = arss1_url;
                    }
                } else {
                    try {
                        cert_resp = this.certlistop(arss2_url, req);
                    }
                    catch (IOException ex) {
                        throw new CapiException("Network Error", -2147483136);
                    }
                    if (cert_resp == null) {
                        try {
                            cert_resp = this.certlistop(arss1_url, req);
                            if (cert_resp == null) {
                                throw new CapiException("Network Error", -2147483136);
                            }
                            selected_url = arss1_url;
                        }
                        catch (IOException ex) {
                            throw new CapiException("Network Error", -2147483136);
                        }
                    } else {
                        selected_url = arss2_url;
                    }
                }
            } else {
                try {
                    cert_resp = this.certlistop(selected_url, req);
                    if (cert_resp == null) {
                        throw new CapiException("Network Error", -2147483136);
                    }
                }
                catch (IOException ex) {
                    throw new CapiException("Network Error", -2147483136);
                }
            }
            logger.debug("Selezionato URL :" + selected_url);
            try {
                for (String method : auth_methods = this.auth_methods(selected_url, this.identity)) {
                    logger.debug("Method enable :" + method);
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            if (!cert_resp.getReturn_code().equals("0000")) {
                if (cert_resp.getReturn_code().equals("0002")) {
                    throw new CapiException("Invalid Credentials", 2006);
                }
                throw new CapiException("Invalid User", 10000);
            }
            this.login = new LoginCache(cert_resp, auth_methods, selected_url);
            resps.put((Object)this.cacheKey, (Object)this.login);
        }
    }

    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    public String[] getLibInfo() {
        String tokenType = "ARSS Signature";
        String libraryName = "";
        String libraryDescription = "Ellips ARSS Signature Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "Actalis S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "Actalis S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "Actalis S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    public int getFreeSpace() throws CapiException {
        return -1;
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support PUK changing", 1004);
    }

    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support unblocking", 1004);
    }

    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    public int getMinPINLen() throws CapiException {
        return 0;
    }

    public void openSession(boolean asSO, String pin) throws CapiException {
        if (!this.isSessionOpen()) {
            this.openSession = null;
        }
        try {
            TempPwdRequest req = new TempPwdRequest();
            req.setIdentity(this.identity);
            this.identity.setOtpPwd(pin);
            this.sessionOtp = pin;
            if (Util.isNullOrEmpty((String)this.identity.getDelegated_user())) {
                this.openSession = this.opensession(this.login.getSelectedUrl(), req);
                if (this.openSession.startsWith("KO-0004") || this.openSession.startsWith("KO-0003")) {
                    this.openSession = null;
                } else if (!this.openSession.startsWith("KO-0024") && this.openSession.startsWith("KO-")) {
                    this.openSession = null;
                    this.sessionOtp = null;
                    throw new CapiException("Error" + this.openSession, -2147483136);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
        this.publicSessionOpen = true;
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.sessionOtp = null;
        this.openSession = null;
        this.publicSessionOpen = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return this.sessionOtp != null || this.publicSessionOpen;
    }

    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String alias) throws CapiException {
        if (this.login.getResp() != null) {
            for (Certificato cert : this.login.getResp().getCertlist()) {
                if (!cert.getId().equals(alias)) continue;
                return new String(Base64.encode((byte[])cert.getContent()));
            }
        }
        return null;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String alias) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.login.getResp() != null) {
            if (this.keyCache.get(alias) == null) {
                for (Certificato cert : this.login.getResp().getCertlist()) {
                    if (!cert.getId().equals(alias)) continue;
                    Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
                    Certificate certf = new Certificate(Base64.decode((String)this.getCert(alias)));
                    ret.setPublicInfo((PublicKey)((RSAPublicKey)certf.getInternalCert().getPublicKey()));
                    ret.setCryptoDev((TokenSpi)this);
                    return ret;
                }
            } else {
                return this.keyCache.get(alias);
            }
        }
        return null;
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        try {
            logger.debug("mode:" + mode);
            logger.debug("DigestInfo:" + new String(Base64.encode((byte[])digest)));
            logger.debug("alias:" + alias);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)digest);
            DigestInfo dinfo = new DigestInfo(seq);
            logger.debug("digest:" + new String(Base64.encode((byte[])dinfo.getDigest())));
            SignRequest req = new SignRequest();
            req.setIdentity(this.identity);
            this.identity.setOtpPwd(this.sessionOtp);
            req.setCertID(alias);
            req.setDataToSign(dinfo.getDigest());
            SignResponse resp = this.signop(this.login.getSelectedUrl(), req);
            logger.debug("return_code" + resp.getReturn_code());
            if (resp.getReturn_code().equals("0000")) {
                return resp.getSignData();
            }
            if (resp.getReturn_code().equals("0002")) {
                throw new CapiException("", 2006);
            }
            this.invalidaCache();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String expr, byte filter) throws CapiException {
        if (this.login.getResp() == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] labels = new String[this.login.getResp().getCertlist().length];
            if (this.login.getResp().getCertlist().length == 0) {
                return labels;
            }
            int i = 0;
            for (Certificato cert : this.login.getResp().getCertlist()) {
                String label = cert.getId();
                if ((this.getObjectType(label) & filter) == 0 || expr != null && label.indexOf(expr) < 0) continue;
                labels[i] = label;
                ++i;
            }
            if (i == 0) {
                return new String[0];
            }
            String[] res = new String[i];
            for (int j = 0; j < i; ++j) {
                res[j] = labels[j];
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    public boolean exist(String alias) throws CapiException {
        for (String id : this.listObjects(null, (byte)2)) {
            if (!alias.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] args) {
        return this.argsResolver(args, 2) + "@" + this.argsResolver(args, 3);
    }

    public String[] getAuth_methods() {
        return this.login.getAuthMethods();
    }

    public byte[] verifiedSignature(byte[] digest, String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support verifiedSignarute functionality", 1004);
    }

    public String getSelected_url() {
        return this.login.getSelectedUrl();
    }

    private SignResponse signop(String arss_url, SignRequest req) throws IOException {
        if (this.useRestService) {
            return this.signopRest(arss_url, req);
        }
        return this.signopSoap(arss_url, req);
    }

    private SignResponse signopRest(String arss_url, SignRequest req) throws IOException {
        SignResponse objReturn = new SignResponse();
        objReturn.setReturn_code("0002");
        SignHashRequest request = new SignHashRequest();
        SignHashInnerRequest innerRequest = new SignHashInnerRequest();
        innerRequest.setHashtype(Constants.SHA256);
        innerRequest.setCertID(req.getCertID());
        innerRequest.setHash(new String(Base64.encode((byte[])req.getDataToSign())));
        innerRequest.setRequirecert(false);
        if (this.openSession != null) {
            innerRequest.setSession_id(this.openSession);
        }
        Auth auth = this.toARSSAuth(req.getIdentity());
        innerRequest.setIdentity(auth);
        request.setRequest(innerRequest);
        String url = arss_url;
        url = url.endsWith("/") ? url + "signhash" : url + "/signhash";
        try {
            SignHashReturn response = (SignHashReturn)this.simplerest.post(url).body((Object)request, "application/json").auth(this.cred).asObject(SignHashReturn.class);
            if (response != null) {
                objReturn.setReturn_code(response.getReturn_code());
                objReturn.setStatus(response.getStatus());
                objReturn.setSignData(Base64.decode((String)response.getSignature()));
                objReturn.setCert_id(response.getCertID());
                objReturn.setDescription(response.getDescription());
            }
        }
        catch (RestException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    private SignResponse signopSoap(String arss_url, SignRequest req) throws IOException {
        String xml_ret;
        SignResponse objReturn = new SignResponse();
        objReturn.setReturn_code("0002");
        String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:signhash>\n         <SignHashRequest>\n            <certID>" + req.getCertID() + "</certID>\n" + "            <hash>" + new String(Base64.encode((byte[])req.getDataToSign())) + "</hash>\n" + "            <hashtype>SHA256</hashtype>\n" + "           <identity>\n";
        if (req.getIdentity().getOtpPwd() != null) {
            xml = xml + "             \t<otpPwd>" + req.getIdentity().getOtpPwd() + "</otpPwd>\n";
        }
        xml = xml + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (req.getIdentity().getTypeOtpAuth() != null && req.getIdentity().getDomain() == null) {
            xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (req.getIdentity().getDomain() != null) {
            xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getDomain() + "</typeOtpAuth>\n";
        }
        xml = xml + "          \t<user>" + req.getIdentity().getUser() + "</user>\n";
        if (req.getIdentity().getUserPWD() != null) {
            xml = xml + "          \t<userPWD>" + req.getIdentity().getUserPWD() + "</userPWD>\n";
        }
        if (req.getIdentity().getDelegated_domain() != null) {
            xml = xml + "          \t<delegated_domain>" + req.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
        }
        if (req.getIdentity().getDelegated_password() != null) {
            xml = xml + "          \t<delegated_password>" + req.getIdentity().getDelegated_password() + "</delegated_password>\n";
        }
        if (req.getIdentity().getDelegated_user() != null) {
            xml = xml + "          \t<delegated_user>" + req.getIdentity().getDelegated_user() + "</delegated_user>\n";
        }
        xml = xml + "         </identity>\n            <requirecert>false</requirecert>\n";
        if (this.openSession != null) {
            xml = xml + "            <session_id>" + this.openSession + "</session_id>\n";
        }
        if ((xml_ret = this.sendXml(arss_url, xml = xml + "         </SignHashRequest>\n      </arub:signhash>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
            try {
                NodeList nl2;
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
                NodeList nl = doc.getElementsByTagName("return");
                if (nl.getLength() > 0 && (nl2 = doc.getElementsByTagName("return")).getLength() > 0) {
                    Element objElStat = (Element)nl2.item(0);
                    NodeList nl_signature = objElStat.getElementsByTagName("signature");
                    NodeList nl_id = objElStat.getElementsByTagName("ide");
                    String signature = null;
                    String id = null;
                    if (nl_signature.getLength() > 0) {
                        signature = ((Element)nl_signature.item(0)).getTextContent();
                    }
                    if (nl_id.getLength() > 0) {
                        id = ((Element)nl_signature.item(0)).getTextContent();
                    }
                    if (signature != null) {
                        objReturn.setReturn_code("0000");
                        objReturn.setSignData(Base64.decode((String)signature));
                        objReturn.setCert_id(id);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return objReturn;
    }

    private String sendXml(String arss_url, String xml) throws UnsupportedEncodingException {
        RequestData rdata = new RequestData();
        rdata.setSoapAction("\"\"");
        rdata.setPostdata(xml.getBytes("UTF8"));
        rdata.setType("SOAP");
        UrlReturn ret = this.urlClient.downloadUrl(arss_url, rdata, this.cred);
        if (ret.getStatus().startsWith("OK")) {
            return new String(ret.getData());
        }
        return null;
    }

    private CertListResponse certlistop(String arss_url, CertsListRequest req) throws IOException, CapiException {
        if (this.useRestService) {
            return this.certlistopRest(arss_url, req);
        }
        return this.certlistopSoap(arss_url, req);
    }

    private CertListResponse certlistopRest(String arss_url, CertsListRequest req) throws IOException {
        CertListResponse objReturn = new CertListResponse();
        objReturn.setReturn_code("0002");
        BodyRequestListCert request = new BodyRequestListCert();
        request.setIdentity(this.toARSSAuth(req.getIdentity()));
        String url = arss_url;
        url = url.endsWith("/") ? url + "listCert" : url + "/listCert";
        try {
            UserCertList response = (UserCertList)this.simplerest.post(url).body((Object)request, "application/json").auth(this.cred).asObject(UserCertList.class);
            if (response != null) {
                byte[] value = null;
                String id = null;
                List<Cert> app1 = response.getApp1();
                List<Cert> app2 = response.getApp2();
                if (app1 != null && app1.size() > 0 && app1.get(0) != null) {
                    value = Base64.decode((String)app1.get(0).getValue());
                    id = app1.get(0).getId();
                } else if (app2 != null && app2.size() > 0 && app2.get(0) != null) {
                    value = Base64.decode((String)app1.get(0).getValue());
                    id = app2.get(0).getId();
                }
                if (value != null) {
                    objReturn.setReturn_code("0000");
                    Certificato[] cert = new Certificato[]{new Certificato()};
                    cert[0].setId(id);
                    cert[0].setContent(value);
                    objReturn.setCertlist(cert);
                }
            }
        }
        catch (RestException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objReturn;
    }

    private CertListResponse certlistopSoap(String arss_url, CertsListRequest req) throws IOException, CapiException {
        CertListResponse objReturn;
        block15: {
            String xml_ret;
            objReturn = new CertListResponse();
            objReturn.setReturn_code("0002");
            String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:listCert>\n         <Identity>\n";
            if (req.getIdentity().getOtpPwd() != null) {
                xml = xml + "             \t<otpPwd>" + req.getIdentity().getOtpPwd() + "</otpPwd>\n";
            }
            xml = xml + "          \t<typeHSM>COSIGN</typeHSM>\n";
            if (req.getIdentity().getTypeOtpAuth() != null && req.getIdentity().getDomain() == null) {
                xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
            }
            if (req.getIdentity().getDomain() != null) {
                xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getDomain() + "</typeOtpAuth>\n";
            }
            xml = xml + "          \t<user>" + req.getIdentity().getUser() + "</user>\n";
            if (req.getIdentity().getUserPWD() != null) {
                xml = xml + "          \t<userPWD>" + req.getIdentity().getUserPWD() + "</userPWD>\n";
            }
            if (req.getIdentity().getDelegated_domain() != null) {
                xml = xml + "          \t<delegated_domain>" + req.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
            }
            if (req.getIdentity().getDelegated_password() != null) {
                xml = xml + "          \t<delegated_password>" + req.getIdentity().getDelegated_password() + "</delegated_password>\n";
            }
            if (req.getIdentity().getDelegated_user() != null) {
                xml = xml + "          \t<delegated_user>" + req.getIdentity().getDelegated_user() + "</delegated_user>\n";
            }
            if ((xml_ret = this.sendXml(arss_url, xml = xml + "         </Identity>\n      </arub:listCert>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
                try {
                    NodeList nl2;
                    DocumentBuilder db = df.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
                    NodeList nl = doc.getElementsByTagName("return");
                    if (nl.getLength() <= 0 || (nl2 = doc.getElementsByTagName("return")).getLength() <= 0) break block15;
                    Element objElStat = (Element)nl2.item(0);
                    NodeList nl_app1 = objElStat.getElementsByTagName("app1");
                    String value = null;
                    String id = null;
                    if (nl_app1.getLength() > 0) {
                        value = ((Element)nl_app1.item(0)).getElementsByTagName("value").item(0).getTextContent();
                        id = ((Element)nl_app1.item(0)).getElementsByTagName("id").item(0).getTextContent();
                    } else {
                        NodeList nl_app2 = objElStat.getElementsByTagName("app2");
                        if (nl_app2.getLength() > 0) {
                            value = ((Element)nl_app2.item(0)).getElementsByTagName("value").item(0).getTextContent();
                            id = ((Element)nl_app2.item(0)).getElementsByTagName("id").item(0).getTextContent();
                        }
                    }
                    if (value != null) {
                        objReturn.setReturn_code("0000");
                        Certificato[] cert = new Certificato[]{new Certificato()};
                        cert[0].setId(id);
                        cert[0].setContent(Base64.decode((String)value));
                        objReturn.setCertlist(cert);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            } else {
                throw new CapiException("Network Error", 1003);
            }
        }
        return objReturn;
    }

    public void send_credentialRest(String type) throws IOException {
        BodyRequestSendCredential request = new BodyRequestSendCredential();
        request.setIdentity(this.toARSSAuth(this.identity));
        request.setType(CredentialsType.valueOf(type));
        String url = this.login.getSelectedUrl();
        url = url.endsWith("/") ? url + "sendCredential" : url + "/sendCredential";
        try {
            ArssReturn response = (ArssReturn)this.simplerest.post(url).body((Object)request, "application/json").auth(this.cred).asObject(ArssReturn.class);
            if (response == null || response.getStatus() == null || !response.getStatus().equals("0000")) {
                throw new IOException("Internal Error");
            }
        }
        catch (RestException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void send_credential(String type) throws IOException, CapiException {
        String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:sendCredential>\n         <Identity>              \n";
        if (this.identity.getOtpPwd() != null) {
            xml = xml + "             \t<otpPwd>" + this.identity.getOtpPwd() + "</otpPwd>\n";
        }
        xml = xml + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (this.identity.getTypeOtpAuth() != null && this.identity.getDomain() == null) {
            xml = xml + "          \t<typeOtpAuth>" + this.identity.getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (this.identity.getDomain() != null) {
            xml = xml + "          \t<typeOtpAuth>" + this.identity.getDomain() + "</typeOtpAuth>\n";
        }
        xml = xml + "          \t<user>" + this.identity.getUser() + "</user>\n";
        if (this.identity.getUserPWD() != null) {
            xml = xml + "          \t<userPWD>" + this.identity.getUserPWD() + "</userPWD>\n";
        }
        if (this.identity.getDelegated_domain() != null) {
            xml = xml + "          \t<delegated_domain>" + this.identity.getDelegated_domain() + "</delegated_domain>\n";
        }
        if (this.identity.getDelegated_password() != null) {
            xml = xml + "          \t<delegated_password>" + this.identity.getDelegated_password() + "</delegated_password>\n";
        }
        if (this.identity.getDelegated_user() != null) {
            xml = xml + "          \t<delegated_user>" + this.identity.getDelegated_user() + "</delegated_user>\n";
        }
        xml = xml + "         </Identity>\n         <type>" + type + "</type>\n" + "      </arub:sendCredential>\n" + "   </soapenv:Body>\n" + "</soapenv:Envelope>";
        String xml_ret = this.sendXml(this.login.getSelectedUrl(), xml);
        if (xml_ret != null) {
            try {
                String return_code;
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
                NodeList nl = doc.getElementsByTagName("return_code");
                if (nl.getLength() > 0 && !(return_code = nl.item(0).getTextContent()).equals("0000")) {
                    throw new CapiException("Internal Error", 1003);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new CapiException("Network Error", 1003);
        }
    }

    private String[] auth_methods(String arss_url, it.arubapec.signservice.Auth identity) throws IOException {
        if (this.useRestService) {
            return this.auth_methodsRest(arss_url, identity);
        }
        return this.auth_methodsSoap(arss_url, identity);
    }

    private String[] auth_methodsRest(String arss_url, it.arubapec.signservice.Auth identity) throws IOException {
        ArrayList<String> arrReturn;
        block5: {
            arrReturn = new ArrayList<String>();
            BodyRequestAuthMethod request = new BodyRequestAuthMethod();
            request.setIdentity(this.toARSSAuth(identity));
            String url = arss_url;
            url = url.endsWith("/") ? url + "authMethods" : url + "/authMethods";
            try {
                AuthMethodsReturn response = (AuthMethodsReturn)this.simplerest.post(url).body((Object)request, "application/json").auth(this.cred).asObject(AuthMethodsReturn.class);
                if (response != null && response.getReturn_code() != null && response.getReturn_code().equals("0000")) {
                    if (response.getMethods() != null) {
                        for (String method : response.getMethods()) {
                            if (method == null) continue;
                            arrReturn.add(method);
                        }
                    }
                    break block5;
                }
                throw new IOException("Internal Error");
            }
            catch (RestException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new IOException(ex);
            }
        }
        return arrReturn.toArray(new String[arrReturn.size()]);
    }

    private String[] auth_methodsSoap(String arss_url, it.arubapec.signservice.Auth identity) throws IOException {
        ArrayList<String> arrReturn;
        block12: {
            String xml_ret;
            arrReturn = new ArrayList<String>();
            String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:auth_methods>\n             <identity>\n";
            if (identity.getOtpPwd() != null) {
                xml = xml + "             \t<otpPwd>" + identity.getOtpPwd() + "</otpPwd>\n";
            }
            xml = xml + "          \t<typeHSM>COSIGN</typeHSM>\n";
            if (identity.getTypeOtpAuth() != null && identity.getDomain() == null) {
                xml = xml + "          \t<typeOtpAuth>" + identity.getTypeOtpAuth() + "</typeOtpAuth>\n";
            }
            if (identity.getDomain() != null) {
                xml = xml + "          \t<typeOtpAuth>" + identity.getDomain() + "</typeOtpAuth>\n";
            }
            xml = xml + "          \t<user>" + identity.getUser() + "</user>\n";
            if (identity.getUserPWD() != null) {
                xml = xml + "          \t<userPWD>" + identity.getUserPWD() + "</userPWD>\n";
            }
            if (identity.getDelegated_domain() != null) {
                xml = xml + "          \t<delegated_domain>" + identity.getDelegated_domain() + "</delegated_domain>\n";
            }
            if (identity.getDelegated_password() != null) {
                xml = xml + "          \t<delegated_password>" + identity.getDelegated_password() + "</delegated_password>\n";
            }
            if (identity.getDelegated_user() != null) {
                xml = xml + "          \t<delegated_user>" + identity.getDelegated_user() + "</delegated_user>\n";
            }
            if ((xml_ret = this.sendXml(arss_url, xml = xml + "         </identity>\n    </arub:auth_methods>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
                try {
                    DocumentBuilder db = df.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
                    NodeList nl = doc.getElementsByTagName("return_code");
                    if (nl.getLength() <= 0) break block12;
                    String return_code = nl.item(0).getTextContent();
                    if (return_code.equals("0000")) {
                        NodeList nl2 = doc.getElementsByTagName("methods");
                        for (int i = 0; i < nl2.getLength(); ++i) {
                            arrReturn.add(nl2.item(i).getTextContent());
                        }
                        break block12;
                    }
                    throw new CapiException("Internal Error", 1003);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return arrReturn.toArray(new String[arrReturn.size()]);
    }

    private String opensession(String arss_url, TempPwdRequest req) throws IOException {
        if (this.useRestService) {
            return this.opensessionRest(arss_url, req);
        }
        return this.opensessionSoap(arss_url, req);
    }

    private String opensessionRest(String arss_url, TempPwdRequest req) throws IOException {
        BodyRequestOpenSession request = new BodyRequestOpenSession();
        request.setIdentity(this.toARSSAuth(req.getIdentity()));
        String url = this.login.getSelectedUrl();
        url = url.endsWith("/") ? url + "opensession" : url + "/opensession";
        String ret = null;
        try {
            ret = (String)this.simplerest.post(url).body((Object)request, "application/json").auth(this.cred).asObject(String.class);
        }
        catch (RestException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new IOException(ex);
        }
        return ret;
    }

    private String opensessionSoap(String arss_url, TempPwdRequest req) throws IOException {
        String xml_ret;
        String xml = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:opensession>\n         <Identity>\n";
        if (req.getIdentity().getOtpPwd() != null) {
            xml = xml + "             \t<otpPwd>" + req.getIdentity().getOtpPwd() + "</otpPwd>\n";
        }
        xml = xml + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (req.getIdentity().getTypeOtpAuth() != null && req.getIdentity().getDomain() == null) {
            xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (req.getIdentity().getDomain() != null) {
            xml = xml + "          \t<typeOtpAuth>" + req.getIdentity().getDomain() + "</typeOtpAuth>\n";
        }
        xml = xml + "          \t<user>" + req.getIdentity().getUser() + "</user>\n";
        if (req.getIdentity().getUserPWD() != null) {
            xml = xml + "          \t<userPWD>" + req.getIdentity().getUserPWD() + "</userPWD>\n";
        }
        if (req.getIdentity().getDelegated_domain() != null) {
            xml = xml + "          \t<delegated_domain>" + req.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
        }
        if (req.getIdentity().getDelegated_password() != null) {
            xml = xml + "          \t<delegated_password>" + req.getIdentity().getDelegated_password() + "</delegated_password>\n";
        }
        if (req.getIdentity().getDelegated_user() != null) {
            xml = xml + "          \t<delegated_user>" + req.getIdentity().getDelegated_user() + "</delegated_user>\n";
        }
        if ((xml_ret = this.sendXml(arss_url, xml = xml + "         </Identity>\n      </arub:opensession>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
            try {
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(xml_ret.getBytes()));
                NodeList nl = doc.getElementsByTagName("return");
                if (nl.getLength() > 0) {
                    NodeList nl2 = doc.getElementsByTagName("return");
                    Element objElStat = (Element)nl2.item(0);
                    return objElStat.getTextContent();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public byte[] xmlVerifiedSignature(byte[] digest, String alias) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support verifiedSignarute functionality", 1004);
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        return new byte[0];
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Auth toARSSAuth(it.arubapec.signservice.Auth auth) {
        if (auth == null) {
            return null;
        }
        Auth arssAuth = new Auth();
        arssAuth.setDelegated_domain(auth.getDelegated_domain());
        arssAuth.setDelegated_password(auth.getDelegated_password());
        arssAuth.setDelegated_user(auth.getDelegated_user());
        arssAuth.setOtpPwd(auth.getOtpPwd());
        arssAuth.setTypeHSM("COSIGN");
        arssAuth.setTypeOtpAuth(auth.getTypeOtpAuth());
        arssAuth.setUser(auth.getUser());
        arssAuth.setUserPWD(auth.getUserPWD());
        return arssAuth;
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String digestWithSalt(String message) throws CapiException {
        String message2 = "dkajfw39o2jn1ndwndvcp" + message;
        return Util.dumpHex((byte[])Util.digestStreams((String)Constants.SHA256, (InputStream[])new InputStream[]{new ByteArrayInputStream(message2.getBytes())}));
    }

    private void invalidaCache() {
        resps.remove((Object)this.cacheKey);
    }

    private String argsResolver(String[] args, int index) {
        if (args.length >= index + 1 && args[index] != null) {
            return args[index];
        }
        return null;
    }

    private class LoginCache {
        private CertListResponse resp;
        private String[] authMethods;
        private String selectedUrl;

        public LoginCache(CertListResponse resp, String[] authMethods, String selectedUrl) {
            this.resp = resp;
            this.authMethods = authMethods;
            this.selectedUrl = selectedUrl;
        }

        public CertListResponse getResp() {
            return this.resp;
        }

        public String[] getAuthMethods() {
            return this.authMethods;
        }

        public String getSelectedUrl() {
            return this.selectedUrl;
        }
    }

    private class CertListResponse {
        private Certificato[] certslist;
        private String return_code;

        private CertListResponse() {
        }

        public Certificato[] getCertlist() {
            return this.certslist;
        }

        public void setCertlist(Certificato[] certslist) {
            this.certslist = certslist;
        }

        public String getReturn_code() {
            return this.return_code;
        }

        public void setReturn_code(String return_code) {
            this.return_code = return_code;
        }
    }

    private class Certificato {
        private String id;
        private byte[] content;

        private Certificato() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }
    }
}

