/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.oss.bean.ClientCredentials;
import esecurity.oss.bean.FeaCertificate;
import esecurity.oss.bean.InputParams;
import esecurity.oss.bean.ListFeaCertificateRequest;
import esecurity.oss.bean.ListFeaCertificateResponse;
import esecurity.oss.bean.SignDocRequest;
import esecurity.oss.bean.SignDocResult;
import esecurity.oss.client.OSSFERestProxy;
import esecurity.oss.enumerators.ParamsEnum;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.FeaInitializeParameters;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.logging.Level;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class FeaSignatureToken
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "RemoteSignatureToken";
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private String app1_url = "";
    private String app2_url = "";
    private String selected_url = "";
    private String user;
    private String password;
    private String otp;
    private String verifiedsession;
    private String alias;
    private static NetworkConfig netConf = new NetworkConfig();
    private UrlClient net_client = null;
    private OSSFERestProxy client = null;
    private FeaCertificate[] cert_resp = null;
    private String transactionId = null;
    private boolean suspendAfterSign = false;
    private URLCredentials cred = null;

    public FeaSignatureToken() {
    }

    public FeaSignatureToken(Logger log, URLCredentials creds) {
        if (log != null) {
            logger = log;
        }
        this.cred = creds;
    }

    private String argsResolver(String[] args, int index) {
        if (args.length < index + 1 || args[index] == null) {
            return null;
        }
        return args[index];
    }

    private void initialize() throws CapiException {
        ClientCredentials identity = new ClientCredentials();
        identity.setClientuser(this.user);
        if (this.password != null && !this.password.equals("")) {
            identity.setClientpwd(this.password);
        }
        this.net_client = new UrlClient(netConf, logger);
        this.client = new OSSFERestProxy(logger, this.net_client, this.cred, ArubaTrustStore.getTSRS(), true);
        ListFeaCertificateRequest certsReq = new ListFeaCertificateRequest();
        certsReq.setCredentials(identity);
        certsReq.setTransactionid(this.transactionId);
        try {
            ListFeaCertificateResponse certsResp = this.client.listCerts(this.selected_url, certsReq);
            if (certsResp == null || certsResp.getCode() == null) {
                logger.error("Empty Response");
                throw new CapiException("Network Error", -2147483136);
            }
            if (!certsResp.getCode().equals("0000")) {
                // empty if block
            }
            this.cert_resp = certsResp.getFeaCerts();
        }
        catch (IOException ex) {
            this.cert_resp = new FeaCertificate[0];
            java.util.logging.Logger.getLogger(FeaSignatureToken.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void initializeLib(String[] args) throws CapiException {
        if (args == null || args.length < 5 || args[0] == null || args[1] == null || args[3] == null || args[4] == null || args[5] == null && (args[7] == null || args[8] == null || args[9] == null)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.selected_url = this.argsResolver(args, 0);
            if (Util.isNullOrEmpty((String)this.selected_url)) {
                throw new CapiException("Empty URL: \"" + args[0] + "\"", 1002);
            }
            new URL(this.selected_url);
            logger.debug("Selected url: " + this.selected_url);
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + args[0] + "\"", 1002);
        }
        this.user = this.argsResolver(args, 1);
        if (Util.isNullOrEmpty((String)this.user)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.password = this.argsResolver(args, 2);
        if (Util.isNullOrEmpty((String)this.password)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.transactionId = this.argsResolver(args, 3);
        this.otp = this.argsResolver(args, 4);
        this.verifiedsession = this.argsResolver(args, 5);
        this.suspendAfterSign = this.argsResolver(args, 6) != null ? this.argsResolver(args, 6).equalsIgnoreCase("true") : false;
        this.initialize();
    }

    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        logger.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(args);
    }

    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        if (!(tokenParameters instanceof FeaInitializeParameters)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.selected_url = ((FeaInitializeParameters)tokenParameters).getServiceUrl();
            if (Util.isNullOrEmpty((String)this.selected_url)) {
                throw new CapiException("Empty URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
            }
            new URL(this.selected_url);
            logger.debug("Selected url: " + this.selected_url);
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
        }
        this.user = ((FeaInitializeParameters)tokenParameters).getUsername();
        if (Util.isNullOrEmpty((String)this.user)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.password = ((FeaInitializeParameters)tokenParameters).getPassword();
        if (Util.isNullOrEmpty((String)this.password)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.transactionId = ((FeaInitializeParameters)tokenParameters).getTransactionId();
        this.otp = ((FeaInitializeParameters)tokenParameters).getOtp();
        this.verifiedsession = ((FeaInitializeParameters)tokenParameters).getVerifiedSession();
        this.suspendAfterSign = ((FeaInitializeParameters)tokenParameters).isSuspendAfterSign();
        this.initialize();
    }

    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    public String[] getLibInfo() {
        String tokenType = "FEA Signature";
        String libraryName = "";
        String libraryDescription = "Ellips FEA Signature Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "Actalis S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "Actalis S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "Actalis S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    public int getFreeSpace() throws CapiException {
        return -1;
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    public int getMinPINLen() throws CapiException {
        return 0;
    }

    public void openSession(boolean asSO, String pin) throws CapiException {
        throw new CapiException("openSession not supported", 1004);
    }

    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.cert_resp = null;
        this.transactionId = null;
        this.public_session_open = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return !Util.isNullOrEmpty((String)this.transactionId);
    }

    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String alias) throws CapiException {
        if (alias == null || this.cert_resp == null || this.cert_resp.length == 0) {
            return null;
        }
        for (FeaCertificate feaCertificate : this.cert_resp) {
            if (!feaCertificate.getAlias().equals(alias)) continue;
            return new String(Base64.encode((byte[])feaCertificate.getCertificate()));
        }
        return null;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String alias) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.cert_resp != null && this.cert_resp.length > 0) {
            Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
            ret.setCryptoDev((TokenSpi)this);
            return ret;
        }
        return null;
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        try {
            logger.debug("mode:" + mode);
            logger.debug("DigestInfo:" + new String(Base64.encode((byte[])digest)));
            logger.debug("alias:" + alias);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)digest);
            DigestInfo dinfo = new DigestInfo(seq);
            logger.debug("digest:" + new String(Base64.encode((byte[])dinfo.getDigest())));
            SignDocRequest req = new SignDocRequest();
            ClientCredentials identity = new ClientCredentials();
            identity.setClientuser(this.user);
            identity.setClientpwd(this.password);
            req.setCredentials(identity);
            req.setTransactionid(this.transactionId);
            req.setSuspendAfterSign(this.suspendAfterSign);
            InputParams otpParam = new InputParams();
            if (this.otp != null && !"".equals(this.otp)) {
                otpParam.setName(ParamsEnum.OTP);
                otpParam.setValue(this.otp);
            } else {
                otpParam.setName(ParamsEnum.VERIFIEDSESSION);
                otpParam.setValue(this.verifiedsession);
            }
            InputParams[] params = new InputParams[]{otpParam};
            req.setParams(params);
            req.setDocumenthash(dinfo.getDigest());
            SignDocResult resp = this.client.signDoc(this.selected_url, req);
            logger.debug("return_code" + resp.getCode());
            if (resp.getCode().equals("0000")) {
                return resp.getSignedhash();
            }
            if (resp.getCode().equals("0003")) {
                throw new CapiException("Invalid OTP", 2014);
            }
            if (resp.getCode().equals("1030")) {
                throw new CapiException("Max Signed Reached", 10040);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String expr, byte filter) throws CapiException {
        if (this.cert_resp == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] labels = new String[this.cert_resp.length];
            if (this.cert_resp.length == 0) {
                return labels;
            }
            int i = 0;
            for (FeaCertificate cert : this.cert_resp) {
                String label = cert.getAlias();
                if ((this.getObjectType(label) & filter) == 0 || expr != null && label.indexOf(expr) < 0) continue;
                labels[i] = label;
                ++i;
            }
            if (i == 0) {
                return new String[0];
            }
            String[] res = new String[i];
            for (int j = 0; j < i; ++j) {
                res[j] = labels[j];
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    public boolean exist(String alias) throws CapiException {
        for (String id : this.listObjects(null, (byte)2)) {
            if (!alias.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] args) {
        return this.argsResolver(args, 2) + "@" + this.argsResolver(args, 3);
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public SessionCredentials openSessionWithExtendedAuth(boolean b, String s, ExtendedCredentials extendedCredentials) throws CapiException {
        return null;
    }

    public void resetToken(String s) throws CapiException {
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CapiException {
        return null;
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int i, String s, GeneralNames[] generalNames, String s1) throws CapiException {
        return new byte[0];
    }

    public static void setDefaultNetworkConfig(NetworkConfig conf) {
        netConf = conf;
    }

    public String getSelected_url() {
        return this.selected_url;
    }

    public void setSelected_url(String selected_url) {
        this.selected_url = selected_url;
    }

    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

