/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.internal.asb.gw.GwClient;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.ApplicationAuth;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.Certificato;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

@Deprecated
public class RemoteSignatureToken
extends TokenSpi
implements VerifiedSignatureToken {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "RemoteSignatureToken";
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private String app1_url = "";
    private String app2_url = "";
    private String selected_url = "";
    private String user;
    private String domain;
    private String password;
    private String cns_otp;
    private String delegated_user;
    private String delegated_domain;
    private String delegated_password;
    private String application_user;
    private String application_password;
    private static NetworkConfig netConf = HTTP.defaultConfig;
    private UrlClient net_client = null;
    private GwClientI client = null;
    private CertListResponse cert_resp = null;
    private TempPwdResponse session_resp = null;
    private String[] auth_methods = null;
    private Auth identity = null;
    private ApplicationAuth appidentity = null;
    private boolean enforce_mode = true;

    public RemoteSignatureToken() {
    }

    public RemoteSignatureToken(String user, String domain, String password, String cns_otp, String delegated_user, String delegated_domain, String delegated_password, String selected_url, byte[] cert, String alias, boolean enforce_mode, String applicationusername, String applicationpassword, String basicAuthUser, String basicAuthPwd) {
        this.user = user;
        this.domain = domain;
        this.password = password;
        this.cns_otp = cns_otp;
        this.delegated_user = delegated_user;
        this.delegated_domain = delegated_domain;
        this.delegated_password = delegated_password;
        this.selected_url = selected_url;
        this.enforce_mode = enforce_mode;
        this.application_user = applicationusername;
        this.application_password = applicationpassword;
        this.cert_resp = new CertListResponse();
        this.cert_resp.setStatus("OK");
        Certificato[] certl = new Certificato[1];
        Certificato c = new Certificato();
        c.setContent(cert);
        c.setId(alias);
        certl[0] = c;
        this.cert_resp.setCertlist(certl);
        this.identity = new Auth();
        this.identity.setDomain(domain);
        this.identity.setUser(user);
        if (cns_otp != null) {
            this.identity.setOtpPwd(cns_otp);
        }
        if (password != null && !password.equals("")) {
            this.identity.setUserPWD(password);
        } else if (delegated_password != null) {
            this.identity.setDelegated_user(delegated_user);
            this.identity.setDelegated_domain(delegated_domain);
            this.identity.setDelegated_password(delegated_password);
        }
        this.net_client = new UrlClient(netConf, logger);
        URLCredentials creds = null;
        if (!Util.isNullOrEmpty((String)basicAuthUser) && !Util.isNullOrEmpty((String)basicAuthPwd)) {
            creds = new URLCredentials(basicAuthUser, basicAuthPwd, null, null);
        }
        this.client = GwClient.getInstance(this.net_client, logger, creds, ArubaTrustStore.getTSRS((String)domain), false, enforce_mode, user);
    }

    private String argsResolver(String[] args, int index) {
        if (args.length >= index + 1 && args[index] != null) {
            return args[index];
        }
        return null;
    }

    public void initializeLib(String[] args) throws CapiException {
        this.initProviders(this);
        this.net_client = new UrlClient(netConf, logger);
        if (args == null || args.length < 5 || args[0] == null || args[1] == null || args[3] == null || args[4] == null || args[5] == null && (args[7] == null || args[8] == null || args[9] == null)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.app1_url = this.argsResolver(args, 0);
            if (this.app1_url == null || this.app1_url.trim().equals("")) {
                throw new CapiException("Not valid URL: \"" + this.app1_url + "\"", 1002);
            }
            new URL(this.app1_url);
            logger.debug("App1 url: " + this.app1_url);
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + this.app1_url + "\"", 1002);
        }
        try {
            this.app2_url = this.argsResolver(args, 1);
            if (this.app2_url != null && !this.app2_url.trim().equals("")) {
                new URL(this.app2_url);
                logger.debug("App2 url: " + this.app2_url);
            }
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + this.app2_url + "\"", 1002);
        }
        try {
            this.selected_url = this.argsResolver(args, 2);
            if (this.selected_url != null && !this.selected_url.trim().equals("")) {
                new URL(this.selected_url);
                logger.debug("Forced url: " + this.selected_url);
            }
        }
        catch (MalformedURLException e) {
            throw new CapiException("Not valid URL: \"" + args[2] + "\"", 1002);
        }
        this.user = this.argsResolver(args, 3);
        this.domain = this.argsResolver(args, 4);
        this.password = this.argsResolver(args, 5);
        this.cns_otp = this.argsResolver(args, 6);
        this.enforce_mode = this.argsResolver(args, 10) == null || this.argsResolver(args, 10).equals("S");
        String basicAuthUser = this.argsResolver(args, 13);
        String basicAuthPwd = this.argsResolver(args, 14);
        URLCredentials creds = null;
        if (!Util.isNullOrEmpty((String)basicAuthUser) && !Util.isNullOrEmpty((String)basicAuthPwd)) {
            creds = new URLCredentials(basicAuthUser, basicAuthPwd, null, null);
        }
        this.client = GwClient.getInstance(this.net_client, logger, creds, ArubaTrustStore.getTSRS((String)this.domain), false, this.enforce_mode, this.user);
        this.delegated_user = this.argsResolver(args, 7);
        this.delegated_domain = this.argsResolver(args, 8);
        this.delegated_password = this.argsResolver(args, 9);
        this.application_user = this.argsResolver(args, 11);
        this.application_password = this.argsResolver(args, 12);
        CertsListRequest req = new CertsListRequest();
        this.identity = new Auth();
        this.identity.setDomain(this.domain);
        this.identity.setUser(this.user);
        if (this.cns_otp != null) {
            this.identity.setOtpPwd(this.cns_otp);
        }
        if (this.password != null && !this.password.equals("")) {
            this.identity.setUserPWD(this.password);
        } else if (this.delegated_password != null) {
            this.identity.setDelegated_user(this.delegated_user);
            this.identity.setDelegated_domain(this.delegated_domain);
            this.identity.setDelegated_password(this.delegated_password);
        } else {
            throw new CapiException("Wrong Password", 1002);
        }
        if (this.application_user != null && !"".equals(this.application_user) && this.application_password != null && !"".equals(this.application_password)) {
            this.appidentity = new ApplicationAuth();
            this.appidentity.setApplicationuser(this.application_user);
            this.appidentity.setApplicationpassword(this.application_password);
            this.identity.setAppidentity(this.appidentity);
        }
        req.setIdentity(this.identity);
        if (this.selected_url == null || this.selected_url.trim().equals("")) {
            if (System.currentTimeMillis() % 2L == 0L || this.app2_url == null || this.app2_url.trim().equals("")) {
                try {
                    this.cert_resp = this.client.certlistop(this.app1_url, req);
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                if (this.cert_resp == null) {
                    if (this.app2_url != null) {
                        try {
                            this.cert_resp = this.client.certlistop(this.app2_url, req);
                            if (this.cert_resp == null) {
                                throw new CapiException("Network Error", -2147483136);
                            }
                            this.selected_url = this.app2_url;
                        }
                        catch (IOException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                } else {
                    this.selected_url = this.app1_url;
                }
            } else {
                try {
                    this.cert_resp = this.client.certlistop(this.app2_url, req);
                }
                catch (IOException ex) {
                    throw new CapiException("Network Error", -2147483136);
                }
                if (this.cert_resp == null) {
                    try {
                        this.cert_resp = this.client.certlistop(this.app1_url, req);
                        if (this.cert_resp == null) {
                            throw new CapiException("Network Error", -2147483136);
                        }
                        this.selected_url = this.app1_url;
                    }
                    catch (IOException ex) {
                        throw new CapiException("Network Error", -2147483136);
                    }
                } else {
                    this.selected_url = this.app2_url;
                }
            }
        } else {
            try {
                this.cert_resp = this.client.certlistop(this.selected_url, req);
                if (this.cert_resp == null) {
                    throw new CapiException("Network Error", -2147483136);
                }
            }
            catch (IOException ex) {
                throw new CapiException("Network Error", -2147483136);
            }
        }
        logger.debug("Selezionato URL :" + this.selected_url);
        try {
            this.auth_methods = this.client.auth_methods(this.selected_url, this.identity);
            if (this.auth_methods != null) {
                for (String method : this.auth_methods) {
                    logger.debug("Method enable :" + method);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (this.cert_resp != null && !this.cert_resp.getReturn_code().equals("0000")) {
            if (this.cert_resp.getReturn_code().equals("0025")) {
                throw new CapiException("User Temporary Suspended", 2030);
            }
            throw new CapiException("Invalid Credentials", 2012);
        }
    }

    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        logger.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(args);
    }

    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    public String[] getLibInfo() {
        String tokenType = "Remote Signature";
        String libraryName = "";
        String libraryDescription = "Ellips Remote Signature Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "Actalis S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "Actalis S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "Actalis S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    public int getFreeSpace() throws CapiException {
        return -1;
    }

    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    public int getMinPINLen() throws CapiException {
        return 0;
    }

    public void openSession(boolean asSO, String pin) throws CapiException {
        if (!this.isSessionOpen()) {
            this.session_resp = null;
        }
        try {
            TempPwdRequest req = new TempPwdRequest();
            if (this.application_user != null && !"".equals(this.application_user) && this.application_password != null && !"".equals(this.application_password)) {
                this.appidentity = new ApplicationAuth();
                this.appidentity.setApplicationuser(this.application_user);
                this.appidentity.setApplicationpassword(this.application_password);
                this.identity.setAppidentity(this.appidentity);
            }
            this.identity.setOtpPwd(pin);
            req.setIdentity(this.identity);
            this.session_resp = this.client.temppwd(this.selected_url, req);
            if (this.session_resp == null) {
                throw new CapiException("Network Error", -2147483136);
            }
            if (this.session_resp.getStatus().startsWith("KO-2")) {
                throw new CapiException("Invalid Credentials", 2012);
            }
            if (this.session_resp.getStatus().startsWith("KO-3")) {
                throw new CapiException("Invalid Otp", 2014);
            }
            if (this.session_resp.getStatus().startsWith("KO-1")) {
                throw new CapiException("Invalid Credentials", 2012);
            }
            if (this.session_resp.getStatus().startsWith("KO")) {
                throw new CapiException("Errore interno :" + this.session_resp.getStatus(), 1003);
            }
        }
        catch (IOException ex) {
            throw new CapiException("Network Error", -2147483136);
        }
    }

    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.session_resp = null;
        this.public_session_open = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return this.session_resp != null && this.session_resp.getStatus().startsWith("OK") || this.public_session_open;
    }

    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String alias) throws CapiException {
        if (this.cert_resp != null) {
            for (Certificato cert : this.cert_resp.getCertlist()) {
                if (!cert.getId().equals(alias)) continue;
                return new String(Base64.encode((byte[])cert.getContent()));
            }
        }
        return null;
    }

    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String alias) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.cert_resp != null) {
            for (Certificato cert : this.cert_resp.getCertlist()) {
                if (!cert.getId().equals(alias)) continue;
                Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
                Certificate certf = new Certificate(Base64.decode((String)this.getCert(alias)));
                ret.setPublicInfo((PublicKey)((RSAPublicKey)certf.getInternalCert().getPublicKey()));
                ret.setCryptoDev((TokenSpi)this);
                return ret;
            }
        }
        return null;
    }

    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        try {
            logger.debug("mode:" + mode);
            logger.debug("DigestInfo:" + new String(Base64.encode((byte[])digest)));
            logger.debug("alias:" + alias);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)digest);
            DigestInfo dinfo = new DigestInfo(seq);
            logger.debug("digest:" + new String(Base64.encode((byte[])dinfo.getDigest())));
            SignRequest req = new SignRequest();
            if (this.application_user != null && !"".equals(this.application_user) && this.application_password != null && !"".equals(this.application_password)) {
                this.appidentity = new ApplicationAuth();
                this.appidentity.setApplicationuser(this.application_user);
                this.appidentity.setApplicationpassword(this.application_password);
                this.identity.setAppidentity(this.appidentity);
            }
            this.identity.setOtpPwd(this.session_resp.getTmppwd());
            req.setIdentity(this.identity);
            req.setCertID(alias);
            req.setDataToSign(dinfo.getDigest());
            SignResponse resp = this.client.signop(this.selected_url, req);
            logger.debug("return_code" + resp.getReturn_code());
            if (this.client.getInfoMiddlewareUrl() != null && !"".equals(this.client.getInfoMiddlewareUrl())) {
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0002")) {
                    throw new CapiError("Invalid Credentials", 2012);
                }
                if (resp.getReturn_code().equals("0025")) {
                    throw new CapiError("User Temporary Suspended", 2030);
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            } else {
                if (resp.getReturn_code().equals("0000")) {
                    return resp.getSignData();
                }
                if (resp.getReturn_code().equals("0003")) {
                    throw new CapiError("Invalid OTP", 2014);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiError("Connection errors", 91002);
        }
        return null;
    }

    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String expr, byte filter) throws CapiException {
        if (this.cert_resp == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] labels = new String[this.cert_resp.getCertlist().length];
            if (this.cert_resp.getCertlist().length == 0) {
                return labels;
            }
            int i = 0;
            for (Certificato cert : this.cert_resp.getCertlist()) {
                String label = cert.getId();
                if ((this.getObjectType(label) & filter) == 0 || expr != null && label.indexOf(expr) < 0) continue;
                labels[i] = label;
                ++i;
            }
            if (i == 0) {
                return new String[0];
            }
            String[] res = new String[i];
            for (int j = 0; j < i; ++j) {
                res[j] = labels[j];
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    public boolean exist(String alias) throws CapiException {
        for (String id : this.listObjects(null, (byte)2)) {
            if (!alias.equals(id)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] args) {
        return this.argsResolver(args, 2) + "@" + this.argsResolver(args, 3);
    }

    public String[] getAuth_methods() {
        return this.auth_methods;
    }

    public byte[] verifiedSignature(byte[] digest, String alias) throws CapiException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("signerinfo:" + new String(Base64.encode((byte[])digest)));
            }
            SignRequest req = new SignRequest();
            this.identity.setOtpPwd(this.session_resp.getTmppwd());
            req.setIdentity(this.identity);
            req.setCertID(alias);
            req.setDataToSign(digest);
            req.setSignMech("P7M_SINFO");
            SignResponse resp = this.client.signop(this.selected_url, req);
            logger.debug("return_code" + resp.getReturn_code());
            if (resp.getReturn_code().equals("0000")) {
                return resp.getSignData();
            }
            if (resp.getReturn_code().equals("0003")) {
                throw new CapiError("Invalid OTP", 2014);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiError("Connection errors", 91002);
        }
        return null;
    }

    public static void setDefaultNetworkConfig(NetworkConfig conf) {
        netConf = conf;
    }

    public String getSelected_url() {
        return this.selected_url;
    }

    public byte[] xmlVerifiedSignature(byte[] input, String alias) throws CapiException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("xml_sinfo:" + new String(Base64.encode((byte[])input)));
            }
            SignRequest req = new SignRequest();
            this.identity.setOtpPwd(this.session_resp.getTmppwd());
            req.setIdentity(this.identity);
            req.setCertID(alias);
            req.setDataToSign(input);
            req.setSignMech("XML_SINFO");
            SignResponse resp = this.client.signop(this.selected_url, req);
            logger.debug("return_code" + resp.getReturn_code());
            if (resp.getReturn_code().equals("0000")) {
                return resp.getSignData();
            }
            if (resp.getReturn_code().equals("0003")) {
                throw new CapiError("Invalid OTP", 2014);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiError("Connection errors", 91002);
        }
        return null;
    }

    public void overrideSessionPin(String pin) {
        if (this.session_resp == null) {
            this.session_resp = new TempPwdResponse();
            this.session_resp.setStatus("OK");
            this.session_resp.setDescription("Success");
            this.public_session_open = true;
        }
        this.session_resp.setTmppwd(pin);
    }

    public void setSelected_url(String selected_url) {
        this.selected_url = selected_url;
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        return new byte[0];
    }

    public void initializeLib(TokenParameters param) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

