/*
 * Decompiled with CFR 0.152.
 */
package esecurity.statistics.util;

import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticTimeInfo;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;

public class StatisticsInfoUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static HashMap<String, HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>>> statisticsInfo = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initStatisticInfo() throws CapiException {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        long startTotalTime = System.currentTimeMillis();
        HashMap value = new HashMap();
        StatisticTimeInfo sti = new StatisticTimeInfo();
        sti.start();
        ArrayList<StatisticTimeInfo> values = new ArrayList<StatisticTimeInfo>();
        values.add(sti);
        value.put(StatisticKeyEnum.TOTAL_TIME, values);
        if (statisticsInfo.containsKey(threadId)) {
            logger.error("Tabella gi\u00e0 presente per il thread " + threadId + ". Viene resettata");
        }
        HashMap<String, HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>>> hashMap = statisticsInfo;
        synchronized (hashMap) {
            statisticsInfo.put(threadId, value);
        }
    }

    public static HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> getStatisticInfo() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> objReturn = null;
        try {
            if (statisticsInfo.containsKey(threadId)) {
                objReturn = statisticsInfo.get(threadId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objReturn;
    }

    public static void start(StatisticKeyEnum key) {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        if (statisticsInfo.containsKey(threadId)) {
            HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> threadStats = statisticsInfo.get(threadId);
            StatisticTimeInfo thisTime = new StatisticTimeInfo();
            thisTime.start();
            if (threadStats.containsKey((Object)key)) {
                threadStats.get((Object)key).add(thisTime);
            } else {
                ArrayList<StatisticTimeInfo> keyTimes = new ArrayList<StatisticTimeInfo>();
                keyTimes.add(thisTime);
                threadStats.put(key, keyTimes);
            }
        }
    }

    public static void end(StatisticKeyEnum key) {
        HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> threadStats;
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        if (statisticsInfo.containsKey(threadId) && (threadStats = statisticsInfo.get(threadId)).containsKey((Object)key)) {
            threadStats.get((Object)key).get(threadStats.get((Object)key).size() - 1).end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> clearHeaders() {
        HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>> objReturn;
        block5: {
            objReturn = null;
            String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
            try {
                if (!statisticsInfo.containsKey(threadId)) break block5;
                HashMap<String, HashMap<StatisticKeyEnum, ArrayList<StatisticTimeInfo>>> hashMap = statisticsInfo;
                synchronized (hashMap) {
                    objReturn = statisticsInfo.remove(threadId);
                }
            }
            catch (Exception e) {
                logger.info("Tabella delle statistiche non disponibile", (Throwable)e);
            }
        }
        return objReturn;
    }
}

