/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.TransientDocument;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;

public class ParsedTransientDocument
extends TransientDocument {
    @JsonIgnore
    private boolean invalidFormat = false;

    public ParsedTransientDocument(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        String id = null;
        try {
            id = Utils.calculateDigest(inputHandler.getInputAsNewStream(), Constants.SHA1);
            if (inputHandler.getName() != null) {
                id = id + "_" + inputHandler.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setId(id);
        if (inputHandler.getName() != null) {
            this.setShortName(inputHandler.getName());
        }
    }

    @JsonIgnore
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    @JsonIgnore
    public boolean isInvalidFormat() {
        return this.invalidFormat;
    }

    @JsonIgnore
    public void setInvalidFormat(boolean invalidFormat) {
        this.invalidFormat = invalidFormat;
    }
}

