/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class RefCertificate {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String id;
    private byte[] content;
    private Certificate capiCertificate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @JsonIgnore
    public Certificate getCapiCertificate() {
        if (this.capiCertificate == null && this.content != null) {
            try {
                this.capiCertificate = new Certificate(this.content);
            }
            catch (CapiException ex) {
                logger.error("Certificato non parsabile.");
            }
        }
        return this.capiCertificate;
    }

    public void setCapiCertificate(Certificate capiCertificate) {
        this.capiCertificate = capiCertificate;
    }

    @JsonIgnore
    public boolean equals(Object obj) {
        if (obj instanceof RefCertificate) {
            RefCertificate refObj = (RefCertificate)obj;
            return refObj.getId().equals(this.getId());
        }
        return false;
    }
}

