/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public abstract class ValidatedBean {
    protected LinkedList<ValidatorMessage> messages = new LinkedList();

    public LinkedList<ValidatorMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(LinkedList<ValidatorMessage> messages) {
        for (int i = 0; i < messages.size(); ++i) {
            this.addMessage(messages.get(i));
        }
    }

    @JsonIgnore
    public void addMessage(ValidatorMessage message) {
        if (!this.messages.contains(message)) {
            this.messages.add(message);
        }
    }

    public boolean isValid() {
        boolean blnValid = true;
        for (ValidatorMessage msg : this.messages) {
            if (msg.getLevel() != MessageLevel.ERROR) continue;
            blnValid = false;
            break;
        }
        return blnValid;
    }

    public boolean hasBeanWarnings() {
        boolean blnValid = false;
        for (ValidatorMessage msg : this.messages) {
            if (msg.getLevel() != MessageLevel.WARNING) continue;
            blnValid = true;
            break;
        }
        return blnValid;
    }

    public boolean hasMessage(ValidatorMessageEnum messageCode) {
        return this.hasMessage(messageCode.getCode());
    }

    protected boolean hasMessage(String messageCode) {
        boolean blnFound = false;
        for (ValidatorMessage msg : this.messages) {
            if (!msg.getMessageCode().equals(messageCode)) continue;
            blnFound = true;
            break;
        }
        return blnFound;
    }

    public String getMessageByCode(ValidatorMessageEnum messageCode) {
        String msgValue = null;
        for (ValidatorMessage msg : this.messages) {
            if (!msg.getMessageCode().equals(messageCode.getCode())) continue;
            msgValue = msg.getMessage();
            break;
        }
        return msgValue;
    }
}

