/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ValidatedDocument
extends ValidatedBean
implements Closeable {
    boolean signed;
    private String id;
    private TransientDocument internalDocument;
    private final LinkedList<ValidatedDocument> subResult = new LinkedList();
    private final LinkedList<ValidatedSigner> signers = new LinkedList();
    private ValidatedDocument parent;

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public LinkedList<ValidatedSigner> getTimeStampsOnly() {
        LinkedList<ValidatedSigner> TSonly = new LinkedList<ValidatedSigner>();
        for (int iSigner = 0; iSigner < this.signers.size(); ++iSigner) {
            if (!this.signers.get(iSigner).getFormat().equals((Object)SignatureFormat.TST)) continue;
            TSonly.add(this.signers.get(iSigner));
        }
        return TSonly;
    }

    public LinkedList<ValidatedSigner> getSignersOnly() {
        LinkedList<ValidatedSigner> signersOnly = new LinkedList<ValidatedSigner>();
        for (int iSigner = 0; iSigner < this.signers.size(); ++iSigner) {
            if (this.signers.get(iSigner).getFormat().equals((Object)SignatureFormat.TST)) continue;
            signersOnly.add(this.signers.get(iSigner));
        }
        return signersOnly;
    }

    public LinkedList<ValidatedSigner> getSigners() {
        return this.signers;
    }

    public void setSigners(LinkedList<ValidatedSigner> signers) {
        for (int i = 0; i < signers.size(); ++i) {
            this.addSigner(signers.get(i));
        }
    }

    @JsonIgnore
    public void addSigner(ValidatedSigner signer) {
        if (!this.signers.contains(signer)) {
            this.signers.add(signer);
        }
    }

    public boolean isOverAllOk() {
        ValidatedSigner signer;
        boolean blnReturn = true;
        Iterator i$ = this.signers.iterator();
        while (i$.hasNext() && (blnReturn = this.valid(signer = (ValidatedSigner)i$.next()))) {
        }
        if (blnReturn) {
            for (ValidatedDocument refDoc : this.getSubResults()) {
                for (ValidatorMessage msg : refDoc.getMessages()) {
                    if (!msg.getLevel().equals((Object)MessageLevel.ERROR)) continue;
                    blnReturn = false;
                    break;
                }
                if (blnReturn) continue;
                break;
            }
        }
        return blnReturn;
    }

    public boolean isOverAllOk(boolean checkSubLevel) {
        boolean blnReturn = this.isOverAllOk();
        if (checkSubLevel && blnReturn) {
            for (ValidatedDocument refDoc : this.getSubResults()) {
                if (refDoc.isOverAllOk(true)) continue;
                blnReturn = false;
                break;
            }
        }
        return blnReturn;
    }

    private boolean valid(ValidatedSigner signer) {
        boolean blnReturn = signer.isValid();
        if (blnReturn) {
            ValidatedSigner innerSigner;
            Iterator i$ = signer.getCounterSigners().iterator();
            while (i$.hasNext() && (blnReturn = this.valid(innerSigner = (ValidatedSigner)i$.next()))) {
            }
            if (blnReturn && signer.getTimeStamps() != null) {
                ValidatedSigner timeStamp;
                i$ = signer.getTimeStamps().iterator();
                while (i$.hasNext() && (blnReturn = this.valid(timeStamp = (ValidatedSigner)i$.next()))) {
                }
            }
            if (blnReturn) {
                for (ReferenceDoc refDoc : signer.getRefDocs()) {
                    if (this.id == null || !this.id.equals(refDoc.getId()) || (blnReturn = refDoc.isMessageDigestMatch())) continue;
                    break;
                }
            }
        }
        return blnReturn;
    }

    @Override
    public boolean hasBeanWarnings() {
        boolean blnReturn;
        block4: {
            ValidatedDocument refDoc;
            ValidatedSigner signer;
            blnReturn = false;
            Iterator i$ = this.getReferenceSigners().iterator();
            while (i$.hasNext() && !(blnReturn = (signer = (ValidatedSigner)i$.next()).hasBeanWarnings())) {
                ValidatedSigner tSigner;
                ValidatedSigner cSigner;
                Iterator i$2 = signer.getCounterSigners().iterator();
                while (i$2.hasNext() && !(blnReturn = (cSigner = (ValidatedSigner)i$2.next()).hasBeanWarnings())) {
                }
                if (blnReturn) break;
                i$2 = signer.getTimeStamps().iterator();
                while (i$2.hasNext() && !(blnReturn = (tSigner = (ValidatedSigner)i$2.next()).hasBeanWarnings())) {
                }
                if (!blnReturn) continue;
                break;
            }
            if (blnReturn) break block4;
            i$ = this.getSubResults().iterator();
            while (i$.hasNext() && !(blnReturn = (refDoc = (ValidatedDocument)i$.next()).hasBeanWarnings())) {
            }
        }
        return blnReturn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LinkedList<ValidatedDocument> getSubResults() {
        return this.subResult;
    }

    public void setSubResults(LinkedList<ValidatedDocument> subRes) {
        for (int i = 0; i < subRes.size(); ++i) {
            this.addSubResult(subRes.get(i));
        }
    }

    @JsonIgnore
    public void addSubResult(ValidatedDocument subRes) {
        if (!this.subResult.contains(subRes)) {
            this.subResult.add(subRes);
        }
    }

    @JsonIgnore
    public TransientDocument getInternalDocument() {
        return this.internalDocument;
    }

    @JsonIgnore
    public void setInternalDocument(TransientDocument internalDocument) {
        this.internalDocument = internalDocument;
    }

    @JsonIgnore
    public void finalize() throws Throwable {
        if (this.internalDocument != null) {
            Util.closeQuietly(this.internalDocument);
            this.internalDocument = null;
        }
        super.finalize();
    }

    @Override
    @JsonIgnore
    public void close() throws IOException {
        if (this.internalDocument != null) {
            Util.closeQuietly(this.internalDocument);
            this.internalDocument = null;
        }
    }

    public String getShortName() {
        if (this.internalDocument != null) {
            return this.internalDocument.getShortName();
        }
        return null;
    }

    public void setShortName(String shortName) {
        this.internalDocument.setShortName(shortName);
    }

    @JsonIgnore
    public ValidatedDocument getParent() {
        return this.parent;
    }

    public void setParent(ValidatedDocument parent) {
        this.parent = parent;
    }

    public boolean isReferenceSignersAllOK() {
        ValidatedSigner signer;
        boolean blnReturn = true;
        Iterator i$ = this.getReferenceSigners().iterator();
        while (i$.hasNext() && (blnReturn = this.valid(signer = (ValidatedSigner)i$.next()))) {
        }
        if (blnReturn) {
            for (ValidatedDocument refDoc : this.getSubResults()) {
                for (ValidatorMessage msg : refDoc.getMessages()) {
                    if (!msg.getLevel().equals((Object)MessageLevel.ERROR)) continue;
                    blnReturn = false;
                    break;
                }
                if (blnReturn) continue;
                break;
            }
        }
        return blnReturn;
    }

    public boolean isAllSubDocumentHaveReferenceSigner() {
        boolean blnReturn = true;
        for (ValidatedDocument refDoc : this.getSubResults()) {
            boolean blnTrovatoSigner = false;
            block1: for (ValidatedSigner signer : this.getSigners()) {
                for (ReferenceDoc signedDoc : signer.getRefDocs()) {
                    if (!signedDoc.getId().equals(refDoc.getId())) continue;
                    blnTrovatoSigner = true;
                    continue block1;
                }
            }
            if (blnTrovatoSigner) continue;
            blnReturn = false;
            break;
        }
        return blnReturn;
    }

    @JsonIgnore
    public LinkedList<ValidatedSigner> getReferenceSigners() {
        LinkedList<ValidatedSigner> objReturn = new LinkedList<ValidatedSigner>();
        objReturn.addAll(this.getSigners());
        if (this.getParent() != null) {
            for (ValidatedSigner signer : this.getParent().getSigners()) {
                if (!signer.getContainerFormat().equals((Object)ContainerFormat.ASIC)) continue;
                for (ReferenceDoc signedDoc : signer.getRefDocs()) {
                    if (!signedDoc.getId().equals(this.getId())) continue;
                    objReturn.add(signer);
                }
            }
        }
        return objReturn;
    }

    @JsonIgnore
    public InputHandler getHandler() {
        if (this.internalDocument instanceof ParsedTransientDocument) {
            return ((ParsedTransientDocument)this.internalDocument).getInputHandler();
        }
        return null;
    }
}

