/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser;

import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.annotations.ParserBuilderOrder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public abstract class SignatureParserBuilder
implements Comparable<SignatureParserBuilder> {
    private static List<SignatureParserBuilder> parsers = null;
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public abstract SignatureParser build(InputHandler var1);

    private static synchronized void init() {
        if (parsers == null || parsers.isEmpty()) {
            parsers = new LinkedList<SignatureParserBuilder>();
            ServiceLoader<SignatureParserBuilder> parsersBuilders = ServiceLoader.load(SignatureParserBuilder.class, SignatureParserBuilder.class.getClassLoader());
            Iterator<SignatureParserBuilder> parserIter = parsersBuilders.iterator();
            while (parserIter.hasNext()) {
                parsers.add(parserIter.next());
            }
            try {
                Collections.sort(parsers);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final SignatureParser findParser(InputHandler input) {
        if (parsers == null) {
            SignatureParserBuilder.init();
        }
        SignatureParser bestParser = null;
        SignatureParser parser = null;
        for (SignatureParserBuilder parserBuilder : parsers) {
            parser = parserBuilder.build(input);
            if (parser == null) continue;
            bestParser = parser;
            if (parser.isInvalidFormat()) continue;
            break;
        }
        return bestParser;
    }

    @Override
    public int compareTo(SignatureParserBuilder o) {
        int this_order = SignatureParserBuilder.retrieveOrderAnnotation(this) == null ? 100 : SignatureParserBuilder.retrieveOrderAnnotation(this).order();
        int comparable_order = SignatureParserBuilder.retrieveOrderAnnotation(o) == null ? 100 : SignatureParserBuilder.retrieveOrderAnnotation(o).order();
        return this_order - comparable_order;
    }

    public static ParserBuilderOrder retrieveOrderAnnotation(SignatureParserBuilder contr) {
        ParserBuilderOrder objReturn = null;
        if (contr.getClass().getAnnotations().length > 0) {
            for (Annotation anno : contr.getClass().getAnnotations()) {
                if (!(anno instanceof ParserBuilderOrder)) continue;
                objReturn = (ParserBuilderOrder)anno;
                break;
            }
        }
        return objReturn;
    }
}

