/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.util.TimeZone;
import org.slf4j.Logger;

public class ParserUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static TransientDocument parseDoc(InputHandler input, EventHandlerSelector fileSelector, NetworkConfig config) {
        return ParserUtils.parseDoc(input, fileSelector, config, Constants.DEFAULT_TIMEZONE);
    }

    public static TransientDocument parseDoc(InputHandler input, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone) {
        return ParserUtils.parseDoc(input, fileSelector, config, timeZone, null);
    }

    public static TransientDocument parseDoc(InputHandler input, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) {
        ParsedTransientDocument doc = null;
        SignatureParser parser = SignatureParserBuilder.findParser(input);
        boolean invalidFormat = false;
        if (parser != null) {
            if (parser.isInvalidFormat()) {
                invalidFormat = true;
            } else {
                try {
                    doc = parser.parse(input, fileSelector, config, timeZone, tmpFolder);
                }
                catch (ParsingException ex) {
                    invalidFormat = true;
                    logger.error("some errors parsing the file:" + ex.getMessage());
                }
            }
        }
        if (doc == null) {
            doc = new ParsedTransientDocument(input);
            doc.setSigned(false);
            doc.setInvalidFormat(invalidFormat);
        }
        return doc;
    }
}

