/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepSignatureDPCM45DigestAlgoCheck
extends SingleValidationSubStepImpl {
    public StepSignatureDPCM45DigestAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if ((param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && validationDate.before(Constants.DPCM_AGID_121_2019)) {
            if (param.getSignature() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            SignerInfoData data = param.getSignature().getSignerInfoData();
            if (data == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, this.getClass().getName());
            }
            if (data.getDigestAlgo().equals(DigestAlgorithm.SHA256.getId()) || data.getDigestAlgo().equals(DigestAlgorithm.SHA512.getId())) {
                return null;
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, this.getClass().getName());
        }
        return null;
    }
}

