/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepSignatureDigestAlgorithmCheck
extends SingleValidationSubStepImpl {
    public StepSignatureDigestAlgorithmCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if ((param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && validationDate.after(Constants.DPCM_AGID_121_2019)) {
            if (param.getSignature() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            SignerInfoData data = param.getSignature().getSignerInfoData();
            if (data == null || data.getDigestAlgo() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            DigestAlgorithm digAlgUsed = DigestAlgorithm.valueFromCadesId(data.getDigestAlgo());
            if (digAlgUsed == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, data.getDigestAlgo(), this.getClass().getName());
            }
            if (digAlgUsed.isForbidden()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, digAlgUsed.name(), this.getClass().getName());
            }
            if (!digAlgUsed.isRecommended()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, digAlgUsed.name(), this.getClass().getName());
            }
            return null;
        }
        return null;
    }

    private static enum HASH_ALGORITHMS {
        SHA_256,
        SHA_512;

    }
}

