/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class StepX509IssuerIdentityCheck
extends SingleValidationSubStepImpl {
    public StepX509IssuerIdentityCheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null && param.getSignerCertificate() != null && (param.getSignature() == null || param.getSignature().getFormat() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) && param.getSignerCertificate().getIssuer() != null && param.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier() != null) {
            if (param.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
                boolean valid = false;
                try {
                    String[] c = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] o = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                    String[] cn = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] organizationIdentifier = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.97");
                    if (c != null && c.length == 1 && o != null && o.length == 1 && cn != null && cn.length == 1 && organizationIdentifier != null && organizationIdentifier.length == 1) {
                        valid = true;
                    }
                }
                catch (CapiException e) {
                    valid = false;
                }
                if (!valid) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0018_INVALID_CERT_ISSUER_SEMANTIC, new Object[0]);
                }
            } else if (param.getSignerCertificate().getIssuer().getCert().getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
                boolean valid = false;
                try {
                    String[] c = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                    String[] serialNumber = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.5");
                    String[] cn = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                    String[] givenName = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.42");
                    String[] surname = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.4");
                    String[] pseudonym = param.getSignerCertificate().getIssuer().getCert().getIssuerDNAttribute("2.5.4.65");
                    if (c != null && c.length == 1 && serialNumber != null && serialNumber.length == 1 && cn != null && cn.length == 1 && (givenName != null && givenName.length == 1 && surname != null && surname.length == 1 || pseudonym != null && pseudonym.length == 1)) {
                        valid = true;
                    }
                }
                catch (CapiException e) {
                    valid = false;
                }
                if (!valid) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0018_INVALID_CERT_ISSUER_SEMANTIC, new Object[0]);
                }
            }
        }
        return null;
    }
}

