/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.ValidationDate;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.x509status.CertificateStatus;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.tsl.TSLStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;

public class StepX509Status
extends MultipleValidationSubStepImpl {
    private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public StepX509Status() {
        super(ValidationType.CERTIFICATE);
    }

    protected LinkedList<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> objReturn = new LinkedList<ValidatorMessage>();
        if (param == null || param.getConfig() == null) {
            objReturn.add(new ValidatorMessage(null, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return objReturn;
        }
        if (param.getSignerCertificate() == null) {
            objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return objReturn;
        }
        try {
            if (param.getLevelValidation() == null || param.getLevelValidation().getLevel() != SignatureLevel.LT && param.getLevelValidation().getLevel() != SignatureLevel.LTA) {
                CertDB cdb;
                CertDBItem dbItem;
                ValidatedCertificate vCert = param.getSignerCertificate();
                ValidationDate validationDate = param.getCalculatedValidationDate();
                CertificateStatus sCert = param.getValidator().getStatusService().checkStatus(vCert.getCert(), validationDate);
                sCert.applyToValidate(vCert);
                if (!"NOT FOUND".equals(vCert.getCrlStatus())) {
                    if (vCert.getCrlBean() == null) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0017_OCSP_USED_FOR_CERT_VALIDATION, new Object[0]));
                    } else {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0018_CRL_USED_FOR_CERT_VALIDATION, new Object[0]));
                    }
                }
                this.df.setTimeZone(param.getTimeZone());
                if (vCert.isCertRevoked()) {
                    String revocationDate = this.df.format(vCert.getRevocationDate());
                    if (vCert.getRevocationReason().equalsIgnoreCase("6")) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0006_CERT_SUSPENDED, revocationDate));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    } else {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0007_CERT_REVOKED, revocationDate));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    }
                }
                if (!(vCert.getCertIssuer() == null || vCert.isCertValid() || vCert.isCertRevoked() || vCert.getCrlStatus().equalsIgnoreCase("VALID") || vCert.getCrlStatus().equalsIgnoreCase("VERIFIED SIGNATURE") || (dbItem = (cdb = param.getCertDB()).contains(vCert.getCert().getEncoded().getBytes())) != null && dbItem.getSource() == 1 && !TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, dbItem.getStatus()) && !TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, dbItem.getStatus()))) {
                    if (param.getSignature() != null && param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0004_TSACERT_STATUS_UNKNOWN, new Object[0]));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0005_TSACERT_STATUS_TEMP_UNAVAIABLE, new Object[0]));
                    } else {
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0001_STATUS_UNKNOWN, new Object[0]));
                        objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0002_STATUS_TEMP_UNAVAIABLE, new Object[0]));
                    }
                }
            }
            if (param.getSignerCertificate().getCert().isRsVerified()) {
                objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0015_CERT_VERIFIED, new Object[0]));
            }
        }
        catch (Exception e) {
            objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return objReturn;
    }
}

