/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public class StepX509ValidateCertificateChain
extends MultipleValidationSubStepImpl {
    public StepX509ValidateCertificateChain() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> messages = new LinkedList<ValidatorMessage>();
        if (param != null) {
            if (param.getSignerCertificate() == null) {
                messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
                return messages;
            }
            ValidatedCertificate certificate = param.getSignerCertificate();
            CertDBItem[] certificateChain = certificate.getCert().getValidatedChain();
            if (certificateChain == null || certificateChain.length == 0) {
                messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0028_NO_CHAIN_FOUND, this.getClass().getName()));
                return messages;
            }
            boolean isRoot = true;
            if (certificateChain.length > 1) {
                isRoot = false;
                CertDBItem issuer = certificateChain[1];
                CertDBItem[] issuerChain = new CertDBItem[certificateChain.length - 1];
                System.arraycopy(certificateChain, 1, issuerChain, 0, certificateChain.length - 1);
                try {
                    Certificate issuerCertificate = issuer.getCertificate();
                    issuerCertificate.setValidatedChain(issuerChain);
                    certificate.setIssuer(param.getValidator().validate(issuerCertificate, param.getProfile(), param.getValidationDate()));
                }
                catch (CapiException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            boolean isInCdb = true;
            if (certificateChain[0].getSource() == 4 || certificateChain[0].getSource() == 6) {
                if (isRoot) {
                    isInCdb = false;
                    if (param.getSignature() != null && param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
                    } else {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
                    }
                } else if (certificate.getIssuer() != null) {
                    if (certificate.getIssuer().hasMessage(ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY)) {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0002_INVALID_CERT_AUTHORITY, this.getClass().getName()));
                    } else if (certificate.getIssuer().hasMessage(ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY)) {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0014_INVALID_CERT_TSA_AUTHORITY, this.getClass().getName()));
                    }
                }
            }
            boolean chainValid = param.getCertDB().isValidChain(certificateChain, param.getProfile());
            certificate.setCertTrusted(isInCdb && chainValid);
            if (!chainValid) {
                messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0023_CERT_AUTHORITY_NOT_VALID_FOR_PROFILE, this.getClass().getName()));
            }
            try {
                if (certificate.isCertCorrupted()) {
                    if (param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0012_CERT_TSA_ALTERED, this.getClass().getName()));
                    } else {
                        messages.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0008_CERT_ALTERED, this.getClass().getName()));
                    }
                }
            }
            catch (CapiException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            return messages;
        }
        return null;
    }
}

