/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import java.util.Map;
import org.slf4j.Logger;

class ThreadControlloCertDb
implements Runnable {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private boolean shutdown = false;
    private LRUMap<String, CertDB> dbCache;
    private long sleepTime = 1000L;

    public ThreadControlloCertDb(LRUMap<String, CertDB> dbCache, long sleepTime) {
        this.dbCache = dbCache;
        this.sleepTime = sleepTime;
    }

    public ThreadControlloCertDb(LRUMap<String, CertDB> dbCache) {
        this.dbCache = dbCache;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                Thread.sleep(this.sleepTime);
                for (Map.Entry entry : this.dbCache.entrySet()) {
                    ((CertDB)entry.getValue()).refresh();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

