/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv2;
import it.actalis.ellips.capi.core.qc.QcEuLimitValue;
import it.actalis.ellips.capi.core.qc.QcEuRetentionPeriod;
import it.actalis.ellips.capi.core.qc.QcKnown;
import it.actalis.ellips.capi.core.qc.QcPDS;
import it.actalis.ellips.capi.core.qc.QcStatement;
import it.actalis.ellips.capi.core.qc.QcStatements;
import it.actalis.ellips.capi.core.qc.QcType;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Certificate {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String NO_CERT_FOUND_INSIDE_SIGNATURE = "NO_CERT_FOUND_INSIDE_SIGNATURE";
    public static final int digitalSignature = 1;
    public static final int nonRepudiation = 2;
    public static final int keyEncipherment = 4;
    public static final int dataEncipherment = 8;
    public static final int keyAgreement = 16;
    public static final int keyCertSign = 32;
    public static final int cRLSign = 64;
    public static final int encipherOnly = 128;
    public static final int decipherOnly = 256;
    public static final int EXT_AuthorityKeyIdentifier = 1;
    public static final int EXT_BasicConstraints = 2;
    public static final int EXT_CertificatePolicies = 3;
    public static final int EXT_CRLDistributionPoints = 4;
    public static final int EXT_IssuerAltName = 5;
    public static final int EXT_KeyUsage = 6;
    public static final int EXT_SubjectAltName = 11;
    public static final int EXT_SubjectKeyIdentifier = 12;
    public static final int EXT_SubjectDirectoryAttributes = 13;
    public static final int EXT_AuthorityInfoAccess = 14;
    public static final int EXT_ExtendedKeyUsage = 30;
    public static final int EXT_QCStatements = 40;
    private static CertificateFactory cf;
    private static CertificateFactory oracleCf;
    private static final List<String> tslCnsIDList;
    private static final List<String> tslCieIDList;
    private CertDBItem[] validatedChain = null;
    private boolean verbose = true;
    X509Certificate internalCert = null;
    private Boolean isCNSAuthentication = null;
    private Boolean issuedAfterSPIDAuthentication = null;
    private Boolean isCIEAuthentication = null;
    private static Hashtable<String, String> oidToNameHT;
    private static Hashtable<Integer, String> generalNameHT;
    private static Hashtable<String, ASN1ObjectIdentifier> nameToOid;
    private static Hashtable<String, String> extKeyUsageHT;

    public static boolean isPolicyIncluded(String objectId, List<String> tslList) {
        for (String tslID : tslList) {
            String[] objectIdTokens;
            for (String objectIdToken : objectIdTokens = objectId.split(";")) {
                if (!tslID.equals(objectIdToken)) continue;
                return true;
            }
        }
        return false;
    }

    public Certificate(byte[] encoded) throws CapiException {
        this(encoded, true);
    }

    public Certificate(byte[] encoded, boolean verbose) throws CapiException {
        this.verbose = verbose;
        if (verbose) {
            logger.debug("Certificate constructor");
        }
        if (encoded == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            this.internalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encoded));
            if (this.internalCert == null) {
                if (verbose) {
                    logger.debug("Probably this is an IMB JRE, internal cert is null, retry as base64");
                }
                throw new CertificateException("IBM problem");
            }
        }
        catch (CertificateException se) {
            byte[] derCer = Base64.decode((byte[])encoded);
            try {
                this.internalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(derCer));
                if (verbose) {
                    logger.debug("TEMPDEBUG certificate factory is {}", (Object)cf.getClass().getName());
                }
                if (this.internalCert == null) {
                    throw new CapiException("Certificate format unknown or not implemented", 30002);
                }
            }
            catch (CertificateException e) {
                if (verbose) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new CapiException("Certificate format unknown or not implemented", 30002);
            }
        }
        catch (Exception e) {
            if (verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public Certificate(X509Certificate cert) {
        this.internalCert = cert;
    }

    public X509Certificate getInternalCert() {
        return this.internalCert;
    }

    public String getEncoded() throws CapiException {
        try {
            if (this.internalCert == null) {
                throw new CapiException("Internal error", 30005);
            }
            byte[] dercert = this.internalCert.getEncoded();
            return Util.base64EncodeStr(dercert);
        }
        catch (CertificateEncodingException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public byte[] getDerEncoded() throws CapiException {
        try {
            if (this.internalCert == null) {
                throw new CapiException("Internal error", 30005);
            }
            byte[] dercert = this.internalCert.getEncoded();
            return dercert;
        }
        catch (CertificateEncodingException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public String getIssuerDN() {
        X500Principal p = this.internalCert.getIssuerX500Principal();
        String s = p.toString();
        String newRet = s.replaceAll(", (?=(?<!\\\\, ))(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", ",");
        return newRet;
    }

    public String[] getIssuerDNAttribute(String attributeOID) throws CapiException {
        if (attributeOID == null) {
            throw new CapiException("Null parameters", 1001);
        }
        String oid = null;
        if (attributeOID.indexOf(".") == -1) {
            ASN1ObjectIdentifier v = nameToOid.get(attributeOID.toLowerCase());
            oid = v.getId();
            if (oid == null) {
                throw new CapiException("Unsupported Attribute Name", 1002);
            }
        } else {
            oid = attributeOID;
        }
        try {
            X500Name x500name = JcaX500NameUtil.getIssuer((X509Certificate)this.internalCert);
            if (x500name == null) {
                return null;
            }
            RDN[] rdns = x500name.getRDNs(new ASN1ObjectIdentifier(oid));
            Vector<String> ret = new Vector<String>();
            if (rdns == null || rdns.length == 0) {
                return null;
            }
            for (int i = 0; i < rdns.length; ++i) {
                if (!rdns[i].isMultiValued()) {
                    ret.add(IETFUtils.valueToString((ASN1Encodable)rdns[i].getFirst().getValue()));
                    continue;
                }
                AttributeTypeAndValue[] atts = rdns[i].getTypesAndValues();
                if (atts == null || atts.length == 0) continue;
                for (int k = 0; k < atts.length; ++k) {
                    ret.add(IETFUtils.valueToString((ASN1Encodable)atts[k].getValue()));
                }
            }
            if (ret.size() == 0) {
                return new String[0];
            }
            String[] vals = new String[ret.size()];
            for (int i = 0; i < ret.size(); ++i) {
                vals[i] = (String)ret.elementAt(i);
            }
            return vals;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage());
            }
            throw new CapiException("Issuer name format alert", 30002);
        }
    }

    public String getSubjectDN() {
        X500Principal p = this.internalCert.getSubjectX500Principal();
        String s = p.toString();
        if (this.verbose) {
            logger.debug("Principal.toString: {}", (Object)s);
        }
        String newRet = s.replaceAll(", (?=(?<!\\\\, ))(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", ",");
        String nospace = newRet.replaceAll("\\+ ", "\\+");
        return nospace.replaceAll(" \\+", "\\+");
    }

    public String[] getSubjectDNAttribute(String attributeOID) throws CapiException {
        if (attributeOID == null) {
            throw new CapiException("Null parameters", 1001);
        }
        String oid = null;
        if (attributeOID.indexOf(".") == -1) {
            ASN1ObjectIdentifier v = nameToOid.get(attributeOID.toLowerCase());
            if (v == null) {
                throw new CapiException("Unsupported Attribute Name", 1002);
            }
            oid = v.getId();
            if (oid == null) {
                throw new CapiException("Unsupported Attribute Name", 1002);
            }
        } else {
            oid = attributeOID;
        }
        try {
            X500Name x500name = JcaX500NameUtil.getSubject((X509Certificate)this.internalCert);
            if (x500name == null) {
                return null;
            }
            RDN[] rdns = x500name.getRDNs(new ASN1ObjectIdentifier(oid));
            Vector<String> ret = new Vector<String>();
            if (rdns == null || rdns.length == 0) {
                return null;
            }
            for (int i = 0; i < rdns.length; ++i) {
                AttributeTypeAndValue[] atts;
                if (!rdns[i].isMultiValued()) {
                    if (this.verbose) {
                        logger.debug("{} is not multivalue", (Object)attributeOID);
                    }
                    ret.add(IETFUtils.valueToString((ASN1Encodable)rdns[i].getFirst().getValue()));
                    continue;
                }
                if (this.verbose) {
                    logger.debug("{} is multivalue", (Object)attributeOID);
                }
                if ((atts = rdns[i].getTypesAndValues()) == null || atts.length == 0) continue;
                for (int k = 0; k < atts.length; ++k) {
                    if (atts[k].getType().getId().compareToIgnoreCase(oid) != 0) continue;
                    if (this.verbose) {
                        logger.debug("adding: {}", (Object)IETFUtils.valueToString((ASN1Encodable)atts[k].getValue()));
                    }
                    ret.add(IETFUtils.valueToString((ASN1Encodable)atts[k].getValue()));
                }
            }
            if (ret.size() == 0) {
                return new String[0];
            }
            String[] vals = new String[ret.size()];
            for (int i = 0; i < ret.size(); ++i) {
                vals[i] = (String)ret.elementAt(i);
            }
            return vals;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage());
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public String getSubjectCommonName() throws CapiException {
        try {
            X500Name x500name = JcaX500NameUtil.getSubject((X509Certificate)this.internalCert);
            RDN[] rdns = x500name.getRDNs(BCStyle.CN);
            for (int i = 0; i != rdns.length; ++i) {
                RDN rdn = rdns[i];
                if (rdn.isMultiValued()) {
                    AttributeTypeAndValue[] attr = rdn.getTypesAndValues();
                    for (int j = 0; j != attr.length; ++j) {
                        if (!attr[j].getType().equals((ASN1Primitive)BCStyle.CN)) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attr[j].getValue());
                    }
                    if (attr == null || attr.length <= 0) continue;
                    return IETFUtils.valueToString((ASN1Encodable)attr[0].getValue());
                }
                return IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
            }
            return null;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage());
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public String[] getSubjectOrganization() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.10");
    }

    public String[] getSubjectCountry() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.6");
    }

    public String[] getSubjectTitle() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.12");
    }

    public String[] getSubjectOrganizationalUnit() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.11");
    }

    public String[] getSubjectSerialNumber() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.5");
    }

    public String[] getSubjectSurname() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.4");
    }

    public String[] getSubjectGivenName() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.42");
    }

    public String[] getSubjectDNQ() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.46");
    }

    public String getName() {
        String name;
        block12: {
            block11: {
                name = null;
                try {
                    name = this.getSubjectCommonName();
                    if (name != null) {
                        return name;
                    }
                }
                catch (Exception e) {
                    if (!this.verbose) break block11;
                    logger.debug(e.getMessage());
                }
            }
            String ret = "";
            try {
                int j;
                AttributeTypeAndValue[] attr;
                RDN rdn;
                int i;
                X500Name x500name = JcaX500NameUtil.getSubject((X509Certificate)this.internalCert);
                RDN[] rdns = x500name.getRDNs(BCStyle.OU);
                for (i = 0; i != rdns.length; ++i) {
                    rdn = rdns[i];
                    if (rdn.isMultiValued()) {
                        attr = rdn.getTypesAndValues();
                        for (j = 0; j != attr.length; ++j) {
                            if (!attr[j].getType().equals((ASN1Primitive)BCStyle.OU)) continue;
                            return IETFUtils.valueToString((ASN1Encodable)attr[j].getValue());
                        }
                        if (attr == null || attr.length <= 0) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attr[0].getValue());
                    }
                    return IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                }
                rdns = x500name.getRDNs(BCStyle.O);
                for (i = 0; i != rdns.length; ++i) {
                    rdn = rdns[i];
                    if (rdn.isMultiValued()) {
                        attr = rdn.getTypesAndValues();
                        for (j = 0; j != attr.length; ++j) {
                            if (!attr[j].getType().equals((ASN1Primitive)BCStyle.O)) continue;
                            return IETFUtils.valueToString((ASN1Encodable)attr[j].getValue());
                        }
                        if (attr == null || attr.length <= 0) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attr[0].getValue());
                    }
                    return IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                }
                name = this.getSubjectDN();
            }
            catch (Exception e) {
                if (!this.verbose) break block12;
                logger.debug(e.getMessage());
            }
        }
        return name;
    }

    public String[] getSubjectAltName() throws CapiException {
        try {
            byte[] sa = this.internalCert.getExtensionValue(Extension.subjectAlternativeName.getId());
            if (sa == null) {
                return new String[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sa));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1Sequence saSeq = ASN1Sequence.getInstance((Object)extIn.readObject());
            if (saSeq == null || saSeq.size() == 0) {
                return new String[0];
            }
            Vector<String> v = new Vector<String>();
            v.setSize(0);
            for (int i = 0; i < saSeq.size(); ++i) {
                GeneralName gn = GeneralName.getInstance((Object)saSeq.getObjectAt(i));
                String gnstr = generalNameHT.get(new Integer(gn.getTagNo())) + ": " + gn.getName().toString();
                v.addElement(gnstr);
            }
            String[] list = new String[v.size()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = (String)v.elementAt(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public BigInteger getSerialNumber() throws CapiException {
        try {
            return this.internalCert.getSerialNumber();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Serial number format alert", 30002);
        }
    }

    public String getValidityNotAfter(String format) throws CapiException {
        try {
            Date d = this.internalCert.getNotAfter();
            if (this.verbose) {
                logger.debug("getNotAfter date: {}", (Object)d);
            }
            return Util.formatDate(d, format);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public String getValidityNotAfter(String format, String TimeZone2) throws CapiException {
        try {
            Date d = this.internalCert.getNotAfter();
            if (this.verbose) {
                logger.debug("getNotAfter date: {}", (Object)d);
            }
            return Util.formatDate(d, format, TimeZone2);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public String getValidityNotBefore(String format) throws CapiException {
        return this.getValidityNotBefore(format, null);
    }

    public String getValidityNotBefore(String format, String TimeZone2) throws CapiException {
        try {
            Date d = this.internalCert.getNotBefore();
            if (this.verbose) {
                logger.debug("getNotBefore date: {}", (Object)d);
            }
            return Util.formatDate(d, format, TimeZone2);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public void isValid() throws CertificateExpiredException, CertificateNotYetValidException, CapiException {
        try {
            this.internalCert.checkValidity();
        }
        catch (java.security.cert.CertificateExpiredException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CertificateExpiredException();
        }
        catch (java.security.cert.CertificateNotYetValidException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CertificateNotYetValidException();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public void isValid(String date, String dateformat) throws CertificateExpiredException, CertificateNotYetValidException, CapiException {
        if (date == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Date dt = Util.parseDate(date, dateformat);
            if (this.verbose) {
                logger.debug("parsed date: {}", (Object)dt);
            }
            this.internalCert.checkValidity(dt);
        }
        catch (java.security.cert.CertificateExpiredException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CertificateExpiredException();
        }
        catch (java.security.cert.CertificateNotYetValidException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CertificateNotYetValidException();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getRemainingValidityDays() {
        try {
            this.isValid();
        }
        catch (CapiException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return -1;
        }
        try {
            long expire = this.internalCert.getNotAfter().getTime();
            long now = new Date().getTime();
            long remain_ms = expire - now;
            return (int)(remain_ms / 86400000L + 1L);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return -2;
        }
    }

    public void verify(byte[] cacert) throws CapiException {
        byte[] ski;
        byte[] aki;
        Certificate issuerCert;
        block21: {
            block20: {
                block19: {
                    if (cacert == null) {
                        throw new CapiException("Null parameters", 1001);
                    }
                    issuerCert = new Certificate(cacert);
                    String subject = issuerCert.getSubjectDN();
                    if (!this.getIssuerDN().equalsIgnoreCase(subject)) {
                        throw new CapiException("IssuerDN does not match", 30004);
                    }
                    PublicKey issuerPublicKey = null;
                    try {
                        issuerPublicKey = issuerCert.getPublicKey();
                        this.internalCert.verify(issuerPublicKey);
                        return;
                    }
                    catch (SignatureException e) {
                        if (this.verbose) {
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (this.verbose) {
                                logger.debug(e.getMessage(), (Throwable)e);
                            }
                            ByteArrayInputStream bais = new ByteArrayInputStream(this.internalCert.getEncoded());
                            X509Certificate oracleInternalCert = (X509Certificate)oracleCf.generateCertificate(bais);
                            oracleInternalCert.verify(issuerPublicKey);
                            return;
                        }
                        catch (Exception ex) {
                            if (!this.verbose) break block19;
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                aki = null;
                try {
                    aki = this.getAuthorityKeyIdentifier();
                    if (aki.length == 0) {
                        aki = null;
                    }
                }
                catch (CapiException e) {
                    if (!this.verbose) break block20;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            ski = null;
            try {
                ski = issuerCert.getSubjectKeyIdentifier();
                if (ski.length == 0) {
                    ski = null;
                }
            }
            catch (CapiException e) {
                if (!this.verbose) break block21;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (issuerCert.getBasicConstraints()) {
            if (ski == null) {
                throw new CapiException("SubjectKeyIdentifier not present", 30006);
            }
            if (issuerCert.isCritical(12)) {
                throw new CapiException("SubjectKeyIdentifier critical", 30006);
            }
        }
        if (aki != null && ski != null && Util.equalsBlock(aki, ski)) {
            throw new CapiException("The signature is not valid but the AuthKeyId and the issuer SubjectKeyId are the same", 30007);
        }
        throw new CapiException("The signature is not valid", 30003);
    }

    public String getFingerprint(String algoID) throws CapiException {
        if (algoID == null) {
            algoID = "SHA-1";
        }
        if (this.internalCert == null) {
            throw new CapiException("Internal error", 30005);
        }
        if (this.verbose) {
            logger.debug("getFingerprint: {}", (Object)algoID);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algoID, ProvUtils.bcProvider);
            md.update(this.internalCert.getEncoded());
            byte[] fp = md.digest();
            byte[] ret = Hex.encode((byte[])fp);
            String oldStr = new String(Hex.encode((byte[])fp));
            String newStr = "";
            for (int i = 0; i < ret.length; i += 2) {
                newStr = newStr + oldStr.substring(i, i + 2);
                if (i >= ret.length - 2) continue;
                newStr = newStr + ":";
            }
            return newStr.toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Wrong args", 1002);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getKeyUsageBits() throws CapiException {
        if (this.verbose) {
            logger.debug("getKeyUsageBits");
        }
        try {
            if (!this.isCritical(6)) {
                return 0;
            }
            return this.getKeyUsage();
        }
        catch (CapiException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String keyUsageToString(int keyUsage) throws CapiException {
        try {
            boolean[] keyUsageArray = this.internalCert.getKeyUsage();
            if (keyUsageArray == null) {
                return "no KeyUsage";
            }
            String[] keyBitName = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
            String ret = "";
            boolean first = true;
            for (int i = 0; i < keyUsageArray.length && i < keyBitName.length; ++i) {
                if (!keyUsageArray[i]) continue;
                if (!first) {
                    ret = ret + " | ";
                }
                ret = ret + keyBitName[i];
                first = false;
            }
            if (ret.compareTo("") == 0 || ret.length() == 0) {
                return "no KeyUsage";
            }
            return ret;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasBasicConstraints() throws CapiException {
        try {
            int bc = this.internalCert.getBasicConstraints();
            if (this.verbose) {
                logger.debug("basic constraints is {}", (Object)bc);
            }
            if (bc == -1) {
                return false;
            }
            if (bc == Integer.MAX_VALUE) {
                return false;
            }
            if (this.verbose) {
                logger.debug("basic constraints is not null");
            }
            return true;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean getBasicConstraints() throws CapiException {
        try {
            int bc = this.internalCert.getBasicConstraints();
            if (this.verbose) {
                logger.debug("basic constraints is {}", (Object)bc);
            }
            if (bc == -1) {
                return false;
            }
            if (bc == Integer.MAX_VALUE) {
                return true;
            }
            if (this.verbose) {
                logger.debug("basic constraints is not null");
            }
            return true;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getBasicConstraintsPathLen() throws CapiException {
        try {
            int bc = this.internalCert.getBasicConstraints();
            if (this.verbose) {
                logger.debug("basic constraints is {}", (Object)bc);
            }
            if (bc == -1) {
                return -1;
            }
            if (bc == Integer.MAX_VALUE) {
                return -1;
            }
            if (this.verbose) {
                logger.debug("basic constraints is not null");
            }
            return bc;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getPolicies(char separator) throws CapiException {
        try {
            byte[] certPolicies = this.internalCert.getExtensionValue(Extension.certificatePolicies.getId());
            if (certPolicies == null) {
                return new String[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])certPolicies));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1Sequence cpSeq = ASN1Sequence.getInstance((Object)extIn.readObject());
            if (cpSeq == null) {
                return new String[0];
            }
            String[] list = new String[cpSeq.size()];
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < cpSeq.size(); ++i) {
                sb.setLength(0);
                PolicyInformation pi = null;
                try {
                    pi = PolicyInformation.getInstance((Object)cpSeq.getObjectAt(i));
                }
                catch (IllegalArgumentException ex) {
                    list = new String[2];
                    logger.error("Malformed policies! Expected sequences must be 1 or 2." + ex.getMessage());
                    ASN1Sequence seqOld = ASN1Sequence.getInstance((Object)cpSeq.getObjectAt(i));
                    ASN1Encodable[] encodables = seqOld.toArray();
                    sb.append(encodables[0].toString());
                    sb.append(separator);
                    ASN1Sequence seqNew = ASN1Sequence.getInstance((Object)encodables[1]);
                    ASN1Encodable[] encodables1 = seqNew.toArray();
                    sb.append(encodables1[0].toString());
                    sb.append(separator);
                    list[0] = sb.toString();
                    sb.setLength(0);
                    seqNew = ASN1Sequence.getInstance((Object)encodables[2]);
                    ASN1Encodable[] encodables2 = seqNew.toArray();
                    sb.append(encodables2[0].toString());
                    list[1] = sb.toString();
                    logger.info("Try to recover:");
                    for (String s : list) {
                        logger.info("- policy: " + s);
                    }
                    return list;
                }
                sb.append(pi.getPolicyIdentifier().getId());
                sb.append(separator);
                ASN1Sequence pqiSeq = pi.getPolicyQualifiers();
                if (pqiSeq != null) {
                    for (int j = 0; j < pqiSeq.size(); ++j) {
                        PolicyQualifierInfo pqi = PolicyQualifierInfo.getInstance((Object)pqiSeq.getObjectAt(j));
                        ASN1ObjectIdentifier id = pqi.getPolicyQualifierId();
                        if (id.equals((ASN1Primitive)PolicyQualifierId.id_qt_cps)) {
                            sb.append("CPS URI: " + pqi.getQualifier().toString());
                            sb.append(separator);
                            continue;
                        }
                        if (!id.equals((ASN1Primitive)PolicyQualifierId.id_qt_unotice)) continue;
                        UserNotice un = UserNotice.getInstance((Object)pqi.getQualifier());
                        NoticeReference nr = un.getNoticeRef();
                        DisplayText dt = un.getExplicitText();
                        if (nr != null) {
                            ASN1Integer[] nNumSeq;
                            DisplayText org = nr.getOrganization();
                            if (org != null) {
                                sb.append("organization: " + org.getString());
                            }
                            if ((nNumSeq = nr.getNoticeNumbers()) != null) {
                                for (int n = 0; n < nNumSeq.length; ++n) {
                                    sb.append(" " + nNumSeq[n].getValue());
                                }
                            }
                            sb.append(separator);
                        }
                        if (dt == null) continue;
                        try {
                            if (this.verbose) {
                                logger.debug("[getPolicies] displayText getString: {}", (Object)dt.getString());
                            }
                            sb.append("displayText: " + dt.getString());
                            sb.append(separator);
                            continue;
                        }
                        catch (Exception e) {
                            try {
                                DERGeneralString gs = DERGeneralString.getInstance((Object)dt);
                                if (gs == null) continue;
                                sb.append("displayText: " + gs.getString());
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                list[i] = sb.toString();
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasExtension(String oid) throws CapiException {
        if (this.verbose) {
            logger.debug("hasInhibitAnyPolicyExtension");
        }
        try {
            byte[] extension = this.internalCert.getExtensionValue(oid);
            if (extension == null) {
                return false;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])extension));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1Sequence cpSeq = ASN1Sequence.getInstance((Object)extIn.readObject());
            return cpSeq != null;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getCdpURLs() throws CapiException {
        try {
            byte[] v3e = this.internalCert.getExtensionValue(Extension.cRLDistributionPoints.getId());
            if (v3e == null) {
                return new String[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])v3e));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            CRLDistPoint cdp = CRLDistPoint.getInstance((Object)extIn.readObject());
            if (cdp == null) {
                return new String[0];
            }
            Vector<String> v = new Vector<String>();
            v.setSize(0);
            DistributionPoint[] points = cdp.getDistributionPoints();
            for (int i = 0; i != points.length; ++i) {
                DistributionPoint dp = points[i];
                DistributionPointName dpn = dp.getDistributionPoint();
                GeneralNames gns = (GeneralNames)points[i].getDistributionPoint().getName();
                GeneralName[] vgn = gns.getNames();
                for (int j = 0; j < vgn.length; ++j) {
                    ASN1String s;
                    if (vgn[j].getTagNo() == 6) {
                        s = (ASN1String)vgn[j].getName();
                        v.addElement(s.getString());
                        continue;
                    }
                    if (vgn[j].getTagNo() == 4) {
                        s = (X500Name)vgn[j].getName();
                        v.addElement(s.toString());
                        continue;
                    }
                    v.addElement(vgn[j].toString());
                }
            }
            String[] list = new String[v.size()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = (String)v.elementAt(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String toString() {
        try {
            String newline = System.getProperty("line.separator");
            String ret = "Version: " + this.getVersion() + newline;
            ret = ret + "Serial number: " + this.getSerialNumber() + newline;
            ret = ret + "Signature algorithm: " + this.getSigAlgName() + newline;
            ret = ret + "Issuer: " + this.getIssuerDN() + newline;
            ret = ret + "Valid not before: " + this.getValidityNotBefore("EEE, d MMM yyyy HH:mm:ss Z") + newline;
            ret = ret + "Valid not after: " + this.getValidityNotAfter("EEE, d MMM yyyy HH:mm:ss Z") + newline;
            ret = ret + "Subject: " + this.getSubjectDN() + newline;
            ret = ret + this.getPublicKey().toString() + newline;
            ret = ret + "Certificate Fingerprint (SHA256) " + this.getFingerprint("SHA-256") + newline;
            ret = ret + "Certificate Fingerprint (SHA-1) " + this.getFingerprint("SHA-1") + newline;
            int ext = this.internalCert.getCriticalExtensionOIDs().size() + this.internalCert.getNonCriticalExtensionOIDs().size();
            ret = ret + "Extensions: " + ext + newline;
            return ret;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Certificate) {
            Certificate c = (Certificate)obj;
            return this.internalCert.equals(c.internalCert);
        }
        return false;
    }

    public String getSigAlgName() throws CapiException {
        try {
            return this.internalCert.getSigAlgName();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("SigAlgName format alert", 30002);
        }
    }

    public int getVersion() throws CapiException {
        try {
            return this.internalCert.getVersion();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Version format alert", 30002);
        }
    }

    public String[] getExtendedKeyUsageAsString() throws CapiException {
        try {
            List<String> extKeyUsageList = this.internalCert.getExtendedKeyUsage();
            if (extKeyUsageList == null) {
                return new String[0];
            }
            if (extKeyUsageList.size() == 0) {
                return new String[0];
            }
            String[] list = new String[extKeyUsageList.size()];
            for (int i = 0; i < extKeyUsageList.size(); ++i) {
                if (extKeyUsageList.get(i) == null) continue;
                String extKeyUsageName = extKeyUsageHT.get(extKeyUsageList.get(i));
                list[i] = extKeyUsageName != null ? extKeyUsageName : extKeyUsageList.get(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getExtendedKeyUsage() throws CapiException {
        try {
            List<String> extKeyUsageList = this.internalCert.getExtendedKeyUsage();
            if (extKeyUsageList == null) {
                return new String[0];
            }
            if (extKeyUsageList.size() == 0) {
                return new String[0];
            }
            String[] list = new String[extKeyUsageList.size()];
            for (int i = 0; i < extKeyUsageList.size(); ++i) {
                list[i] = extKeyUsageList.get(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getIssuerAltName() throws CapiException {
        try {
            byte[] isa = this.internalCert.getExtensionValue(Extension.issuerAlternativeName.getId());
            if (isa == null) {
                return new String[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])isa));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1Sequence isaSeq = ASN1Sequence.getInstance((Object)extIn.readObject());
            if (isaSeq == null || isaSeq.size() == 0) {
                return new String[0];
            }
            Vector<String> v = new Vector<String>();
            v.setSize(0);
            for (int i = 0; i < isaSeq.size(); ++i) {
                GeneralName gn = GeneralName.getInstance((Object)isaSeq.getObjectAt(i));
                String gnstr = generalNameHT.get(new Integer(gn.getTagNo())) + ": " + gn.getName().toString();
                v.addElement(gnstr);
            }
            String[] list = new String[v.size()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = (String)v.elementAt(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getAuthorityInfoAccess() throws CapiException {
        try {
            byte[] aia = this.internalCert.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (aia == null) {
                return new String[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aia));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            AuthorityInformationAccess authInAcc = AuthorityInformationAccess.getInstance((Object)extIn.readObject());
            AccessDescription[] accDescr = authInAcc.getAccessDescriptions();
            if (accDescr == null || accDescr.length == 0) {
                return new String[0];
            }
            Vector<String> v = new Vector<String>();
            v.setSize(0);
            for (int i = 0; i < accDescr.length; ++i) {
                String adstr;
                if (accDescr[i] != null && accDescr[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) {
                    adstr = "ocsp;" + generalNameHT.get(new Integer(accDescr[i].getAccessLocation().getTagNo())) + ": " + accDescr[i].getAccessLocation().getName().toString();
                    v.addElement(adstr);
                    continue;
                }
                if (accDescr[i] == null || !accDescr[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers)) continue;
                adstr = "caIssuers;" + generalNameHT.get(new Integer(accDescr[i].getAccessLocation().getTagNo())) + ": " + accDescr[i].getAccessLocation().getName().toString();
                v.addElement(adstr);
            }
            String[] list = new String[v.size()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = (String)v.elementAt(i);
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public byte[] getAuthorityKeyIdentifier() throws CapiException {
        try {
            byte[] aki = this.internalCert.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (aki == null) {
                return new byte[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aki));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            AuthorityKeyIdentifier authKI = AuthorityKeyIdentifier.getInstance((Object)extIn.readObject());
            if (authKI == null) {
                return new byte[0];
            }
            return authKI.getKeyIdentifier();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public byte[] getSubjectKeyIdentifier() throws CapiException {
        try {
            byte[] ski = this.internalCert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
            if (ski == null) {
                return new byte[0];
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])ski));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            SubjectKeyIdentifier subki = SubjectKeyIdentifier.getInstance((Object)extIn.readObject());
            if (subki == null) {
                return new byte[0];
            }
            return subki.getKeyIdentifier();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean isCritical(int extension) throws CapiException {
        String oid = null;
        switch (extension) {
            case 1: {
                oid = X509Extension.authorityKeyIdentifier.getId();
                break;
            }
            case 2: {
                oid = X509Extension.basicConstraints.getId();
                break;
            }
            case 3: {
                oid = X509Extension.certificatePolicies.getId();
                break;
            }
            case 4: {
                oid = X509Extension.cRLDistributionPoints.getId();
                break;
            }
            case 5: {
                oid = X509Extension.issuerAlternativeName.getId();
                break;
            }
            case 6: {
                oid = X509Extension.keyUsage.getId();
                break;
            }
            case 11: {
                oid = X509Extension.subjectAlternativeName.getId();
                break;
            }
            case 13: {
                oid = X509Extension.subjectDirectoryAttributes.getId();
                break;
            }
            case 12: {
                oid = X509Extension.subjectKeyIdentifier.getId();
                break;
            }
            case 14: {
                oid = X509Extension.authorityInfoAccess.getId();
                break;
            }
            case 30: {
                oid = X509Extension.extendedKeyUsage.getId();
                break;
            }
            case 40: {
                oid = X509Extension.qCStatements.getId();
                break;
            }
            default: {
                throw new CapiException("Unsupported extension " + extension, 30005);
            }
        }
        try {
            Set<String> critSet = this.internalCert.getCriticalExtensionOIDs();
            if (critSet != null && !critSet.isEmpty()) {
                for (String foundOid : critSet) {
                    if (foundOid.compareToIgnoreCase(oid) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public static X509Certificate[] getX509CertificatesFromStore(Store storecertificate) throws Exception {
        int i;
        Collection matches = storecertificate.getMatches(null);
        Collection certColl = matches;
        if (certColl.isEmpty()) {
            logger.debug("storecertificate is empty");
            return new X509Certificate[0];
        }
        logger.debug("storecertificate size: " + certColl.size());
        X509Certificate[] res = new X509Certificate[certColl.size()];
        X509CertificateHolder[] certArray = new X509CertificateHolder[certColl.size()];
        Vector v = new Vector(certColl);
        for (i = 0; i < v.size(); ++i) {
            certArray[i] = (X509CertificateHolder)v.elementAt(i);
        }
        for (i = 0; i < certArray.length; ++i) {
            res[i] = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(certArray[i]);
        }
        return res;
    }

    public static Certificate[] getCapiCertificatesFromStore(Store storecertificate) throws Exception {
        int i;
        Collection matches = storecertificate.getMatches(null);
        Collection certColl = matches;
        if (certColl.isEmpty()) {
            logger.debug("storecertificate is empty");
            return new Certificate[0];
        }
        logger.debug("storecertificate size: " + certColl.size());
        Certificate[] res = new Certificate[certColl.size()];
        X509CertificateHolder[] certArray = new X509CertificateHolder[certColl.size()];
        Vector v = new Vector(certColl);
        for (i = 0; i < v.size(); ++i) {
            certArray[i] = (X509CertificateHolder)v.elementAt(i);
        }
        for (i = 0; i < certArray.length; ++i) {
            res[i] = new Certificate(certArray[i].getEncoded());
        }
        return res;
    }

    public static Certificate[] parseP7C(InputStream is) throws CapiException {
        try {
            CMSSignedData pkcs7 = new CMSSignedData(is);
            logger.debug("Chain toString:\n" + pkcs7.toString());
            Object certColl = null;
            Store storecertificate = pkcs7.getCertificates();
            return Certificate.getCapiCertificatesFromStore(storecertificate);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 30005);
        }
    }

    public String getSubjectPublicKeyInfo() throws CapiException {
        try {
            PublicKey pk = this.getPublicKey();
            String algo = pk.getAlgorithm();
            byte[] enc = pk.getEncoded();
            return algo + ": " + new String(Hex.encode((byte[])enc));
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getKeyUsage() throws CapiException {
        if (this.verbose) {
            logger.debug("getKeyUsage as int");
        }
        try {
            boolean[] keyUsageArray = this.internalCert.getKeyUsage();
            if (keyUsageArray == null) {
                return 0;
            }
            String zeroSeq = "1";
            int I2 = 0;
            for (int i = 0; i < keyUsageArray.length; ++i) {
                if (keyUsageArray[i]) {
                    I2 += Integer.parseInt(zeroSeq, 2);
                }
                zeroSeq = zeroSeq + "0";
            }
            if (this.verbose) {
                logger.debug("getKeyUsage");
            }
            return I2;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasUnsupportedCriticalExtension() throws CapiException {
        if (this.verbose) {
            logger.debug("hasUnsupportedCriticalExtension");
        }
        try {
            return this.internalCert.hasUnsupportedCriticalExtension();
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public Hashtable<String, String> getSubjectDirectoryAttributes() throws CapiException {
        try {
            byte[] sda = this.internalCert.getExtensionValue(Extension.subjectDirectoryAttributes.getId());
            if (sda == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])sda));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            SubjectDirectoryAttributes subDirAtt = SubjectDirectoryAttributes.getInstance((Object)extIn.readObject());
            if (subDirAtt == null) {
                return null;
            }
            Vector attrs = subDirAtt.getAttributes();
            if (attrs == null) {
                return null;
            }
            Hashtable<String, String> list = new Hashtable<String, String>();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute att = (Attribute)attrs.elementAt(i);
                String key = att.getAttrType().toString();
                ASN1Set aSet = att.getAttrValues();
                if (aSet == null || aSet.size() <= 0) {
                    return null;
                }
                sb.setLength(0);
                if (att.getAttrType().equals((ASN1Primitive)BCStyle.DATE_OF_BIRTH)) {
                    if (this.verbose) {
                        logger.debug("dateOfBirth...");
                    }
                    key = "dateOfBirth";
                    ASN1GeneralizedTime time = DERGeneralizedTime.getInstance((Object)aSet.getObjectAt(0));
                    Date date = time.getDate();
                    SimpleDateFormat dateF = new SimpleDateFormat("dd-MM-yyyy");
                    String dateStr = dateF.format(date);
                    sb.append(dateStr);
                    list.put(key, sb.toString());
                    continue;
                }
                if (att.getAttrType().equals((ASN1Primitive)BCStyle.PLACE_OF_BIRTH)) {
                    if (this.verbose) {
                        logger.debug("dateOfBirth...");
                    }
                    key = "placeOfBirth";
                    sb.append(aSet.getObjectAt(0));
                    list.put(key, sb.toString());
                    continue;
                }
                if (att.getAttrType().equals((ASN1Primitive)BCStyle.GENDER)) {
                    if (this.verbose) {
                        logger.debug("gender...");
                    }
                    key = "gender";
                    sb.append(aSet.getObjectAt(0));
                    list.put(key, sb.toString());
                    continue;
                }
                if (att.getAttrType().equals((ASN1Primitive)BCStyle.COUNTRY_OF_CITIZENSHIP)) {
                    if (this.verbose) {
                        logger.debug("countryOfCitizenship...");
                    }
                    key = "countryOfCitizenship";
                    sb.append(aSet.getObjectAt(0));
                    list.put(key, sb.toString());
                    continue;
                }
                if (att.getAttrType().equals((ASN1Primitive)BCStyle.COUNTRY_OF_RESIDENCE)) {
                    if (this.verbose) {
                        logger.debug("countryOfResidence...");
                    }
                    key = "countryOfResidence";
                    sb.append(aSet.getObjectAt(0));
                    list.put(key, sb.toString());
                    continue;
                }
                for (int k = 0; k < aSet.size(); ++k) {
                    sb.append(aSet.getObjectAt(k));
                    sb.append(';');
                }
                list.put(key, sb.toString());
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public List<QcStatement> getQCStatements() throws CapiException {
        try {
            byte[] qcs = this.internalCert.getExtensionValue(Extension.qCStatements.getId());
            if (qcs == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])qcs));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1Sequence qcSeq = ASN1Sequence.getInstance((Object)extIn.readObject());
            if (qcSeq == null) {
                return null;
            }
            LinkedList<QcStatement> list = new LinkedList<QcStatement>();
            for (int i = 0; i < qcSeq.size(); ++i) {
                QCStatement qcStat = QCStatement.getInstance((Object)qcSeq.getObjectAt(i));
                String id = qcStat.getStatementId().getId();
                if (this.verbose) {
                    logger.debug("putting statementID: " + id);
                }
                try {
                    QcStatement gcStatement = QcStatement.getInstance(qcStat.getStatementId().getId(), qcStat.getStatementInfo());
                    list.add(gcStatement);
                    continue;
                }
                catch (Exception ex) {
                    if (!this.verbose) continue;
                    logger.debug("error parsing qcStatements: {}: {}", (Object)id, (Object)ex.getMessage());
                }
            }
            return list;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getRSAPublicKeyLen() throws CapiException {
        try {
            RSAPublicKey key = (RSAPublicKey)this.internalCert.getPublicKey();
            int realLen = key.getModulus().bitLength();
            int len = (realLen + 255) / 256 * 256;
            if (this.verbose) {
                logger.debug("getRSAPublicKeyLen value={} ->{}", (Object)realLen, (Object)len);
            }
            return len;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Exception getting RSA PublicKey Len " + e.getMessage(), 3000);
        }
    }

    public boolean isSha1InvalidCert() {
        String sigAlg = null;
        try {
            sigAlg = this.getSigAlgName();
        }
        catch (CapiException e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        if (sigAlg.toLowerCase().indexOf("sha256withrsa") == -1) {
            Date issued = this.getInternalCert().getNotBefore();
            return Util.isDateInvalid("20100901", "yyyyMMdd", issued);
        }
        return false;
    }

    public boolean isCNSAuthentication() throws CapiException {
        return this.isCNSAuthentication(false);
    }

    public boolean isCNSLikeAuthentication() throws CapiException {
        return this.isCNSAuthentication(true);
    }

    private boolean isCNSAuthentication(boolean isCNSLike) throws CapiException {
        String[] urls;
        String[] exku;
        if (this.isCNSAuthentication != null) {
            if (this.verbose) {
                logger.debug("isCNSAuthentication() returning: {}", (Object)this.isCNSAuthentication);
            }
            return this.isCNSAuthentication;
        }
        this.isCNSAuthentication = new Boolean(false);
        if (this.verbose) {
            logger.debug("isCNSAuthentication ?");
        }
        if (!this.isCritical(6)) {
            if (this.verbose) {
                logger.debug("Key Usage is not a critical extension");
            }
            return false;
        }
        int kubits = this.getKeyUsage();
        if (this.verbose) {
            logger.debug("Key Usage: {}", (Object)kubits);
        }
        if ((kubits & 1) <= 0) {
            if (this.verbose) {
                logger.debug("Key Usage has not digitalSignature set");
            }
            return false;
        }
        if ((kubits & 0x62) > 0) {
            if (this.verbose) {
                logger.debug("Key Usage has set cRLSign or keyCertSign or nonRepudiation");
            }
            return false;
        }
        if (this.verbose) {
            logger.debug("Key Usage is ok.");
        }
        if ((exku = this.getExtendedKeyUsage()) == null || exku.length == 0) {
            if (this.verbose) {
                logger.debug("Extended Key Usage not found");
            }
            return false;
        }
        if (this.isCritical(30)) {
            if (this.verbose) {
                logger.debug("Extended Key Usage is a critical extension");
            }
            return false;
        }
        for (int i = 0; i < exku.length; ++i) {
            if (!this.verbose) continue;
            logger.debug("{}:{}", (Object)i, (Object)exku[i]);
        }
        boolean tslWwwCa = false;
        String tslID = "1.3.6.1.5.5.7.3.2";
        if (this.verbose) {
            logger.debug("Searching tsl www client authentication {}", (Object)tslID);
        }
        for (int i = 0; i < exku.length; ++i) {
            if (!tslID.equals(exku[i])) continue;
            if (this.verbose) {
                logger.debug("found tsl www client authentication  ");
            }
            tslWwwCa = true;
            break;
        }
        if (!tslWwwCa) {
            if (this.verbose) {
                logger.debug("tsl www client authentication not in Extended Key Usage");
            }
            return false;
        }
        if (!isCNSLike) {
            String cpsuri = null;
            boolean foundCNSUsage = false;
            boolean foundOid = false;
            String[] policies = this.getPolicies(';');
            if (policies == null || policies.length <= 0) {
                if (this.verbose) {
                    logger.debug("Missing Certificate Policies extension");
                }
                return false;
            }
            int idx = -1;
            for (int i = 0; i < policies.length; ++i) {
                idx = policies[i].indexOf("CPS URI: ");
                if (idx >= 0) {
                    cpsuri = policies[i].substring(idx + "CPS URI: ".length());
                    if (cpsuri.indexOf(";") >= 4) {
                        cpsuri = cpsuri.substring(0, cpsuri.indexOf(";"));
                    }
                    if (this.verbose) {
                        logger.debug("found CPS URI: {}", (Object)cpsuri);
                    }
                }
                if ((idx = policies[i].indexOf("displayText: ")) >= 0) {
                    String displayText = policies[i].substring(idx + "displayText: ".length());
                    if (displayText.indexOf(";") >= 2) {
                        displayText = displayText.substring(0, displayText.indexOf(";"));
                    }
                    if (this.verbose) {
                        logger.debug("found displayText: {}", (Object)displayText);
                    }
                    String CNSUsage = "Identifies X.509 authentication certificates issued for the italian National Service Card (CNS) project in according to the italian regulation";
                    if (displayText.trim().toLowerCase().startsWith(CNSUsage.toLowerCase())) {
                        foundCNSUsage = true;
                    }
                }
                if (!Certificate.isPolicyIncluded(policies[i], tslCnsIDList)) continue;
                if (this.verbose) {
                    logger.debug("found valid CNS Policy object id");
                }
                foundOid = true;
            }
            if (cpsuri == null) {
                if (this.verbose) {
                    logger.debug("Missing CPS URI in Certificate Policies extension");
                }
                return false;
            }
            if (!foundCNSUsage) {
                if (this.verbose) {
                    logger.debug("Missing CNS Usage in Display Text of Certificate Policies extension");
                }
                return false;
            }
            if (!foundOid) {
                if (this.verbose) {
                    logger.debug("Missing valid OID in Certificate Policies extension");
                }
                return false;
            }
        }
        if ((urls = this.getCdpURLs()) == null || urls.length == 0) {
            if (this.verbose) {
                logger.debug("Missing CRL Distribution Point extension");
            }
            return false;
        }
        if (this.getAuthorityKeyIdentifier() == null) {
            if (this.verbose) {
                logger.debug("Missing Authority Key Identifier extension");
            }
            return false;
        }
        if (this.getSubjectKeyIdentifier() == null) {
            if (this.verbose) {
                logger.debug("Missing Subject Key Identifier extension");
            }
            return false;
        }
        if (this.verbose) {
            logger.debug("Certificate is CNSAuthentication.");
        }
        this.isCNSAuthentication = new Boolean(true);
        return true;
    }

    public PublicKey getPublicKey() {
        return this.internalCert.getPublicKey();
    }

    public X509Principal getSubjectName() throws CapiException {
        try {
            return PrincipalUtil.getSubjectX509Principal((X509Certificate)this.internalCert);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X500Name getX500SubjectName() throws CapiException {
        try {
            X500Name x500name = JcaX500NameUtil.getSubject((X509Certificate)this.internalCert);
            return x500name;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X509Principal getIssuerName() throws CapiException {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)this.internalCert);
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X500Name getX500IssuerName() throws CapiException {
        try {
            X500Name x500name = JcaX500NameUtil.getIssuer((X509Certificate)this.internalCert);
            return x500name;
        }
        catch (Exception e) {
            if (this.verbose) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public boolean isRsVerified() {
        boolean blnReturn = false;
        try {
            String policie;
            String[] policies;
            String[] arr$ = policies = this.getPolicies(',');
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(blnReturn = (policie = arr$[i$]).startsWith("1.3.76.16.3,")); ++i$) {
            }
        }
        catch (CapiException capiException) {
            // empty catch block
        }
        return blnReturn;
    }

    public boolean isSSCD() {
        boolean blnReturn;
        block3: {
            blnReturn = false;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcSSCD) continue;
                    blnReturn = true;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return blnReturn;
    }

    public String getQcStatementLimitValue() {
        String strReturn;
        block3: {
            strReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    String value;
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcEuLimitValue || (value = ((QcEuLimitValue)qcStatement).getValue()) == null) continue;
                    strReturn = value;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return strReturn;
    }

    public List<String> getQcStatementType() {
        List<String> lstReturn;
        block3: {
            lstReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcType) continue;
                    lstReturn = ((QcType)qcStatement).getTypes();
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return lstReturn;
    }

    public String getQcStatementRetention() {
        String strReturn;
        block3: {
            strReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    String value;
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcEuRetentionPeriod || (value = ((QcEuRetentionPeriod)qcStatement).getValue()) == null) continue;
                    strReturn = value;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return strReturn;
    }

    public List<PdsLocation> getQcPdsLocation() {
        List<PdsLocation> lstReturn;
        block3: {
            lstReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcPDS) continue;
                    lstReturn = ((QcPDS)qcStatement).getPdsLocations();
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return lstReturn;
    }

    public String getQcStatementSemanticIdentifier() {
        String strReturn;
        block3: {
            strReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    String semanticIdentifier;
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.PkixQCSyntaxv2 || (semanticIdentifier = ((PkixQCSyntaxv2)qcStatement).getSemanticsIdentifier()) == null) continue;
                    strReturn = semanticIdentifier;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return strReturn;
    }

    public List<String> getQcStatementNameRegistrationAuthorities() {
        List<String> strReturn;
        block3: {
            strReturn = null;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    List<String> semanticIdentifier;
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.PkixQCSyntaxv2 || (semanticIdentifier = ((PkixQCSyntaxv2)qcStatement).getNameRegistrationAuthorities()) == null) continue;
                    strReturn = semanticIdentifier;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return strReturn;
    }

    public boolean isCompliant() {
        boolean blnReturn;
        block3: {
            blnReturn = false;
            try {
                List<QcStatement> qcStatements = this.getQCStatements();
                if (qcStatements == null) break block3;
                for (QcStatement qcStatement : qcStatements) {
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcEuCompliance) continue;
                    blnReturn = true;
                    break;
                }
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return blnReturn;
    }

    public String getCaIssuer() throws CapiException {
        String strUrl = null;
        try {
            byte[] aia = this.internalCert.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (aia == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aia));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            AuthorityInformationAccess authInAcc = AuthorityInformationAccess.getInstance((Object)extIn.readObject());
            AccessDescription[] accDescr = authInAcc.getAccessDescriptions();
            for (int i = 0; i < accDescr.length; ++i) {
                if (accDescr[i] == null || !accDescr[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers)) continue;
                DERTaggedObject obj3 = (DERTaggedObject)authInAcc.getAccessDescriptions()[i].getAccessLocation().toASN1Primitive();
                ASN1Primitive obj4 = obj3.getObjectParser(6, true).toASN1Primitive();
                strUrl = obj4.toString();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return strUrl;
    }

    public String getOcspUrl() throws CapiException {
        String strUrl = null;
        try {
            byte[] aia = this.internalCert.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (aia == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aia));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            AuthorityInformationAccess authInAcc = AuthorityInformationAccess.getInstance((Object)extIn.readObject());
            AccessDescription[] accDescr = authInAcc.getAccessDescriptions();
            for (int i = 0; i < accDescr.length; ++i) {
                if (accDescr[i] == null || !accDescr[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                DERTaggedObject obj3 = (DERTaggedObject)authInAcc.getAccessDescriptions()[i].getAccessLocation().toASN1Primitive();
                ASN1Primitive obj4 = obj3.getObjectParser(6, true).toASN1Primitive();
                strUrl = obj4.toString();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return strUrl;
    }

    public boolean isKeyLengthValid() {
        int keyLength = this.getKeyLength();
        if (keyLength < 2048) {
            Date issued = this.getInternalCert().getNotBefore();
            return !Constants.DPCM_AGID_189_2017_DEADLINE.before(issued);
        }
        return true;
    }

    public boolean hasValidNaturalPersonSemantic() {
        if (this.getQcStatementSemanticIdentifier() != null && this.getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
            List<String> nra = this.getQcStatementNameRegistrationAuthorities();
            boolean valid = false;
            try {
                String[] c = this.getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] serialNumbers = this.getIssuerDNAttribute("2.5.4.5");
                String[] cn = this.getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                String[] givenName = null;
                String[] surname = null;
                String[] pseudonym = null;
                try {
                    givenName = this.getIssuerDNAttribute("2.5.4.42");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                try {
                    surname = this.getIssuerDNAttribute("2.5.4.4");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                try {
                    pseudonym = this.getIssuerDNAttribute("2.5.4.65");
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
                if (c != null && c.length == 1 && serialNumbers != null && serialNumbers.length == 1 && cn != null && cn.length == 1 && (givenName != null && givenName.length == 1 && surname != null && surname.length == 1 || pseudonym != null && pseudonym.length == 1)) {
                    String serialNumber = serialNumbers[0];
                    valid = serialNumber != null && serialNumber.length() > 6 && serialNumber.charAt(5) == '-' && (serialNumber.toUpperCase().startsWith("PAS") || serialNumber.toUpperCase().startsWith("IDC") || serialNumber.toUpperCase().startsWith("PNO") || serialNumber.toUpperCase().startsWith("VAT") || serialNumber.toUpperCase().startsWith("TIN") || serialNumber.charAt(2) == ':' && nra != null && nra.size() > 0 && nra.get(0) != null);
                }
            }
            catch (CapiException e) {
                valid = false;
            }
            return valid;
        }
        return true;
    }

    public boolean hasValidLegalPersonSemantic() {
        if (this.getQcStatementSemanticIdentifier() != null && this.getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
            List<String> nra = this.getQcStatementNameRegistrationAuthorities();
            boolean valid = false;
            try {
                String[] c = this.getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] o = this.getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                String[] cn = this.getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                String[] organizationIdentifier = this.getIssuerDNAttribute("2.5.4.97");
                if (c != null && c.length == 1 && o != null && o.length == 1 && cn != null && cn.length == 1 && organizationIdentifier != null && organizationIdentifier.length == 1) {
                    String orgId = organizationIdentifier[0];
                    valid = orgId != null && orgId.length() > 6 && orgId.charAt(5) == '-' && (orgId.toUpperCase().startsWith("VAT") || orgId.toUpperCase().startsWith("NTR") || orgId.charAt(2) == ':' && nra != null && nra.size() > 0 && nra.get(0) != null);
                }
            }
            catch (CapiException e) {
                valid = false;
            }
            return valid;
        }
        return true;
    }

    public int getKeyLength() {
        int len = -1;
        PublicKey pk = this.getPublicKey();
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof JCEECPublicKey) {
            JCEECPublicKey ecpriv = (JCEECPublicKey)pk;
            org.bouncycastle.jce.spec.ECParameterSpec spec = ecpriv.getParameters();
            len = spec != null ? spec.getN().bitLength() : 0;
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecpriv = (ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }

    public boolean issuedAfterSPIDAuthentication() throws CapiException {
        if (this.issuedAfterSPIDAuthentication != null) {
            if (this.verbose) {
                logger.debug("issuedAfterSPIDAuthentication() returning: {}", (Object)this.issuedAfterSPIDAuthentication);
            }
            return this.issuedAfterSPIDAuthentication;
        }
        this.issuedAfterSPIDAuthentication = false;
        if (this.verbose) {
            logger.debug("issuedAfterSPIDAuthentication ?");
        }
        String spidPolicy = "1.3.76.16.5";
        String[] policies = this.getPolicies(';');
        int i = 0;
        while (!this.isCNSAuthentication.booleanValue()) {
            String[] objectIdTokens;
            for (String objectIdToken : objectIdTokens = policies[i].split(";")) {
                if (!spidPolicy.equals(objectIdToken)) continue;
                if (this.verbose) {
                    logger.debug("Certificate is issuedAfterSPIDAuthentication.");
                }
                this.isCNSAuthentication = true;
            }
            ++i;
        }
        return this.isCNSAuthentication;
    }

    public boolean isCIEAuthentication() throws CapiException {
        String[] exku;
        if (this.isCIEAuthentication != null) {
            if (this.verbose) {
                logger.debug("isCIEAuthentication() returning: {}", (Object)this.isCIEAuthentication);
            }
            return this.isCIEAuthentication;
        }
        this.isCIEAuthentication = new Boolean(false);
        if (this.verbose) {
            logger.debug("isCIEAuthentication ?");
        }
        if (!this.isCritical(6)) {
            if (this.verbose) {
                logger.debug("Key Usage is not a critical extension");
            }
            return false;
        }
        int kubits = this.getKeyUsage();
        if (this.verbose) {
            logger.debug("Key Usage: {}", (Object)kubits);
        }
        if ((kubits & 1) <= 0) {
            if (this.verbose) {
                logger.debug("Key Usage has not digitalSignature set");
            }
            return false;
        }
        if ((kubits & 0x62) > 0) {
            if (this.verbose) {
                logger.debug("Key Usage has set cRLSign or keyCertSign or nonRepudiation");
            }
            return false;
        }
        if (this.verbose) {
            logger.debug("Key Usage is ok.");
        }
        if ((exku = this.getExtendedKeyUsage()) == null || exku.length == 0) {
            if (this.verbose) {
                logger.debug("Extended Key Usage not found");
            }
            return false;
        }
        if (this.isCritical(30)) {
            if (this.verbose) {
                logger.debug("Extended Key Usage is a critical extension");
            }
            return false;
        }
        for (int i = 0; i < exku.length; ++i) {
            logger.info(i + ":" + exku[i]);
        }
        boolean tslWwwCa = false;
        String tslID = "1.3.6.1.5.5.7.3.2";
        if (this.verbose) {
            logger.debug("Searching tsl www client authentication {}", (Object)tslID);
        }
        for (int i = 0; i < exku.length; ++i) {
            if (!tslID.equals(exku[i])) continue;
            if (this.verbose) {
                logger.debug("found tsl www client authentication  ");
            }
            tslWwwCa = true;
            break;
        }
        if (!tslWwwCa) {
            if (this.verbose) {
                logger.debug("tsl www client authentication not in Extended Key Usage");
            }
            return false;
        }
        String cpsuri = null;
        boolean foundCIEUsage = false;
        boolean foundOid = false;
        String[] policies = this.getPolicies(';');
        if (policies == null || policies.length <= 0) {
            if (this.verbose) {
                logger.debug("Missing Certificate Policies extension");
            }
            return false;
        }
        int idx = -1;
        for (int i = 0; i < policies.length; ++i) {
            idx = policies[i].indexOf("CPS URI: ");
            if (idx >= 0) {
                cpsuri = policies[i].substring(idx + "CPS URI: ".length());
                if (cpsuri.indexOf(";") >= 4) {
                    cpsuri = cpsuri.substring(0, cpsuri.indexOf(";"));
                }
                if (this.verbose) {
                    logger.debug("found CPS URI: {}", (Object)cpsuri);
                }
            }
            if ((idx = policies[i].indexOf("displayText: ")) >= 0) {
                String displayText = policies[i].substring(idx + "displayText: ".length());
                if (displayText.indexOf(";") >= 2) {
                    displayText = displayText.substring(0, displayText.indexOf(";"));
                }
                if (this.verbose) {
                    logger.debug("found displayText: {}", (Object)displayText);
                }
                String CIEUsage = "X.509 authentication certificate issued by the Italian Ministry of Interior for the Electronic Identity Card";
                if (displayText.trim().toLowerCase().startsWith(CIEUsage.toLowerCase())) {
                    foundCIEUsage = true;
                }
            }
            if (!Certificate.isPolicyIncluded(policies[i], tslCieIDList)) continue;
            if (this.verbose) {
                logger.debug("found valid CNS Policy object id");
            }
            foundOid = true;
        }
        if (cpsuri == null) {
            if (this.verbose) {
                logger.debug("Missing CPS URI in Certificate Policies extension");
            }
            return false;
        }
        if (!foundCIEUsage) {
            if (this.verbose) {
                logger.debug("Missing CIE Usage in Display Text of Certificate Policies extension");
            }
            return false;
        }
        if (!foundOid) {
            if (this.verbose) {
                logger.debug("Missing valid OID in Certificate Policies extension");
            }
            return false;
        }
        String[] urls = this.getCdpURLs();
        if (urls == null || urls.length == 0) {
            if (this.verbose) {
                logger.debug("Missing CRL Distribution Point extension");
            }
            return false;
        }
        if (this.getAuthorityKeyIdentifier() == null) {
            if (this.verbose) {
                logger.debug("Missing Authority Key Identifier extension");
            }
            return false;
        }
        if (this.getSubjectKeyIdentifier() == null) {
            if (this.verbose) {
                logger.debug("Missing Subject Key Identifier extension");
            }
            return false;
        }
        if (this.verbose) {
            logger.debug("Certificate is CIEAuthentication.");
        }
        this.isCIEAuthentication = new Boolean(true);
        return true;
    }

    public boolean isWebSiteAuthentication() {
        List<String> types = this.getQcStatementType();
        if (types != null) {
            for (int iP = 0; iP < types.size(); ++iP) {
                if (!types.get(iP).equals("0.4.0.1862.1.6.3")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isElectronicSeal() {
        List<String> types = this.getQcStatementType();
        if (types != null) {
            for (int iP = 0; iP < types.size(); ++iP) {
                if (!types.get(iP).equals("0.4.0.1862.1.6.2")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isElectronicSignature() {
        List<String> types = this.getQcStatementType();
        if (types != null) {
            for (int iP = 0; iP < types.size(); ++iP) {
                if (!types.get(iP).equals("0.4.0.1862.1.6.1")) continue;
                return true;
            }
        }
        return false;
    }

    public CertDBItem[] getValidatedChain() {
        return this.validatedChain;
    }

    public void setValidatedChain(CertDBItem[] validatedChain) {
        this.validatedChain = validatedChain;
    }

    public boolean isSmartLogonCertificate() {
        if (!this.containsUserPrincipalName()) {
            logger.debug("User Principal Name not found");
            return false;
        }
        if (!this.containsSmartcardLogonUsage()) {
            logger.debug("Smartcard logon extended key usage not found");
            return false;
        }
        if (!this.containsDigitalSignatureUsage()) {
            logger.debug("Digital signature key usage not found");
            return false;
        }
        return true;
    }

    private boolean containsUserPrincipalName() {
        try {
            String[] altNames;
            for (String name : altNames = this.getSubjectAltName()) {
                if (!name.contains("1.3.6.1.4.1.311.20.2.3")) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private boolean containsSmartcardLogonUsage() {
        try {
            String[] extendedKeyUsage;
            for (String eks : extendedKeyUsage = this.getExtendedKeyUsage()) {
                if (!eks.equals("1.3.6.1.4.1.311.20.2.2")) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private boolean containsDigitalSignatureUsage() {
        try {
            boolean[] keyUsageArray = this.internalCert.getKeyUsage();
            if (keyUsageArray == null || keyUsageArray.length == 0) {
                return false;
            }
            return keyUsageArray[0];
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    static {
        tslCnsIDList = new ArrayList<String>();
        tslCnsIDList.add("1.3.76.16.2.1");
        tslCnsIDList.add("1.3.159.6.1.3.2.10");
        tslCnsIDList.add("1.3.76.12.1.1.10.2.2.10");
        tslCieIDList = new ArrayList<String>();
        tslCieIDList.add("1.3.76.47.4");
        oidToNameHT = new Hashtable();
        generalNameHT = new Hashtable();
        nameToOid = new Hashtable();
        extKeyUsageHT = new Hashtable();
        oidToNameHT.put("2.5.4.13", "Description");
        oidToNameHT.put("2.5.4.46", "dnQualifier");
        oidToNameHT.put("2.5.4.12", "title");
        oidToNameHT.put("2.5.4.4", "surname");
        nameToOid.put("country", BCStyle.C);
        nameToOid.put("commonname", BCStyle.CN);
        nameToOid.put("countryofresidence", BCStyle.COUNTRY_OF_RESIDENCE);
        nameToOid.put("dateofbirth", BCStyle.DATE_OF_BIRTH);
        nameToOid.put("description", new ASN1ObjectIdentifier("2.5.4.13"));
        nameToOid.put("domaincomponent", BCStyle.DC);
        nameToOid.put("dnqualifier", BCStyle.DN_QUALIFIER);
        nameToOid.put("emailaddress", BCStyle.EmailAddress);
        nameToOid.put("gender", BCStyle.GENDER);
        nameToOid.put("generationqualifier", BCStyle.GENERATION);
        nameToOid.put("givenname", BCStyle.GIVENNAME);
        nameToOid.put("initials", BCStyle.INITIALS);
        nameToOid.put("locality", BCStyle.L);
        nameToOid.put("nameatbirth", BCStyle.NAME_AT_BIRTH);
        nameToOid.put("organization", BCStyle.O);
        nameToOid.put("organizationalunit", BCStyle.OU);
        nameToOid.put("placeofbirth ", BCStyle.PLACE_OF_BIRTH);
        nameToOid.put("pseudonym", BCStyle.PSEUDONYM);
        nameToOid.put("surname", BCStyle.SURNAME);
        nameToOid.put("street", BCStyle.STREET);
        nameToOid.put("title", BCStyle.T);
        nameToOid.put("serialnumber", BCStyle.SERIALNUMBER);
        nameToOid.put("stateorprovince", BCStyle.ST);
        generalNameHT.put(new Integer(4), "directoryName");
        generalNameHT.put(new Integer(2), "dNSName");
        generalNameHT.put(new Integer(5), "ediPartyName");
        generalNameHT.put(new Integer(7), "iPAddress");
        generalNameHT.put(new Integer(0), "otherName");
        generalNameHT.put(new Integer(8), "registeredID");
        generalNameHT.put(new Integer(1), "rfc822Name");
        generalNameHT.put(new Integer(6), "uniformResourceIdentifier");
        generalNameHT.put(new Integer(3), "x400Address");
        extKeyUsageHT.put(KeyPurposeId.id_kp_serverAuth.getId(), "TLS Web server Server authentication");
        extKeyUsageHT.put(KeyPurposeId.id_kp_clientAuth.getId(), "TLS Web client authentication");
        extKeyUsageHT.put(KeyPurposeId.id_kp_codeSigning.getId(), "Code signing");
        extKeyUsageHT.put(KeyPurposeId.id_kp_emailProtection.getId(), "E-mail protection");
        extKeyUsageHT.put(KeyPurposeId.id_kp_timeStamping.getId(), "Timestamping");
        extKeyUsageHT.put(KeyPurposeId.id_kp_OCSPSigning.getId(), "OCSPsigning");
        extKeyUsageHT.put(KeyPurposeId.id_kp_smartcardlogon.getId(), "SmartCardLogon");
        try {
            cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
        }
        catch (CertificateException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            oracleCf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

