/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.AlgorithmParameters;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;

public abstract class TokenSpi {
    private static final String HEADER = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String TRAILER = "-----END NEW CERTIFICATE REQUEST-----";
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String id = null;

    @Deprecated
    public abstract void initializeLib(String[] var1) throws CapiException;

    @Deprecated
    public abstract void initializeLib(String[] var1, boolean var2) throws CapiException;

    public abstract void initializeLib(TokenParameters var1) throws CapiException;

    public abstract void finalizeLib();

    public abstract String[] getLibInfo();

    public abstract String getLibName();

    public abstract boolean isTokenInserted() throws CapiException;

    public abstract String getLabel() throws CapiException;

    public abstract String getSerialNumber() throws CapiException;

    public abstract int getFreeSpace() throws CapiException;

    public abstract void changePIN(String var1, String var2) throws CapiException;

    public abstract void changePUK(String var1, String var2) throws CapiException;

    public abstract int getMaxRSAKeyLength() throws CapiException;

    public abstract int getMinRSAKeyLength() throws CapiException;

    public abstract void unblockPIN(String var1, String var2) throws CapiException;

    public abstract int getMaxPINLen() throws CapiException;

    public abstract int getMinPINLen() throws CapiException;

    public abstract void openSession(boolean var1, String var2) throws CapiException;

    public abstract void openSession(boolean var1, String var2, int var3) throws CapiException;

    public abstract void openSessionAuthPath(boolean var1) throws CapiException;

    public abstract void openPublicSession() throws CapiException;

    public abstract void closeSession() throws CapiException;

    public abstract boolean isSessionOpen() throws CapiException;

    public abstract byte[] getData(String var1) throws CapiException;

    public abstract void setData(String var1, byte[] var2, int var3) throws CapiException;

    public abstract String getCert(String var1) throws CapiException;

    @Deprecated
    public abstract void setCert(String var1, byte[] var2, int var3, boolean var4) throws CapiException;

    public abstract String installCertificate(Certificate var1) throws CapiException;

    public abstract boolean canImport();

    public abstract boolean canExport(String var1);

    public abstract int canUnblock();

    public abstract void genKeyPair(String var1, int var2, int var3, int var4) throws CapiException;

    public abstract void genKeyPair(String var1, KeyAlgo var2, int var3, int var4, int var5) throws CapiException;

    public abstract String impCred(String var1, PrivateKey var2, int var3, int var4) throws CapiException;

    public abstract PrivateKey expCred(String var1) throws CapiException;

    public abstract PublicKey getPublicKey(String var1) throws CapiException;

    public abstract PrivateKey getPrivateKey(String var1) throws CapiException;

    @Deprecated
    public abstract void instCert(String var1, Certificate var2, boolean var3, boolean var4) throws CapiException;

    public abstract int getKeyUsage(String var1, boolean var2) throws CapiException;

    public abstract int getKeyLength(String var1) throws CapiException;

    public abstract byte[] doSign(byte[] var1, String var2, int var3) throws CapiException;

    public abstract byte[] doDecrypt(byte[] var1, String var2, int var3) throws CapiException;

    public abstract String[] listObjects(String var1, byte var2) throws CapiException;

    public abstract void deleteObject(String var1) throws CapiException;

    public abstract byte getObjectType(String var1) throws CapiException;

    public abstract String getObjectID(String var1) throws CapiException;

    public abstract int getObjectSize(String var1) throws CapiException;

    public abstract void renameObject(String var1, String var2, int var3) throws CapiException;

    public abstract void setCert(String var1, Certificate var2, int var3, byte[] var4, boolean var5) throws CapiException;

    public abstract void setCkaId(String var1, String var2, byte[] var3) throws CapiException;

    public abstract boolean exist(String var1) throws CapiException;

    public abstract String generateID(String[] var1);

    public abstract boolean requiredExtendedAuth();

    public abstract SessionCredentials openSessionWithExtendedAuth(boolean var1, String var2, ExtendedCredentials var3) throws CapiException;

    public abstract void resetToken(String var1) throws CapiException;

    public String reqRenew(String alias, boolean newkeys, String newAlias, int mode) throws CapiException {
        if ((this.getObjectType(alias) & 4) == 0) {
            throw new CapiException("Alias is not a credential with installed cert", 10025);
        }
        Certificate cert = new Certificate(Util.getBytes(this.getCert(alias)));
        if (newkeys) {
            this.genKeyPair(newAlias, this.getKeyUsage(alias, false), this.getKeyLength(alias), mode);
            return this.certReq(newAlias, cert.getX500SubjectName());
        }
        return this.certReq(alias, cert.getX500SubjectName());
    }

    @Deprecated
    public abstract CertificationRequest generatePKCS10CertificationRequest(X500Name var1, PublicKey var2, PrivateKey var3) throws Exception;

    @Deprecated
    public abstract String certReq(X500Name var1, PublicKey var2, PrivateKey var3, String var4) throws CapiException;

    @Deprecated
    public abstract String certReq(X500Name var1, PublicKey var2, PrivateKey var3, Provider var4) throws CapiException;

    @Deprecated
    public abstract String certReq(String var1, X500Name var2) throws CapiException;

    public abstract byte[] generateCertificateRequest(KeyType var1, KeyAlgo var2, int var3, String var4, GeneralNames[] var5, String var6) throws CapiException;

    public boolean checkKeyUsage(int type, int keyUsage) {
        int signUsage = 3;
        int ciphUsage = 412;
        logger.debug("checkKeyUsage type=" + type + " keyUsage=" + keyUsage);
        switch (type) {
            case 1: {
                return (keyUsage & signUsage) > 0;
            }
            case 2: {
                return (keyUsage & ciphUsage) > 0;
            }
        }
        return true;
    }

    public static final void addProvider(Provider p, int position) throws CapiException {
        String jvm_version = null;
        logger.debug("getting system properties ...");
        try {
            jvm_version = System.getProperty("java.version");
            logger.debug("Java version is " + jvm_version);
            if (jvm_version == null) {
                jvm_version = "1.6";
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            jvm_version = "1.6";
        }
        logger.debug("adding provider ");
        TokenSpi.addProvider(p, position, null);
    }

    public static final synchronized void addProvider(Provider p, int position, String dummy) throws CapiException {
        if (Security.getProvider("SunRsaSign") != null) {
            TokenSpi.removeProvider("SunRsaSign");
        }
        String name = p.getName();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i].getName().compareToIgnoreCase(name) != 0) continue;
            logger.debug("found Provider " + name + " at idx " + i + ". Comparing to requested position " + position);
            if (i > position) continue;
            logger.debug("already present Provider name = " + name + " at position " + position);
            return;
        }
        TokenSpi.removeProvider(name);
        logger.debug("addingProvider name=" + name);
        int insAt = Security.insertProviderAt(p, position);
        if (insAt < 0 || insAt != position) {
            throw new CapiException("Cannot set JCE provider at position " + position + " result is " + insAt, 1003);
        }
    }

    public static final void removeProvider(String name) {
        ProvUtils.removeProvider(name);
    }

    public static KeyPair genSoftKeyPair(KeyAlgo algo, int bits) throws CapiException {
        logger.debug(System.currentTimeMillis() + ":[TokenSpi] genSoftKeyPair bits=" + bits);
        try {
            SecureRandom sec;
            KeyPairGenerator key_gen;
            if (algo == KeyAlgo.RSA) {
                key_gen = KeyPairGenerator.getInstance("RSA", ProvUtils.bcProvider);
                sec = new SecureRandom();
                key_gen.initialize(bits, sec);
            } else {
                key_gen = KeyPairGenerator.getInstance("EC", ProvUtils.bcProvider);
                sec = new SecureRandom();
                key_gen.initialize(bits, sec);
            }
            KeyPair key_pair = key_gen.generateKeyPair();
            logger.debug(System.currentTimeMillis() + ":[TokenSpi] key pair generated");
            return key_pair;
        }
        catch (InvalidParameterException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid key length " + bits, 10031);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error during key pair generation", 10032);
        }
    }

    public static byte[] toPKCS8(PrivateKey key, String pin) throws CapiException {
        logger.debug(System.currentTimeMillis() + ":[TokenSpi] toPKCS8");
        String alg = "1.2.840.113549.1.12.1.3";
        byte[] salt = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int iterationCount = 100;
        PBEParameterSpec defParams = new PBEParameterSpec(salt, iterationCount);
        AlgorithmParameters params = null;
        EncryptedPrivateKeyInfo pInfo = null;
        try {
            params = AlgorithmParameters.getInstance(alg, ProvUtils.bcProvider);
            params.init(defParams);
            PBEKeySpec pbeSpec = new PBEKeySpec(pin.toCharArray());
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg, ProvUtils.bcProvider);
            Cipher cipher = Cipher.getInstance(alg, ProvUtils.bcProvider);
            cipher.init(3, (Key)keyFact.generateSecret(pbeSpec), params);
            byte[] wrappedKey = cipher.wrap(key);
            pInfo = new EncryptedPrivateKeyInfo(params, wrappedKey);
            return pInfo.getEncoded();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException(e.getMessage(), 1003);
        }
    }

    public static PKCS8EncodedKeySpec fromPKCS8(byte[] encKey, String pin) throws CapiException {
        String alg = "1.2.840.113549.1.12.1.3";
        logger.debug(System.currentTimeMillis() + ":[TokenSpi] fromPKCS8");
        try {
            EncryptedPrivateKeyInfo pInfo = new EncryptedPrivateKeyInfo(encKey);
            PBEKeySpec pbeSpec = new PBEKeySpec(pin.toCharArray());
            logger.debug("pInfo.getAlgName(): " + pInfo.getAlgName());
            Cipher cipher = Cipher.getInstance(pInfo.getAlgName(), ProvUtils.bcProvider);
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg, ProvUtils.bcProvider);
            SecretKey secretKey = keyFact.generateSecret(pbeSpec);
            cipher.init(2, (Key)secretKey, pInfo.getAlgParameters());
            PKCS8EncodedKeySpec keySpec = pInfo.getKeySpec(cipher);
            return keySpec;
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Invalid encrypted key", 3000);
        }
    }

    public byte[] hash(byte[] data) throws CapiException {
        logger.debug("calculating hash");
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
            sha.update(data);
            return sha.digest();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 1003);
        }
    }

    public void initProviders(TokenSpi cryptoDev) throws CapiException {
        logger.debug("init security providers");
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

