/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.msg;

import it.actalis.ellips.capi.core.msg.ETSISubIndication;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;

public enum ValidatorMessageEnum implements EsecurityMessage
{
    EA0001_GENERIC_ERROR("EA0001", "Generic error"),
    EA0002_UNMANAGED_ERROR("EA0002", "Unmanaged error {0}"),
    EA0003_INVALID_DATA("EA0003", "Invalid format or corrupted data"),
    ES0001_INVALID_SIGNATURE("ES0001", "Invalid signature"),
    ES0002_NOT_VALIDABLE_SIGNATURE("ES0002", "Internal error. Unverifiable signature"),
    ES0003_SIGN_CORRUPTED("ES0003", "The signature is corrupted", ETSISubIndication.SIG_CRYPTO_FAILURE),
    ES0004_MARK_CORRUPTED("ES0004", "The signature of the timestamp is corrupted", ETSISubIndication.SIG_CRYPTO_FAILURE),
    ES0005_NOCNIPA45("ES0005", "The signature is not compliant with the deliberation CNIPA 45/2009", ETSISubIndication.FORMAT_FAILURE),
    ES0006_NOSHA256("ES0006", "Signature not compliant with SHA-256 standard", ETSISubIndication.FORMAT_FAILURE),
    ES0007_INVALIDFILEFORMAT("ES0007", "The format of the signed file is not valid", ETSISubIndication.FORMAT_FAILURE),
    ES0008_NOSIGNERCERTIFICATE("ES0008", "No valid certificate found for signer", ETSISubIndication.NO_SIGNING_CERTIFICATE_FOUND),
    ES0009_FORMAT_NOTVALID("ES0009", "The format of the signed file is not valid", ETSISubIndication.FORMAT_FAILURE),
    ES0010_FORMAT_PADES_NOTVALID_SUBFILTER("ES0010", "The SubFilter does not fall in standard PADES cases", ETSISubIndication.FORMAT_FAILURE),
    ES0011_FORMAT_PADES_NOTVALID_NOBYTERANGE("ES0011", "Signature format not compliant with PADES standard (ByteRange non valid)", ETSISubIndication.FORMAT_FAILURE),
    ES0012_FORMAT_PADES_NOTVALID_CERTINDICTIONARY("ES0012", "Signature format not compliant with PADES-BES standard (Certificate field not valid)", ETSISubIndication.FORMAT_FAILURE),
    ES0013_FORMAT_PADES_NOTVALID_CMSMULTISIGNERS("ES0013", "Signature format not compliant with PADES standard (CMS envelope with multiple signers)", ETSISubIndication.FORMAT_FAILURE),
    ES0014_FORMAT_PADES_NOTVALID_PKCS1("ES0014", "Signature format not compliant with PADES standard (CMS envelope not compliant)", ETSISubIndication.FORMAT_FAILURE),
    ES0015_FORMAT_PADES_NOTVALID_MISSINGSIGNEDATTRS("ES0015", "Signature format not compliant with PADES-BES (one of the following signature attributes is missing: content type / message digest / signing certificate)", ETSISubIndication.FORMAT_FAILURE),
    ES0016_FORMAT_PADES_NOTVALID_UNESPECTEDSIGNEDATTRS("ES0016", "Signature format not compliant with PADES-BES standard (one of the following signature attributes is present in the CMS envelope: counter signature/content-reference/content-identifier/content-hints/commitment-type/signer-location)", ETSISubIndication.FORMAT_FAILURE),
    ES0017_INVALID_MODIFICATION_AFTER_SIGNING("ES0017", "The document was edited after the signature", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0018_INVALID_CANONICALIZATION_ALGORITHM("ES0018", "Algorithm used for canonicalize is not valid", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0019_INVALID_TRANSFORM_ALGORITHM("ES0019", "Algorithm used for canonicalize is not valid", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0020_NO_REFERENCES_FOUND("ES0020", "No References found", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0021_NO_REFERENCE_FOR_KEYINFO_FOUND("ES0021", "No Reference found for KeyInfo Element", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0022_NO_REFERENCE_FOR_SIGNEDPROPS_FOUND("ES0022", "No Reference found for SignedProperties Element", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0023_XADES_ALL_SIGNING_CERTS_NOT_MATCH("ES0023", "Signed Property signingCertificate are not matching with certificate chain", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    ES0024_NOTIMESTAMPCERTIFICATE("ES0024", "The timestamp does not contain any certificate for the verification", ETSISubIndication.NO_SIGNING_CERTIFICATE_FOUND),
    ES0025_NOTIMESTAMPRELATED("ES0025", "The timestamp does not belong to the stamped file", ETSISubIndication.HASH_FAILURE),
    ES0026_TIMESTAMP_NOSIGNEDATTRS("ES0026", "Signed-properties are missing", ETSISubIndication.SIGNED_DATA_NOT_FOUND),
    ES0027_INVALID_TIMESTAMP("ES0027", "Invalid timestamp"),
    ES0028_NOT_VERIFICABLE_TIMESTAMP("ES0028", "Cannot be Verified", ETSISubIndication.NO_SIGNING_CERTIFICATE_FOUND),
    ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED("ES0029", "Digest Algorithm Not Supported: {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    ES0030_DIGEST_ALGORITHM_FORBIDDEN("ES0030", "Digest Algorithm Forbidden: {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    IS0001_SIGNATURE_FORMAT("IS0001", "The signature format is {0}"),
    IS0002_MARK_FORMAT("IS0002", "Timestamp format {0}"),
    IS0003_SIGN_INTACT("IS0003", "The signature is intact"),
    IS0004_MARK_INTACT("IS0004", "The timestamp signature is intact"),
    IS0005_SIGN_VALID("IS0005", "Signature is intact"),
    IS0006_MARK_VALID("IS0006", "Timestamp is valid"),
    IS0007_MARK_DATE("IS0007", "Timestamp issued on {0}"),
    IS0008_MARK_POLICY_ID("IS0008", "Policy Id : {0}"),
    IS0009_MARK_SERIAL_NUMBER("IS0009", "Serial Number : {0}"),
    IS0010_MARK_HASH_ALGORITHM("IS0010", "Hash algorithm : {0}"),
    IS0011_MARK_EIDAS_COMPLIANCE("IS0011", "eIDAS compliance : Qualified (under EU Regulation 910/2014 \u2013 eIDAS)"),
    IS0012_MARK_ACCURACY("IS0012", "Accuracy : {0} milliseconds"),
    IS0013_MARK_DETAILS("IS0013", "Timestamp details"),
    IS0014_VALIDATION_PROFILE("IS0014", "Selected validation profile is {0}"),
    IS0015_GRAPHOMETRIC_DATA("IS0015", "Graphometric data found"),
    IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED("IS0016", "Signature does not comply EU recommendation about Trust Services: Digest Algorithm {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    IS0017_ADDITIONAL_INFORMATION("IS0017", "Additional Information"),
    WS0001_NOCNIPA45VALID("WS0001", "The signature is not compliant with the deliberation CNIPA 45/2009 but it is valid and compliant with article 63, subparagraph 3 of DPCM 22 February 2013"),
    WS0002_NOEIDAS("WS0002", "The signature format is not compliant with decision (UE) 2015/1506", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0003_PADES_NOTEIDAS_SUBFILTER("WS0003", "The signature is not compliant with the PADES-BES standard required by the European legislation (use of subfilter different from ETSI.CAdES.detached)", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0004_CADES_NOSIGNEDATTRS("WS0004", "The signature is not compliant with the Cades BES standard: signed attributes are missing", ETSISubIndication.SIGNED_DATA_NOT_FOUND),
    WS0005_CADES_NOSIGNCERT("WS0005", "The signature is not compliant with the Cades BES standard: SigningCertificate is missing", ETSISubIndication.NO_SIGNING_CERTIFICATE_FOUND),
    WS0006_CADES_NOSIGNCERTV2("WS0006", "Signed-property Signingcertificate V2 is missing", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0007_NOSIGNTIME("WS0007", "Signed-property SigningTime is missing or not compliant with the standard", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0008_TIMESTAMP_NOSHA256("WS0008", "Timestamp not generated with SHA-256 algorithm", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    WS0009_TIMESTAMP_NOCNIPAVALID("WS0009", "The timestamp is not compliant with the deliberation CNIPA 45/2009 but it is valid and compliant with article 63, subparagraph 3 of DPCM 22 February 2013"),
    WS0010_TIMESTAMP_NOEIDASCOMPLIANCE("WS0010", "eIDAS compliance : Not qualified (under EU Regulation 910/2014 \u2013 eIDAS)", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0011_TIMESTAMP_VALIDITY("WS0011", "Validity : National validity only"),
    WS0012_XADES_NOSIGNCERT("WS0012", "Signed-property Signingcertificate is missing", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0013_NO_RFC5652_SIGNEDATTRIBUTES("WS0013", "Signed Attributes not encoded as specified by RFC5652", ETSISubIndication.SIG_CRYPTO_FAILURE),
    WS0014_NO_VALID_SIGNINGTIME("WS0014", "Signing time is not included in the certificate's validity period", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0015_NO_ISSUER_NAME("WS0015", "Issuer name not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0016_NO_CANONICALIZATION_METHOD("WS0016", "Canonicalization method not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0017_SIGNATURES_NOT_ALLOWED_AFTER_CERTIFICATION("WS0017", "The document was signed after the certification", ETSISubIndication.FORMAT_FAILURE),
    WS0018_FORM_UPDATE_NOT_ALLOWED_AFTER_CERTIFICATION("WS0018", "A form was added/modified after the signature", ETSISubIndication.FORMAT_FAILURE),
    WS0019_ANNOTATION_UPDATE_NOT_ALLOWED_AFTER_CERTIFICATION("WS0019", "An annotation was added/modified after the signature", ETSISubIndication.FORMAT_FAILURE),
    WS0020_COUNTER_SIGNATURE_WITH_CONTENT_TYPE("WS0020", "The counter signature contain content-type attribute", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WS0021_FORMAT_PADES_NOTVALID_CERTINDICTIONARY("WS0021", "Signature format not compliant with PADES-BES standard (Certificate field not valid)", ETSISubIndication.FORMAT_FAILURE),
    IC0001_CERT_HAS_LEGAL_VALIDITY("IC0001", "The certificate has legal validity"),
    IC0002_CERT_IS_RELIABLE("IC0002", "The certificate is reliable"),
    IC0003_CERT_IS_COMPLIANCE("IC0003", "Qualified Certificate in accordance with Regulation (EU) No. 910/2014 - eIDAS"),
    IC0004_CERT_LIMIT_VALUE("IC0004", "Qualified Certificate with value limits: {0}"),
    IC0005_CERT_RETENTION_PERIOD("IC0005", "Storage period for certification information: {0} years "),
    IC0006_CERT_SSCD("IC0006", "The private key corresponding to the certificate resides on a secure device in accordance with Regulation (EU) No. 910/2014 (QSCD - Qualified Signature/Seal Creation Device)"),
    IC0007_CERT_PDS("IC0007", "PKI Disclosure Statements (PDS): ({0})<br> <link>{1}</link>"),
    IC0008_CERT_QC_TYPE_0_4_0_1862_1_6_1("IC0008", "Digital signature certificate in accordance with Regulation (EU) No. 910/2014"),
    IC0009_CERT_QC_TYPE_0_4_0_1862_1_6_2("IC0009", "Electronic seal certificate in accordance with Regulation (EU) No. 910/2014"),
    IC0010_CERT_QC_TYPE_0_4_0_1862_1_6_3("IC0010", "Website authentication certificate in accordance with Regulation (EU) No. 910/2014"),
    IC0011_CERT_VALIDATION_SYSTEM_DATE("IC0011", "Verify at system date: {0}"),
    IC0012_CERT_VALIDATION_CUSTOM_DATE("IC0012", "Verify at: {0}"),
    IC0013_CERT_VALIDATION_TIMESTAMP_DATE("IC0013", "Verify up to date of the timestamp"),
    IC0014_CERT_VALIDATION_TO_DATE("IC0014", "It is possible to do custom date verification"),
    IC0015_CERT_VERIFIED("IC0015", ""),
    IC0016_CERT_VALIDATION("IC0016", "Date-time of signature declared by signer: {0}"),
    IC0017_OCSP_USED_FOR_CERT_VALIDATION("IC0017", "Certificate validation done with OCSP"),
    IC0018_CRL_USED_FOR_CERT_VALIDATION("IC0018", "Certificate validation done with CRL"),
    IC0019_CERT_IS_VALID_FOR_PROFILE("IC0019", "The certificate is compliant with the verification profile"),
    IC0020_CERT_IS_CNS_COMPLIANT("IC0020", "The certificate is compliant with CNS Standard"),
    IC0021_ETSI_DIGEST_ALGORITHM_NOT_RECOMMENDED("IC0021", "Certificate does not comply EU recommendation about Trust Services: Digest Algorithm {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    IC0022_CERT_ADDITIONAL_INFO("IS0022", "Additional Information"),
    IC0023_ETSI_KEY_LENGTH_NOT_RECOMMENDED("IS0023", "Certificate does not comply EU recommendation about Trust Services: Key Length {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0001_CERT_NOT_VALID("EC0001", "The certificate is not valid"),
    EC0002_INVALID_CERT_AUTHORITY("EC0002", "The authority that issued the certificate is not reliable", ETSISubIndication.NO_CERTIFICATE_CHAIN_FOUND),
    EC0003_CERT_NOT_RELIABLE("EC0003", "The certificate is not reliable"),
    EC0004_CERT_NOT_COMPLIANCE("EC0004", "The certificate is not compliant", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0005_CERT_NOT_TIME_VALID("EC0005", "The certificate is no longer valid", ETSISubIndication.EXPIRED),
    EC0006_CERT_SUSPENDED("EC0006", "The certificate is suspended: suspension date {0}", ETSISubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE),
    EC0007_CERT_REVOKED("EC0007", "The certificate is revoked: revocation date {0}", ETSISubIndication.REVOKED),
    EC0008_CERT_ALTERED("EC0008", "The signature of the signing certificate is corrupt", ETSISubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE),
    EC0009_NOSHA256("EC0009", "Hash algorithm used for certificate signature is not SHA-256", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0010_NOCNIPA45("EC0010", "The certificate is not compliant with the deliberation CNIPA 45/2009"),
    EC0011_NODIGITALSIGNATURE("EC0011", "The certificate used is not a digital signature certificate", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0012_CERT_TSA_ALTERED("EC0012", "TSA certificate is corrupt", ETSISubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE),
    EC0013_CERT_TSA_NOCNIPA45("EC0013", "The certificate used is not compliant with the TSA certificate format", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0014_INVALID_CERT_TSA_AUTHORITY("EC0014", "The authority that issued the TSA certificate is not reliable", ETSISubIndication.CHAIN_CONSTRAINTS_FAILURE),
    EC0015_NO_CERT_INSIDE_SIGNATURE("EC0015", "No certificate associated to the signature", ETSISubIndication.NO_SIGNING_CERTIFICATE_FOUND),
    EC0016_INVALID_CERT_KEY_LENGTH("EC0016", "Key Length must be almost 2048 bits", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0017_INVALID_CERT_VERSION("EC0017", "Invalid Certifiate Version", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0018_INVALID_CERT_ISSUER_SEMANTIC("EC0018", "The Certificate Issuer is not compliant with his semantic identifier", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0019_INVALID_CERT_NATURAL_SEMANTIC("EC0019", "The Certificate is not compliant with the semantic identifier about natural person", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0020_INVALID_CERT_LEGAL_SEMANTIC("EC0020", "The Certificate is not compliant with the semantic identifier about legal person", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0021_OCSP_AND_CRL_INFORMATION_NOT_PRESENT("EC0021", "Information about OCSP Responder and CRL Distribuition Points are not present", ETSISubIndication.REVOKED_NO_POE),
    EC0022_NOAGID189("EC0022", "The certificate is not compliant with the deliberation AGID 189/2017", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0023_CERT_AUTHORITY_NOT_VALID_FOR_PROFILE("EC0023", "The authority that issued the certificate is not valid for selected validation profile", ETSISubIndication.CHAIN_CONSTRAINTS_FAILURE),
    EC0024_CERT_IS_NOT_CNS_COMPLIANT("EC0024", "Certificate is not CNS Compliant", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0025_DIGEST_ALGORITHM_NOT_SUPPORTED("EC0025", "Digest Algorithm Not Supported: {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0026_DIGEST_ALGORITHM_FORBIDDEN("EC0026", "Digest Algorithm Forbidden: {0}", ETSISubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE),
    EC0027_NOEIDAS_COMPLIANT("EC0027", "Certificate is not compliant with Regulation (EU) No. 910/2014 - eIDAS", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    EC0028_NO_CHAIN_FOUND("EC0028", "No certificate chain found", ETSISubIndication.NO_CERTIFICATE_CHAIN_FOUND),
    EC0029_INVALID_CERTIFICATE_CHAIN("EC0029", "Invalid certificate chain", ETSISubIndication.CHAIN_CONSTRAINTS_FAILURE),
    WC0001_STATUS_UNKNOWN("WC0001", "Not possible to verify the revocation status", ETSISubIndication.REVOKED_NO_POE),
    WC0002_STATUS_TEMP_UNAVAIABLE("WC0002", "A temporary disruption of the service may have been caused by the certifier that issued the certificate. Please try again later", ETSISubIndication.REVOKED_NO_POE),
    WC0003_STATUS_WARNING("WC0003", "The certificate is reliable with reservations"),
    WC0004_TSACERT_STATUS_UNKNOWN("WC0004", "The TSA revocation information is not correct", ETSISubIndication.REVOKED_NO_POE),
    WC0005_TSACERT_STATUS_TEMP_UNAVAIABLE("WC0005", "A temporary disruption of the service may have been caused by the certifier that issued the timestamp. Please try again later"),
    WC0006_SERIALNUMBER_NOT_COMPLIANT("WC0006", "Serial Number is not compliant"),
    WC0007_AIA_NOT_PRESENT("WC0007", "Authority Info Access is not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0008_AKI_NOT_PRESENT("WC0008", "Authority Key Identifier is not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0009_DNQUALIFIER_NOT_PRESENT("WC0009", "dnQualifier is not present in Subject data"),
    WC0010_POLICY_MAPPINGS_NOT_ALLOWED("WC0010", "Policy Mappings Extension is not allowed", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0011_CERTIFICATE_POLICIES_NOT_PRESENT("WC0011", "Certificate Policies Extension is not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0012_NAME_CONSTRAINTS_NOT_ALLOWED("WC0012", "Name Constraints Extension is not allowed", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0013_INHIBIT_ANY_POLICY_NOT_ALLOWED("WC0013", "Inhibit Any-Policy Extension is not allowed", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0014_CERT_NOT_COMPLIANT_AGID189("WC0014", "The certificate is not strictly compliant with the deliberation AGID 189/2017"),
    WC0015_CAISSUER_NOT_PRESENT("WC0015", "CA Issuer is not present", ETSISubIndication.SIG_CONSTRAINTS_FAILURE),
    WC0016_INVALID_ISSUER_DPCM45("WC0016", "The issuer field does not contains one of following mandatory attributes: OragnizationName, CountryName"),
    WC0017_INVALID_SUBJECT_DPCM45("WC0017", "The subject field does not contains one of following mandatory attributes: (GivenName, Surname or Pseudonym), OragnizationName, CountryName, SerialNumber, dnQualifier"),
    ED0001_INVALID_DIGEST("ED0001", "The document is corrupt", ETSISubIndication.HASH_FAILURE),
    ED0002_DOCUMENT_NOT_SIGNED("ED0002", "The document is not signed"),
    IA0001_VALIDATION_PROFILE_QUALIFIED("IA0001", "Qualified"),
    IA0002_VALIDATION_PROFILE_CNS("IA0002", "CNS"),
    IA0003_VALIDATION_PROFILE_FEA("IA0003", "Not Qualified"),
    IA0004_VALIDATION_PROFILE_GRAPHOMETRIC("IA0004", "Graphometric"),
    IA0005_VALIDATION_PROFILE_ALL("IA0005", "All"),
    EMPTY("", "");

    private final String code;
    private final String defaultMessage;
    private final ETSISubIndication etsi;

    private ValidatorMessageEnum(String code, String defaultMessage) {
        this(code, defaultMessage, ETSISubIndication.NONE_OR_OTHER_NOT_MAPPED);
    }

    private ValidatorMessageEnum(String code, String defaultMessage, ETSISubIndication subIndication) {
        this.code = code;
        this.defaultMessage = defaultMessage;
        this.etsi = subIndication;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getShortName() {
        return this.toString();
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public ETSISubIndication getEtsiSubIndication() {
        return this.etsi;
    }
}

