/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.FileHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileInputHandler
extends InputHandler
implements FileHandler {
    protected File file = null;

    public FileInputHandler(File file, String name) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The specified file [" + file.getAbsolutePath() + "] doesn't exist!");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The specified file [" + file.getAbsolutePath() + "] is a directory!");
        }
        this.file = file;
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, name != null ? name : file.getName(), file.length());
    }

    public FileInputHandler(File file) throws FileNotFoundException {
        this(file, null);
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        BufferedInputStream ret = null;
        try {
            ret = new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

