/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.InputFilter;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public abstract class InputHandler
extends DataHandler
implements Closeable {
    protected List<InputStream> trackedStreams = new ArrayList<InputStream>();
    protected List<InputFilter> filters = new ArrayList<InputFilter>();
    protected boolean closed = false;
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public InputStream getInputAsNewStream() throws IOException {
        return this.getInputAsNewStream(true);
    }

    public InputStream getInputAsNewStream(boolean track) throws IOException {
        if (!this.closed) {
            InputStream in = this.customGetInputAsNewStream();
            if (in == null) {
                logger.error("customGetInputAsNewStream returns null!");
            }
            if (this.filters != null) {
                for (InputFilter filter : this.filters) {
                    in = filter.applayFilter(in);
                }
            }
            if (track) {
                this.trackedStreams.add(in);
            }
            if (in == null) {
                logger.error("getInputAsNewStream returns null!");
            }
            return in;
        }
        throw new IOException("Handler is closed");
    }

    protected abstract InputStream customGetInputAsNewStream();

    @Override
    public void close() {
        for (InputStream is : this.trackedStreams) {
            Util.closeQuietly(is);
        }
        this.closed = true;
    }

    public void addFilter(InputFilter filter) {
        this.filters.add(filter);
    }

    public void resetFilter() {
        this.filters.clear();
    }
}

