/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OutputHandler
extends DataHandler
implements Closeable,
Flushable {
    protected ProxyOutputStreamHandler proxyOutputStream = null;
    protected Long writtenSize = 0L;
    protected OutputStream outputStream = null;
    protected boolean isInit = false;
    protected boolean closed = false;

    public Long getWrittenSize() {
        return this.writtenSize;
    }

    void setTotalSizeForced(Long totalSize) {
        this.totalSize = totalSize;
    }

    public boolean isSizeConstrained() {
        return this.totalSize != null;
    }

    public boolean isFull() {
        return this.totalSize != null && this.writtenSize >= this.totalSize;
    }

    public void write(int b) throws IOException {
        this.throwExIfNecessary(1);
        this.initBeforeFirstWriteIfNecessary();
        this.outputStream.write(b);
        OutputHandler outputHandler = this;
        Long l = outputHandler.writtenSize;
        Long l2 = outputHandler.writtenSize = Long.valueOf(outputHandler.writtenSize + 1L);
    }

    public void write(byte[] b) throws IOException {
        this.throwExIfNecessary(b.length);
        this.initBeforeFirstWriteIfNecessary();
        this.outputStream.write(b);
        OutputHandler outputHandler = this;
        outputHandler.writtenSize = outputHandler.writtenSize + (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.throwExIfNecessary(len);
        this.initBeforeFirstWriteIfNecessary();
        this.outputStream.write(b, off, len);
        OutputHandler outputHandler = this;
        outputHandler.writtenSize = outputHandler.writtenSize + (long)len;
    }

    private void initBeforeFirstWriteIfNecessary() throws IOException {
        if (!this.isInit) {
            this.isInit = true;
            this.initBeforeFirstWrite();
        }
    }

    protected void initBeforeFirstWrite() throws IOException {
    }

    protected void finalizeBeforeClosing() throws IOException {
    }

    protected void throwExIfNecessary(int bytesToWrite) throws IOException {
        if (this.totalSize != null && this.writtenSize + (long)bytesToWrite > this.totalSize) {
            throw new IOException("Unable to write " + bytesToWrite + " byte(s) because specified final size is " + this.totalSize + " and actual written size is " + this.writtenSize + ".");
        }
    }

    public OutputStream getAsOutputStream() throws IOException {
        if (!this.closed) {
            if (this.proxyOutputStream == null) {
                this.proxyOutputStream = new ProxyOutputStreamHandler();
            }
            return this.proxyOutputStream;
        }
        throw new IOException("Handler is Closed");
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.finalizeBeforeClosing();
            Util.closeQuietly(this.outputStream);
            this.proxyOutputStream = null;
            this.closed = true;
        }
    }

    public class ProxyOutputStreamHandler
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
            OutputHandler.this.write(b);
        }

        @Override
        public void close() throws IOException {
            OutputHandler.this.close();
        }

        @Override
        public void flush() throws IOException {
            OutputHandler.this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputHandler.this.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            OutputHandler.this.write(b);
        }
    }
}

