/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.slf4j.Logger;

public class ArubaTrustStore {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static KeyStore trustStoreRs;
    private static KeyStore cdb;
    private static HashMap<String, String> hashes;
    private static HashMap<String, KeyStore> cdbs;
    private static X509Certificate[] roots;
    public static final String DEFAULT = "default";

    public static void setTSRS(String domain, String hash, String path) throws Exception {
        if (domain != null && hash != null) {
            if (!cdbs.containsKey(hash)) {
                cdbs.put(hash, CertDB.getInstance(path, "AmPJz+RpQF0JaEKc/vk6SrCZMtCp46bM44bgKEMGyHsYjLAk7H", false, false).toTrustStore());
            }
            hashes.put(domain, hash);
        }
    }

    public static KeyStore getTSRS(String domain) {
        if (domain == null || !hashes.containsKey(domain)) {
            return cdbs.get(DEFAULT);
        }
        if (!cdbs.containsKey(hashes.get(domain))) {
            return null;
        }
        return cdbs.get(hashes.get(domain));
    }

    public static KeyStore getTSRS() {
        return cdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        hashes = new HashMap();
        cdbs = new HashMap();
        roots = null;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            it.actalis.ellips.util.File tmp = TmpFileUtils.createTempFile("remote_signature", ".cdb");
            os = new FileOutputStream(tmp);
            is = ArubaTrustStore.class.getResourceAsStream("/it/actalis/ellips/capi/http/arubautils/cdb/rs");
            if (is != null) {
                byte[] buffer = new byte[64000];
                int letti = is.read(buffer);
                while (letti != -1) {
                    os.write(buffer, 0, letti);
                    letti = is.read(buffer);
                }
            }
            is.close();
            is = null;
            os.close();
            os = null;
            cdb = CertDB.getInstance(tmp.getAbsolutePath(), "AmPJz+RpQF0JaEKc/vk6SrCZMtCp46bM44bgKEMGyHsYjLAk7H", false, false).toTrustStore();
            String rsts = System.getProperty("esecurity.rsts");
            if (rsts != null && !rsts.equals("")) {
                File file = new File(rsts);
                if (file.exists()) {
                    trustStoreRs = KeyStore.getInstance("JKS");
                    is = new FileInputStream(file);
                    trustStoreRs.load(is, "AmPJz+RpQF0JaEKc/vk6SrCZMtCp46bM44bgKEMGyHsYjLAk7H".toCharArray());
                    logger.debug("Caricato root file custom");
                    cdb = trustStoreRs;
                } else {
                    logger.error("File " + rsts + " not found!");
                }
            }
            cdbs.put(DEFAULT, cdb);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        catch (CertDBException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage());
        }
        catch (CertificateException ex) {
            logger.error(ex.getMessage());
        }
        catch (KeyStoreException ex) {
            logger.error(ex.getMessage());
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

