/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.HttpsTrustManagerInterface;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class HttpsClient
extends HTTP {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected CertDB cdb = null;
    private String url = null;
    private HttpsTrustManagerInterface tmi = null;
    private int httpsport = 443;

    public HttpsClient(NetworkConfig config, Logger caller_logger) throws CapiException {
        super(config);
        if (caller_logger != null) {
            this.logger = caller_logger;
        }
    }

    public HttpsClient(String cdbpath, String cdbPIN) throws CapiException {
        this(CertDB.getInstance(cdbpath, cdbPIN, false, true), 443);
    }

    public HttpsClient(String cdbpath, String cdbPIN, int httpsport) throws CapiException {
        this(CertDB.getInstance(cdbpath, cdbPIN, false, true), httpsport, null);
    }

    public HttpsClient(String cdbpath, String cdbPIN, int httpsport, HttpsTrustManagerInterface tmi) throws CapiException {
        this(CertDB.getInstance(cdbpath, cdbPIN, false, true), httpsport, tmi);
    }

    public HttpsClient(String cdbpath, String cdbPIN, HttpsTrustManagerInterface tmi) throws CapiException {
        this(CertDB.getInstance(cdbpath, cdbPIN, false, true), 443, tmi);
    }

    public HttpsClient(CertDB cdb, int httpsport) throws CapiException {
        this(cdb, httpsport, null);
    }

    public HttpsClient(CertDB cdb) throws CapiException {
        this(cdb, 443, null);
    }

    public HttpsClient(CertDB cdb, HttpsTrustManagerInterface tmi) throws CapiException {
        this(cdb, 443, tmi);
    }

    public HttpsClient(CertDB cdb, int httpsport, HttpsTrustManagerInterface tmi) throws CapiException {
        this.cdb = cdb;
        this.httpsport = httpsport;
        this.tmi = tmi;
    }

    public CertDB getCDB() {
        return this.cdb;
    }

    public HttpsTrustManagerInterface getTmi() {
        return this.tmi;
    }
}

