/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.Actalis_ISO9796d2PSSSigner;
import it.actalis.ellips.capi.provider.Actalis_RSACipher;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.slf4j.Logger;

public class Crypto_ISO9796d2PSSSigner {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String HASH_ALG_SHA1 = "SHA-1";
    public static final String HASH_ALG_SHA256 = "SHA-256";
    public static final String HASH_ALG_RIPEMD160 = "RIPEMD160";
    private boolean implicit = false;
    private String digestAlg = "SHA-1";
    private boolean hasFullMessage = false;
    private byte[] recoveredMessage = null;

    public Crypto_ISO9796d2PSSSigner(String algName) throws CapiException {
        if (!algName.equalsIgnoreCase(HASH_ALG_SHA1)) {
            if (!algName.equalsIgnoreCase(HASH_ALG_SHA256)) {
                if (!algName.equalsIgnoreCase(HASH_ALG_RIPEMD160)) {
                    throw new CapiException("Digest Algorithm: " + algName + " not supported", 3011);
                }
            }
        }
        this.digestAlg = algName;
        logger.debug("constructor OK");
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public void verify(InputStream input, byte[] signature, byte[] signerCert, int blocksize) throws CapiException {
        logger.debug("verify");
        Certificate cert = new Certificate(signerCert);
        PublicKey pk = cert.getPublicKey();
        boolean result = false;
        try {
            SHA1Digest digest;
            BigInteger publicExp = ((RSAPublicKey)pk).getPublicExponent();
            BigInteger modulus = ((RSAPublicKey)pk).getModulus();
            Actalis_RSACipher aRsaciph = new Actalis_RSACipher();
            aRsaciph.engineSetPadding("NOPADDING");
            if (this.digestAlg.equalsIgnoreCase(HASH_ALG_SHA1)) {
                digest = new SHA1Digest();
            } else if (this.digestAlg.equalsIgnoreCase(HASH_ALG_SHA256)) {
                digest = new SHA256Digest();
            } else if (this.digestAlg.equalsIgnoreCase(HASH_ALG_RIPEMD160)) {
                digest = new RIPEMD160Digest();
            } else {
                throw new CapiException("Digest Algorithm: " + this.digestAlg + " not supported", 3011);
            }
            RSAKeyParameters pubParameters = new RSAKeyParameters(false, modulus, publicExp);
            this.recoveredMessage = null;
            this.hasFullMessage = false;
            Actalis_ISO9796d2PSSSigner signer = new Actalis_ISO9796d2PSSSigner(aRsaciph, (Digest)digest, digest.getDigestSize());
            signer.init(false, (CipherParameters)pubParameters, pk);
            byte[] block = new byte[blocksize];
            int nread = 0;
            while ((nread = input.read(block)) != -1) {
                if (nread == 0) continue;
                if (nread == block.length) {
                    signer.update(block, 0, block.length);
                    continue;
                }
                logger.debug("Crypto: hash last block read;len =" + nread);
                signer.update(block, 0, nread);
            }
            input.close();
            result = signer.verifySignature(signature);
            if (result) {
                logger.debug("signature successfully verified");
            } else {
                logger.debug("signature verify failed");
            }
            logger.debug("hasFullMessage: " + signer.hasFullMessage());
            this.hasFullMessage = signer.hasFullMessage();
            this.recoveredMessage = signer.getRecoveredMessage();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error. " + e.getMessage(), 1003);
        }
        catch (NoSuchPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error. " + e.getMessage(), 1003);
        }
        catch (BadPaddingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature. " + e.getMessage(), 3010);
        }
        catch (IllegalBlockSizeException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature. " + e.getMessage(), 3010);
        }
        catch (InvalidKeyException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid key format. " + e.getMessage(), 3000);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Invalid signature. " + e.getMessage(), 3010);
        }
        if (!result) {
            throw new CapiException("Invalid signature", 3010);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(String alias, InputStream input, int blocksize) throws CapiException {
        try {
            SHA1Digest digest;
            TokenSpi tk = Token.getTokenSpi(alias);
            if (tk == null) {
                throw new CapiException("Token not initialized", 10003);
            }
            PrivateKey sk = null;
            PublicKey pk = null;
            TokenSpi tokenSpi = tk;
            synchronized (tokenSpi) {
                sk = tk.getPrivateKey(alias);
                logger.debug("getPrivateKey done.");
                pk = tk.getPublicKey(alias);
                logger.debug("getPublicKey done.");
            }
            BigInteger privateExp = ((RSAPrivateKey)sk).getPrivateExponent();
            BigInteger publicExp = ((RSAPublicKey)pk).getPublicExponent();
            BigInteger modulus = ((RSAPublicKey)pk).getModulus();
            Actalis_RSACipher aRsaciph = new Actalis_RSACipher();
            aRsaciph.engineSetPadding("NOPADDING");
            if (this.digestAlg.equalsIgnoreCase(HASH_ALG_SHA1)) {
                digest = new SHA1Digest();
            } else if (this.digestAlg.equalsIgnoreCase(HASH_ALG_SHA256)) {
                digest = new SHA256Digest();
            } else if (this.digestAlg.equalsIgnoreCase(HASH_ALG_RIPEMD160)) {
                digest = new RIPEMD160Digest();
            } else {
                throw new CapiException("Digest Algorithm: " + this.digestAlg + " not supported", 3011);
            }
            RSAKeyParameters privParameters = new RSAKeyParameters(true, modulus, privateExp);
            this.recoveredMessage = null;
            this.hasFullMessage = false;
            Actalis_ISO9796d2PSSSigner signer = new Actalis_ISO9796d2PSSSigner(aRsaciph, (Digest)digest, digest.getDigestSize());
            signer.init(true, (CipherParameters)privParameters, sk);
            byte[] block = new byte[blocksize];
            int nread = 0;
            while ((nread = input.read(block)) != -1) {
                if (nread == 0) continue;
                if (nread == block.length) {
                    signer.update(block, 0, block.length);
                    continue;
                }
                signer.update(block, 0, nread);
            }
            input.close();
            byte[] signature = signer.generateSignature();
            return signature;
        }
        catch (CapiException ce) {
            throw ce;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            logger.debug("CapiException in sign ... " + e.getMessage());
            throw new CapiException(e.getMessage(), 50040);
        }
    }

    public boolean hasFullMessage() {
        return this.hasFullMessage;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

