/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureOptions;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public abstract class SignatureGenerator<T extends SignatureOptions, C extends BaseSignatureOptions>
extends BaseGenerator<T> {
    @Override
    public void validateOptions(T opts) throws CapiException {
    }

    public final void sign(T option) throws CapiException {
        this.parameterValidation(option);
        this.innerSign(option);
    }

    public final void addSign(T option) throws CapiException {
        this.parameterValidation(option);
        this.innerAddSign(option);
    }

    public final void updateSign(C option) throws CapiException {
        this.innerUpdateSign(option);
    }

    protected abstract void innerSign(T var1) throws CapiException;

    protected abstract void innerAddSign(T var1) throws CapiException;

    protected abstract void innerUpdateSign(C var1) throws CapiException;

    @Override
    protected void doGenerate() throws CapiException {
        this.innerSign((SignatureOptions)this.options);
    }

    protected final X509Certificate retrieveCert(T option) throws CapiException {
        X509Certificate x509Cert = null;
        try {
            x509Cert = (X509Certificate)((SignatureOptions)option).getKeyStore().getCertificate(((SignatureOptions)option).getAlias());
        }
        catch (KeyStoreException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, ex);
        }
        if (x509Cert == null) {
            throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
        }
        return x509Cert;
    }

    protected final Certificate retrieveCertCapi(T option) throws CapiException {
        Certificate x509Cert = null;
        try {
            X509Certificate cert = (X509Certificate)((SignatureOptions)option).getKeyStore().getCertificate(((SignatureOptions)option).getAlias());
            if (cert == null) {
                throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
            }
            byte[] array = cert.getEncoded();
            x509Cert = new Certificate(array);
        }
        catch (KeyStoreException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, ex);
        }
        catch (CertificateEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, ex);
        }
        if (x509Cert == null) {
            throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
        }
        return x509Cert;
    }

    protected final PrivateKey retrieveKey(T option) throws CapiException {
        PrivateKey privateKey = null;
        try {
            privateKey = ((SignatureOptions)option).getKeyStorePassword() != null ? (PrivateKey)((SignatureOptions)option).getKeyStore().getKey(((SignatureOptions)option).getAlias(), ((SignatureOptions)option).getKeyStorePassword().toCharArray()) : (PrivateKey)((SignatureOptions)option).getKeyStore().getKey(((SignatureOptions)option).getAlias(), null);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, ex);
        }
        if (privateKey == null) {
            throw new CapiException("Internal error. Unable to get signer key", 1003);
        }
        return privateKey;
    }

    protected final Provider retrieveProvider(T option) throws CapiException {
        return ((SignatureOptions)option).getKeyStore().getProvider();
    }

    protected final LTResourceResolver getLTResourceResolver(T option, boolean forceRetrieveResolver) {
        LTResourceResolver resolver = null;
        if (((BaseSignatureOptions)option).getSignatureLevel().compareTo(SignatureLevel.T) > 0 || forceRetrieveResolver) {
            NetworkConfig conf = HTTP.defaultConfig;
            if (((BaseSignatureOptions)option).getNetworkConfig() != null) {
                conf = ((BaseSignatureOptions)option).getNetworkConfig();
            }
            resolver = new LTResourceResolver(conf, logger, ((BaseSignatureOptions)option).getCertdb());
        }
        return resolver;
    }

    protected void parameterValidation(T option) throws CapiException {
        if (option == null) {
            throw new CapiException("Invalid Signature Options", 1001);
        }
        if (((BaseSignatureOptions)option).getSignatureLevel().equals((Object)SignatureLevel.LTA)) {
            throw new CapiException("FORMAT NOT SUPPORTED", 1001);
        }
        if (((BaseSignatureOptions)option).getInput() == null && ((BaseSignatureOptions)option).getDetachedContent() == null) {
            throw new CapiException("Invalid Input NULL", 1001);
        }
        if (((BaseSignatureOptions)option).getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (((SignatureOptions)option).getAlias() == null) {
            throw new CapiException("Invalid Alias NULL", 1001);
        }
        if (((BaseSignatureOptions)option).getDigestAlgorithm() == null) {
            throw new CapiException("Invalid DigestAlgorithm NULL", 1001);
        }
        if (((SignatureOptions)option).getKeyStore() == null) {
            throw new CapiException("Invalid KeyStore NULL", 1001);
        }
        if (((BaseSignatureOptions)option).getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (((BaseSignatureOptions)option).getSignatureLevel() == null) {
            throw new CapiException("Invalid SignatureLevel NULL", 1001);
        }
        if (!((BaseSignatureOptions)option).getSignatureLevel().equals((Object)SignatureLevel.BES)) {
            if (((BaseSignatureOptions)option).getTimeStampOptions() == null) {
                throw new CapiException("Invalid TimeStampOptions NULL but signature level T LT LTA", 1001);
            }
            if (((BaseSignatureOptions)option).getSignatureLevel().compareTo(SignatureLevel.T) > 0 && ((BaseSignatureOptions)option).getCertdb() == null) {
                throw new CapiException("Invalid Certdb NULL but signature level LT LTA", 1001);
            }
        }
        if (((BaseSignatureOptions)option).getSignatureMode() == null) {
            throw new CapiException("Invalid SignatureMode NULL", 1001);
        }
        if (((BaseSignatureOptions)option).getDigestAlgorithm() == DigestAlgorithm.MD5 || ((BaseSignatureOptions)option).getDigestAlgorithm() == DigestAlgorithm.GOST3411 || ((BaseSignatureOptions)option).getDigestAlgorithm() == DigestAlgorithm.RIPEMD128 || ((BaseSignatureOptions)option).getDigestAlgorithm() == DigestAlgorithm.RIPEMD160 || ((BaseSignatureOptions)option).getDigestAlgorithm() == DigestAlgorithm.RIPEMD256) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }
}

