/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAResponseValidator;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.UserData;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;
import org.slf4j.Logger;

public class InfoCertDTSClient
extends DTSClient {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public InfoCertDTSClient(TSAData tsaData) throws IllegalParamException {
        this(tsaData, null);
    }

    public InfoCertDTSClient(UserData userData, NetworkConfig netConf) throws IllegalParamException {
        this(new TSAData(userData.getTsaUrl(), userData.getTsaAlternativeUrl(), null, userData.getTsaUsername(), userData.getTsaPassword(), userData.getTsaAlternativeUsername(), userData.getTsaAlternativePassword()), null);
    }

    public InfoCertDTSClient(TSAData tsaData, NetworkConfig netConf) throws IllegalParamException {
        this(tsaData, netConf, null);
    }

    public InfoCertDTSClient(TSAData tsaData, NetworkConfig netConf, String requestedUrl) throws IllegalParamException {
        super(tsaData, netConf, requestedUrl);
    }

    @Override
    public void initializeClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        this.tsaData = tsaData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = requestedUrl;
        if (requestedUrl == null) {
            this.requestedUrl = tsaData.getTSAUrl();
        }
    }

    @Override
    public void setServer(String tsaUrl, HTTP http) throws IllegalParamException {
        this.tsaData.setTSAUrl(tsaUrl);
        this.netConf = http.getConfig();
    }

    @Override
    public void setServer(String serverAddr, int serverPort) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setTimeout(long timeOut) throws IllegalParamException {
        this.netConf.setConnectionTimeOut("" + timeOut);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message) throws TSAException, IOException, IllegalParamException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message) throws IOException, TSAException, IllegalParamException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message, BigInteger nonce, boolean certReq) throws TSAException {
        try {
            TimeStampRequest request = TSAUtil.generateMarkRequest(algorithm, nonce, message, policy, certReq);
            TimeStampResponse response = TSAUtil.getMarkFromRequest(request, this.requestedUrl, this.tsaData, this.netConf, new TSAResponseValidator(){

                @Override
                public TSAMessageEnum validateTSAResponse(UrlReturn response) {
                    return InfoCertDTSClient.validateResponse(response);
                }
            });
            return new TimeStampToken(response.getEncoded());
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, ex);
        }
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message, BigInteger nonce, boolean certReq) throws TSAException {
        try {
            return new TimeStampToken(this.getMark(message, certReq).getEncoded());
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, ex);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash) throws ApiGeneralException, IOException, TSAException {
        return this.timeStampHash(policy, algorithm, hash, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash, BigInteger nonce, boolean certReq) throws ApiGeneralException, IOException, TSAException {
        try {
            TimeStampRequest request = TSAUtil.generateMarkRequest(algorithm, nonce, hash, policy, certReq);
            TimeStampResponse response = TSAUtil.getMarkFromRequest(request, this.requestedUrl, this.tsaData, this.netConf, new TSAResponseValidator(){

                @Override
                public TSAMessageEnum validateTSAResponse(UrlReturn response) {
                    return InfoCertDTSClient.validateResponse(response);
                }
            });
            return new TimeStampToken(response.getEncoded());
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampResponse getMark(InputStream message, boolean certReq) throws ApiGeneralException, IOException, TSAException {
        try {
            TimeStampResponse objReturn = TSAUtil.getMark(message, certReq, this.tsaData, this.netConf, new TSAResponseValidator(){

                @Override
                public TSAMessageEnum validateTSAResponse(UrlReturn response) {
                    return InfoCertDTSClient.validateResponse(response);
                }
            });
            return objReturn;
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException | TSPException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, (Exception)ex);
        }
    }

    @Override
    public byte[] stamp(InputStream is, TimeStampOptions options) {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (CapiException | IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream is, TimeStampOptions options) throws TSAException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    private static TSAMessageEnum validateResponse(UrlReturn response) {
        TSAMessageEnum objReturn = null;
        if (response == null || response.getStatus() == null || !response.getStatus().equals("OK") || response.getData() == null) {
            objReturn = TSAMessageEnum.INTERNAL_ERROR;
            if (response != null && response.getStatus() != null && !response.getStatus().equals("OK") && response.getStatus_code() == -1 && response.getStatus().equals("KO")) {
                objReturn = TSAMessageEnum.NETWORK_ERROR;
            }
        } else if (response.getStatus().equals("OK")) {
            try {
                String responseMessage = new String(response.getData());
                String errorLabel = null;
                if (responseMessage.contains("MSGNO")) {
                    errorLabel = "MSGNO";
                } else if (responseMessage.contains("ERRNO")) {
                    errorLabel = "ERRNO";
                }
                if (errorLabel != null) {
                    String errorNumber = responseMessage.substring(responseMessage.indexOf(errorLabel) + 6, responseMessage.indexOf("DESCR")).trim();
                    String errorMessage = responseMessage.substring(responseMessage.indexOf("DESCR") + 6).trim();
                    logger.error("TSA error " + errorNumber + ": " + errorMessage);
                    switch (errorNumber) {
                        case "1000": {
                            objReturn = TSAMessageEnum.BAD_REQUEST;
                            break;
                        }
                        case "1100": {
                            objReturn = TSAMessageEnum.RESOURCE_NOT_FOUND;
                            break;
                        }
                        case "1200": {
                            objReturn = TSAMessageEnum.BAD_REQUEST;
                            break;
                        }
                        case "1300": {
                            objReturn = TSAMessageEnum.ACCOUNT_BAD_CREDENTIALS;
                            break;
                        }
                        case "1400": {
                            objReturn = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1500": {
                            objReturn = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1600": {
                            objReturn = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1700": {
                            objReturn = TSAMessageEnum.INTERNAL_ERROR;
                            break;
                        }
                        case "1900": {
                            objReturn = TSAMessageEnum.NO_MORE_TIMESTAMPS;
                            break;
                        }
                        default: {
                            objReturn = TSAMessageEnum.INTERNAL_ERROR;
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return objReturn;
    }
}

