/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static String toHex(byte[] data, boolean capitalize) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        String hex = buf.toString();
        return capitalize ? hex.toUpperCase() : hex.toLowerCase();
    }

    public static byte[] calculate(DigestAlgorithm algo, InputStream is) throws NoSuchAlgorithmException, IOException {
        MessageDigest algorithm = MessageDigest.getInstance(algo.toString());
        BufferedInputStream bis = new BufferedInputStream(is);
        DigestInputStream dis = new DigestInputStream(bis, algorithm);
        while (dis.read() != -1) {
        }
        return algorithm.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculate(DigestAlgorithm algo, byte[] message) throws IOException, NoSuchAlgorithmException {
        ByteArrayInputStream is = new ByteArrayInputStream(message);
        byte[] arrReturn = null;
        try {
            arrReturn = DigestUtils.calculate(algo, is);
        }
        finally {
            Util.closeQuietly(is);
        }
        return arrReturn;
    }

    public static String calculateHexString(DigestAlgorithm algo, InputStream is) throws IOException, NoSuchAlgorithmException {
        byte[] arrReturn = DigestUtils.calculate(algo, is);
        return DigestUtils.toHex(arrReturn, false);
    }

    public static String calculateHexString(DigestAlgorithm algo, InputStream is, boolean capitalize) throws IOException, NoSuchAlgorithmException {
        byte[] arrReturn = DigestUtils.calculate(algo, is);
        return DigestUtils.toHex(arrReturn, capitalize);
    }

    public static String calculateHexString(DigestAlgorithm algo, byte[] message) throws IOException, NoSuchAlgorithmException {
        byte[] arrReturn = DigestUtils.calculate(algo, message);
        return DigestUtils.toHex(arrReturn, false);
    }

    public static String calculateHexString(DigestAlgorithm algo, byte[] message, boolean capitalize) throws IOException, NoSuchAlgorithmException {
        byte[] arrReturn = DigestUtils.calculate(algo, message);
        return DigestUtils.toHex(arrReturn, capitalize);
    }
}

