/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class MarkableFileInputStream
extends FilterInputStream {
    private FileChannel myFileChannel;
    private long mark = 0L;

    public MarkableFileInputStream(FileInputStream fis) {
        super(fis);
        this.myFileChannel = fis.getChannel();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.myFileChannel.position();
        }
        catch (IOException ex) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("not marked");
        }
        this.myFileChannel.position(this.mark);
    }
}

