/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;

public class PKCSComponents {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFromPublic(File fileDer, boolean checkSize) throws IOException, Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileDer);
            byte[] byArray = PKCSComponents.getFromPublic(fis, checkSize);
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            fis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFromPublic(FileInputStream fisDer, boolean checkSize) throws IOException, Exception {
        ByteArrayOutputStream ous = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            int read = 0;
            while ((read = fisDer.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
            byte[] byArray = PKCSComponents.getFromPublic(ous.toByteArray(), checkSize);
            return byArray;
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            ous = null;
        }
    }

    public static byte[] getFromPublic(byte[] der, boolean checkSize) throws IOException, Exception {
        ASN1ObjectIdentifier asn1ObjId;
        ASN1Sequence asn1SeqInternal;
        ASN1Encodable asn1EncInternal;
        ASN1InputStream asn1InStream = new ASN1InputStream(der);
        ASN1Primitive asn1Primitive = asn1InStream.readObject();
        if (asn1Primitive == null) {
            throw new Exception("unable to parse the input");
        }
        ASN1Sequence asn1Seq = ASN1Sequence.getInstance((Object)asn1Primitive);
        if (asn1Seq == null) {
            throw new Exception("unable to parse the input");
        }
        if (asn1Seq.size() != 2) {
            throw new Exception("invalid input: unexpected size of " + asn1Seq.size());
        }
        ASN1Encodable asn1Enc = asn1Seq.getObjectAt(0);
        if (asn1Enc.toASN1Primitive() instanceof ASN1Sequence && (asn1EncInternal = (asn1SeqInternal = ASN1Sequence.getInstance((Object)asn1Enc)).getObjectAt(0)) instanceof ASN1ObjectIdentifier && (asn1ObjId = (ASN1ObjectIdentifier)asn1EncInternal).getId().compareToIgnoreCase("1.2.840.113549.1.1.1") != 0) {
            throw new Exception("invalid input: unexpected OID, " + asn1ObjId.getId());
        }
        byte[] retBuf = null;
        byte[] modIntData = null;
        byte[] pubIntData = null;
        asn1Enc = asn1Seq.getObjectAt(1);
        if (asn1Enc.toASN1Primitive() instanceof DERBitString) {
            DERBitString derBitString = (DERBitString)asn1Enc.toASN1Primitive();
            byte[] byteStringData = derBitString.getBytes();
            ASN1InputStream byteAsn1InStream = new ASN1InputStream(byteStringData);
            ASN1Primitive byteAsn1Primitive = byteAsn1InStream.readObject();
            ASN1Sequence subAsn1Seq = ASN1Sequence.getInstance((Object)byteAsn1Primitive);
            ASN1Encodable subAsn1Enc = subAsn1Seq.getObjectAt(0);
            if (subAsn1Enc.toASN1Primitive() instanceof ASN1Integer) {
                ASN1Integer moduleBitString = (ASN1Integer)subAsn1Enc.toASN1Primitive();
                modIntData = moduleBitString.getValue().toByteArray();
                if (checkSize && modIntData.length != 129 && modIntData.length != 257) {
                    throw new Exception("invalid input: module size is " + modIntData.length);
                }
            }
            if ((subAsn1Enc = subAsn1Seq.getObjectAt(1)).toASN1Primitive() instanceof ASN1Integer) {
                ASN1Integer pubBitString = (ASN1Integer)subAsn1Enc.toASN1Primitive();
                pubIntData = pubBitString.getValue().toByteArray();
            }
            if (modIntData == null || pubIntData == null) {
                throw new Exception("some data no found");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(modIntData);
            outputStream.write(pubIntData);
            retBuf = outputStream.toByteArray();
        }
        return retBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromPrivate(File fileDer, boolean checkSize) throws IOException, Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileDer);
            byte[] byArray = this.getFromPrivate(fis, checkSize);
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            fis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromPrivate(FileInputStream fisDer, boolean checkSize) throws IOException, Exception {
        ByteArrayOutputStream ous = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            int read = 0;
            while ((read = fisDer.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
            byte[] byArray = this.getFromPrivate(ous.toByteArray(), checkSize);
            return byArray;
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            ous = null;
        }
    }

    public byte[] getFromPrivate(byte[] der, boolean checkSize) throws IOException, Exception {
        ASN1InputStream asn1InStream = new ASN1InputStream(der);
        ASN1Primitive asn1Primitive = asn1InStream.readObject();
        if (asn1Primitive == null) {
            throw new Exception("unable to parse the input");
        }
        ASN1Sequence asn1Seq = ASN1Sequence.getInstance((Object)asn1Primitive);
        if (asn1Seq == null) {
            throw new Exception("unable to parse the input");
        }
        if (asn1Seq.size() != 3) {
            throw new Exception("invalid input: unexpected size of " + asn1Seq.size());
        }
        ASN1Encodable asn1Enc = asn1Seq.getObjectAt(2);
        byte[] retBuf = null;
        byte[] modIntData = null;
        byte[] expIntData = null;
        byte[] privIntData = null;
        if (asn1Enc.toASN1Primitive() instanceof DEROctetString) {
            DEROctetString derBitString = (DEROctetString)asn1Enc.toASN1Primitive();
            byte[] octStringData = derBitString.getOctets();
            ASN1InputStream octAsn1InStream = new ASN1InputStream(octStringData);
            ASN1Primitive octAsn1Primitive = octAsn1InStream.readObject();
            ASN1Sequence octAsn1Seq = ASN1Sequence.getInstance((Object)octAsn1Primitive);
            if (octAsn1Seq.size() != 9) {
                throw new Exception("invalid input: unexpected size of " + asn1Seq.size());
            }
            ASN1Encodable subAsn1Enc = octAsn1Seq.getObjectAt(1);
            if (subAsn1Enc.toASN1Primitive() instanceof ASN1Integer) {
                ASN1Integer moduleBitString = (ASN1Integer)subAsn1Enc.toASN1Primitive();
                modIntData = moduleBitString.getValue().toByteArray();
                if (checkSize && modIntData.length != 129 && modIntData.length != 257) {
                    throw new Exception("invalid input: module size is " + modIntData.length);
                }
            }
            if ((subAsn1Enc = octAsn1Seq.getObjectAt(2)).toASN1Primitive() instanceof ASN1Integer) {
                ASN1Integer expBitString = (ASN1Integer)subAsn1Enc.toASN1Primitive();
                expIntData = expBitString.getValue().toByteArray();
            }
            if ((subAsn1Enc = octAsn1Seq.getObjectAt(3)).toASN1Primitive() instanceof ASN1Integer) {
                ASN1Integer privBitString = (ASN1Integer)subAsn1Enc.toASN1Primitive();
                privIntData = privBitString.getValue().toByteArray();
                if (checkSize && modIntData.length != 129 && modIntData.length != 257) {
                    throw new Exception("invalid input: module size is " + modIntData.length);
                }
            }
        }
        if (modIntData == null || expIntData == null || privIntData == null) {
            throw new Exception("some data no found");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(modIntData);
        outputStream.write(expIntData);
        outputStream.write(privIntData);
        retBuf = outputStream.toByteArray();
        return retBuf;
    }
}

