/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.ini;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniFile;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.IniSerializableObject;
import it.actalis.ellips.capi.util.ini.IniStringHashMap;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class SignedIniFile
extends IniFile {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private byte[] loadTkId = null;
    private byte[] loadhMac = null;
    private boolean loadexist = false;

    public SignedIniFile() {
    }

    public SignedIniFile(String tokenid) {
        try {
            this.loadTkId = Util.getBytes(tokenid);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        this.loadexist = false;
    }

    public SignedIniFile(String fileName, byte[] pin) throws IOException, IniFileException, UnrecoverableKeyException, InstantiationException, IllegalAccessException {
        this(fileName, pin, IniStringHashMap.class);
    }

    public SignedIniFile(String fileName, byte[] pin, Class<? extends IniSerializableObject> IniSerializableClass) throws IOException, IniFileException, UnrecoverableKeyException, InstantiationException, IllegalAccessException {
        this.load(fileName, pin, IniSerializableClass);
        this.loadexist = true;
    }

    private void load(String fileName, byte[] pin, Class<? extends IniSerializableObject> IniSerializableClass) throws IOException, IniFileException, UnrecoverableKeyException, UnsupportedEncodingException, InstantiationException, IllegalAccessException {
        logger.debug("loading " + fileName);
        byte[] content = this.readFile(fileName);
        logger.debug("loaded " + content.length + " bytes from " + fileName);
        int[] index = new int[]{-1, -1};
        int n = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != 13 || content[i + 1] != 10) continue;
            index[n++] = i;
            if (n == 2) break;
        }
        if (index[1] == -1) {
            throw new IniFileException("No HMAC present", 3);
        }
        this.loadTkId = new byte[index[0] - 0 - 1];
        this.loadhMac = new byte[index[1] - index[0] - 3];
        byte[] data = new byte[content.length - index[1] - 4];
        System.arraycopy(content, 1, this.loadTkId, 0, this.loadTkId.length);
        System.arraycopy(content, index[0] + 3, this.loadhMac, 0, this.loadhMac.length);
        System.arraycopy(content, index[1] + 4, data, 0, data.length);
        byte[] hMacFromData = this.computeHMACBase64(data, pin);
        logger.debug("loadhmac:" + new String(this.loadhMac, "ISO8859_1"));
        logger.debug("datahmac:" + new String(hMacFromData, "ISO8859_1"));
        if (!Arrays.areEqual((byte[])this.loadhMac, (byte[])hMacFromData)) {
            throw new UnrecoverableKeyException("The password is wrong.");
        }
        this.load(content, IniSerializableClass);
    }

    private byte[] readFile(String fileName) throws IOException {
        File file = new File(fileName);
        byte[] content = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        fis.read(content);
        fis.close();
        return content;
    }

    public void store(String fileName, byte[] pin, boolean ignoreexist) throws IniFileException, IOException, UnrecoverableKeyException {
        if (!ignoreexist && this.loadexist) {
            try {
                this.loadHeader(fileName, true);
            }
            catch (IniFileException c) {
                logger.debug(c.getMessage(), (Throwable)c);
                throw c;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new IniFileException("token probably removed after opening session", 0);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.store(bos);
        byte[] content = bos.toByteArray();
        byte[] newhMac = this.computeHMACBase64(content, pin);
        logger.debug("storing new hmac " + new String(newhMac, "ISO8859_1"));
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            fos.write(Util.getBytes("#"));
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        fos.write(this.loadTkId);
        fos.write(13);
        fos.write(10);
        try {
            fos.write(Util.getBytes("#"));
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        fos.write(newhMac);
        fos.write(13);
        fos.write(10);
        fos.write(13);
        fos.write(10);
        fos.write(content);
        fos.close();
        logger.debug("closed output file.");
        this.loadhMac = newhMac;
        logger.debug("storhmac:" + new String(this.loadhMac, "ISO8859_1"));
    }

    public void store(String fileName, byte[] pin) throws IniFileException, IOException, UnrecoverableKeyException {
        this.store(fileName, pin, false);
    }

    public byte[] loadHeader(String fileName, boolean andcheck) throws IOException, UnrecoverableKeyException, IniFileException {
        logger.debug("loadingHeader from " + fileName);
        byte[] content = this.readFile(fileName);
        logger.debug("loaded " + content.length + " bytes from " + fileName);
        int[] index = new int[]{-1, -1};
        int n = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != 13 || content[i + 1] != 10) continue;
            index[n++] = i;
            if (n == 2) break;
        }
        if (index[1] == -1) {
            throw new UnrecoverableKeyException("No HMAC present.");
        }
        byte[] currTkId = new byte[index[0] - 0 - 1];
        byte[] currhMac = new byte[index[1] - index[0] - 3];
        logger.debug("currtkid:" + new String(currTkId, "ISO8859_1"));
        System.arraycopy(content, 1, currTkId, 0, currTkId.length);
        logger.debug("currtkid:" + new String(currTkId, "ISO8859_1"));
        System.arraycopy(content, index[0] + 3, currhMac, 0, currhMac.length);
        logger.debug("currhmac:" + new String(currhMac, "ISO8859_1"));
        if (this.loadhMac != null) {
            logger.debug("loadhmac:" + new String(this.loadhMac, "ISO8859_1"));
        }
        if (!andcheck) {
            return currTkId;
        }
        if (!Arrays.areEqual((byte[])currhMac, (byte[])this.loadhMac)) {
            throw new IniFileException("Different token password present", 2);
        }
        return this.loadTkId;
    }

    private byte[] computeHMACBase64(byte[] data, byte[] pin) throws UnrecoverableKeyException {
        try {
            Mac sha_HMAC = Mac.getInstance("HMac-SHA1", ProvUtils.bcProvider);
            sha_HMAC.init(new SecretKeySpec(pin, "HMac-SHA1"));
            byte[] result = sha_HMAC.doFinal(data);
            return Util.base64Encode(result);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new SecurityException("Algorithm not specified: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new UnrecoverableKeyException("The password is wrong.");
        }
    }

    public int size() {
        return this.table.size();
    }

    public byte[] getLoadTkId() {
        return this.loadTkId;
    }

    public void setLoadTkId(byte[] loadTkId) {
        this.loadTkId = loadTkId;
    }
}

