/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.parser.CounterSignedXMLEnvelope;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.crypto.dsig.Reference;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class XadesParserHelper {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    private static SignatureInformation checkDuplicateSigner(TransientDocument doc, byte[] signerInfo) {
        for (SignatureInformation info : doc.getSignerInfo()) {
            if (!Arrays.areEqual((byte[])info.getSignatureInfo(), (byte[])signerInfo)) continue;
            return info;
        }
        return null;
    }

    public static void parseXadesEnvelope(TransientDocument doc, SignedXMLEnvelope env, DateFormat df, boolean checkDuplicated, boolean hashValid, EventHandlerSelector fileSelector, NetworkConfig config) throws Exception {
        String[] signers = env.listSigners();
        if (signers != null && signers.length > 0) {
            doc.setSigned(true);
            for (int iSig = 0; iSig < signers.length; ++iSig) {
                Certificate ellipsCert;
                RefCertificate refCert;
                String id;
                LinkedList<X509Certificate> certs;
                SignatureInformation info = null;
                if (!env.isSignatureParsed(iSig)) {
                    info = new SignatureInformation();
                    info.setSignatureInfo(env.getRawSignature(iSig));
                    info.setFormat(SignatureFormat.XADES);
                    info.setContainerFormat(ContainerFormat.SELF);
                    info.setCorrupted(true);
                    certs = env.getCertificates(iSig);
                    if (certs != null) {
                        for (X509Certificate cert : certs) {
                            id = Utils.calculateDigest(new ByteArrayInputStream(cert.getEncoded()), Constants.SHA256);
                            refCert = new RefCertificate();
                            refCert.setId(id);
                            refCert.setContent(cert.getEncoded());
                            refCert.setCapiCertificate(new Certificate(cert));
                            doc.addCert(refCert);
                        }
                        ellipsCert = new Certificate(Base64.decode((String)env.getSignerCertificate(iSig)));
                        info.setSignerName(ellipsCert.getName());
                        String refsCertId = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)env.getSignerCertificate(iSig))), Constants.SHA256);
                        info.setRefsCertId(refsCertId);
                    } else {
                        info.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    doc.addSignerInfo(info);
                    continue;
                }
                if (checkDuplicated) {
                    info = XadesParserHelper.checkDuplicateSigner(doc, env.getRawSignature(iSig));
                }
                if (info == null) {
                    info = new SignatureInformation();
                    certs = env.getCertificates(iSig);
                    if (certs != null) {
                        for (X509Certificate cert : certs) {
                            id = Utils.calculateDigest(new ByteArrayInputStream(cert.getEncoded()), Constants.SHA256);
                            refCert = new RefCertificate();
                            refCert.setId(id);
                            refCert.setContent(cert.getEncoded());
                            refCert.setCapiCertificate(new Certificate(cert));
                            doc.addCert(refCert);
                        }
                        ellipsCert = new Certificate(Base64.decode((String)env.getSignerCertificate(iSig)));
                        info.setSignerName(ellipsCert.getName());
                        String refsCertId = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)env.getSignerCertificate(iSig))), Constants.SHA256);
                        info.setRefsCertId(refsCertId);
                    } else {
                        info.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    info.setSignatureInfo(env.getRawSignature(iSig));
                    info.setFormat(SignatureFormat.XADES);
                    info.setContainerFormat(ContainerFormat.SELF);
                    info.setContainsGraphometricInfo(false);
                    for (int iRef = 0; iRef < env.getNumReference(iSig); ++iRef) {
                        Reference ref = env.getReferenceInfo(iSig, iRef);
                        StreamInputHandler sih = new StreamInputHandler(ref.getDigestInputStream(), ref.getURI());
                        TransientDocument refDoc = ParserUtils.parseDoc(sih, fileSelector, config);
                        doc.addRefDoc(refDoc);
                        info.addRefDoc(new ReferenceDoc(refDoc.getId(), hashValid));
                    }
                    if (env.getSigningTime(iSig) != null) {
                        try {
                            Date sigDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(env.getSigningTime(iSig));
                            info.setSignatureDate(df.format(sigDate));
                        }
                        catch (ParseException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    try {
                        env.verify(iSig);
                        info.setCorrupted(false);
                    }
                    catch (Exception e) {
                        info.setCorrupted(true);
                    }
                    doc.addSignerInfo(info);
                    CounterSignedXMLEnvelope csenv = null;
                    try {
                        csenv = env.getCounterSignature(iSig);
                        csenv.listSigners();
                    }
                    catch (CapiException ex) {
                        csenv = null;
                    }
                    if (csenv != null && csenv.listSigners() != null && csenv.listSigners().length > 0) {
                        XadesParserHelper.parseCounterSigner(doc, csenv, info, df);
                    }
                    int numTimeStamps = env.getNumSignatureTimeStamp(iSig);
                    for (int j = 0; j < numTimeStamps; ++j) {
                        try {
                            byte[] tstByte = env.getTimeStamp(iSig, j);
                            byte[] signByte = env.getSignature(iSig);
                            if (tstByte == null) continue;
                            InputHandler signatureInputHandler = DataHandlerBuilder.get().setBytes(signByte).buildInput();
                            info.addTimeStampToken(TSTUtils.tstToVol(doc, tstByte, signatureInputHandler, "", df));
                            continue;
                        }
                        catch (CapiException tstByte) {
                            // empty catch block
                        }
                    }
                    for (RefCertificate rcert : doc.getCerts()) {
                        if (certs.contains(rcert.getCapiCertificate().getInternalCert())) continue;
                        certs.add(rcert.getCapiCertificate().getInternalCert());
                    }
                    if (env.getCRLS(iSig) != null) {
                        for (CRL crl : env.getCRLS(iSig)) {
                            CRLUtils.addRefCrl(doc.getCrls(), crl, certs);
                        }
                    }
                    if (env.getBasicOCSPResponses(iSig) == null) continue;
                    for (BasicOCSPResp ocsp : env.getBasicOCSPResponses(iSig)) {
                        String id2 = Utils.calculateDigest(new ByteArrayInputStream(ocsp.getEncoded()), Constants.SHA256);
                        RefOcsp refOcsp = new RefOcsp();
                        refOcsp.setId(id2);
                        refOcsp.setContent(ocsp.getEncoded());
                        doc.addOcspresp(refOcsp);
                    }
                    continue;
                }
                for (int iRef = 0; iRef < env.getNumReference(iSig); ++iRef) {
                    Reference ref = env.getReferenceInfo(iSig, iRef);
                    StreamInputHandler sih = new StreamInputHandler(ref.getDigestInputStream(), ref.getURI());
                    TransientDocument refDoc = ParserUtils.parseDoc(sih, fileSelector, config);
                    doc.addRefDoc(refDoc);
                    info.addRefDoc(new ReferenceDoc(refDoc.getId(), hashValid));
                }
            }
        }
    }

    private static void parseCounterSigner(TransientDocument doc, CounterSignedXMLEnvelope env, SignatureInformation info, DateFormat df) throws CapiException, CMSException, IOException, NoSuchAlgorithmException, FileNotFoundException, MalformedURLException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, URISyntaxException, Exception {
        String[] signers = env.listSigners();
        if (signers != null && signers.length > 0) {
            SignatureInformation newInfo = new SignatureInformation();
            for (int i = 0; i < signers.length; ++i) {
                LinkedList<X509Certificate> certs = env.getCertificates(i);
                if (certs != null) {
                    for (X509Certificate cert : certs) {
                        String id = Utils.calculateDigest(new ByteArrayInputStream(cert.getEncoded()), Constants.SHA256);
                        RefCertificate refCert = new RefCertificate();
                        refCert.setId(id);
                        refCert.setContent(cert.getEncoded());
                        refCert.setCapiCertificate(new Certificate(cert));
                        doc.addCert(refCert);
                    }
                    Certificate ellipsCert = new Certificate(Base64.decode((String)env.getSignerCertificate(i)));
                    newInfo.setSignerName(ellipsCert.getName());
                } else {
                    newInfo.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                }
                newInfo.setSignatureInfo(env.getRawSignature(i));
                newInfo.setCounterSignature(true);
                newInfo.setFormat(SignatureFormat.XADES);
                newInfo.setContainerFormat(ContainerFormat.SELF);
                newInfo.setContainsGraphometricInfo(false);
                if (env.getSigningTime(i) != null) {
                    try {
                        Date sigDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(env.getSigningTime(i));
                        newInfo.setSignatureDate(df.format(sigDate));
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                String refsCertId = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)env.getSignerCertificate(i))), Constants.SHA256);
                newInfo.setRefsCertId(refsCertId);
                try {
                    env.verify(i);
                    newInfo.setCorrupted(false);
                }
                catch (Exception e) {
                    newInfo.setCorrupted(true);
                }
                info.addCounterSignaturesInformation(newInfo);
                CounterSignedXMLEnvelope csenv = null;
                try {
                    csenv = env.getCounterSignature(i);
                    csenv.listSigners();
                }
                catch (CapiException ex) {
                    csenv = null;
                }
                if (csenv != null && csenv.listSigners().length > 0) {
                    XadesParserHelper.parseCounterSigner(doc, csenv, newInfo, df);
                }
                int numTimeStamps = env.getNumSignatureTimeStamp(i);
                for (int j = 0; j < numTimeStamps; ++j) {
                    byte[] tstByte = env.getTimeStamp(i, j);
                    if (tstByte == null) continue;
                    byte[] signByte = env.getSignature(i);
                    InputHandler signatureInputHandler = DataHandlerBuilder.get().setBytes(signByte).buildInput();
                    newInfo.addTimeStampToken(TSTUtils.tstToVol(doc, tstByte, signatureInputHandler, "", df));
                }
                for (RefCertificate rcert : doc.getCerts()) {
                    if (certs.contains(rcert.getCapiCertificate().getInternalCert())) continue;
                    certs.add(rcert.getCapiCertificate().getInternalCert());
                }
                if (env.getCRLS(i) != null) {
                    for (CRL crl : env.getCRLS(i)) {
                        CRLUtils.addRefCrl(doc.getCrls(), crl, certs);
                    }
                }
                if (env.getBasicOCSPResponses(i) == null) continue;
                for (BasicOCSPResp ocsp : env.getBasicOCSPResponses(i)) {
                    String id = Utils.calculateDigest(new ByteArrayInputStream(ocsp.getEncoded()), Constants.SHA256);
                    RefOcsp refOcsp = new RefOcsp();
                    refOcsp.setId(id);
                    refOcsp.setContent(ocsp.getEncoded());
                    doc.addOcspresp(refOcsp);
                }
            }
        }
    }
}

