/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.utils;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.Provider;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.slf4j.Logger;

public class XMLUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static XMLSignatureFactory getXMLSignatureFactoryInstance() {
        XMLSignatureFactory fac = null;
        String useJSR105ProviderClass = System.getProperty("useJSR105ProviderClass");
        if (useJSR105ProviderClass != null) {
            try {
                Provider prov = (Provider)Class.forName(useJSR105ProviderClass).newInstance();
                fac = XMLSignatureFactory.getInstance("DOM", prov);
            }
            catch (ClassNotFoundException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (InstantiationException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (Error e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (fac == null) {
            fac = XMLSignatureFactory.getInstance("DOM");
        }
        return fac;
    }
}

