/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.util;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.File;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class TmpFileUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static LinkedHashSet<String> files = new LinkedHashSet();
    private static LinkedHashSet<String> directories = new LinkedHashSet();
    private static ScheduledExecutorService scheduler = null;

    public static synchronized void enableTmpFileMonitoring() {
        if (scheduler == null) {
            scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        File file;
                        for (String fileName : files) {
                            file = new File(fileName);
                            if (!file.exists()) {
                                files.remove(fileName);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Rimasto File Temporaneo --> {}", (Object)fileName);
                        }
                        for (String directory : directories) {
                            file = new File(directory);
                            if (!file.exists()) {
                                files.remove(directory);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Rimasta Directory Temporanea --> {}", (Object)directory);
                        }
                        if (files.size() > 0) {
                            logger.info("Rimasti File Temporanei !!! --> {}", (Object)files.size());
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Nessun File Temporaneo da cancellare");
                        }
                    }
                    catch (Throwable th) {
                        logger.error("Errore Scheduler File Temporanei !!!", th);
                    }
                }
            }, 0L, 10L, TimeUnit.MINUTES);
        }
    }

    public static synchronized void disableTmpFileMonitoring(boolean deleteTmpFiles) {
        if (scheduler != null) {
            scheduler.shutdown();
            scheduler = null;
            if (deleteTmpFiles) {
                TmpFileUtils.runHooks();
            }
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return TmpFileUtils.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, java.io.File directory) throws IOException {
        if (directory == null) {
            directory = new java.io.File(System.getProperty("java.io.tmpdir"));
        }
        java.io.File file = java.io.File.createTempFile(prefix, suffix, directory);
        files.add(file.getAbsolutePath());
        File objRet = new File(file.getAbsolutePath());
        return objRet;
    }

    public static File createTempDirectory(String prefix, java.io.File directory) throws IOException {
        if (directory == null) {
            directory = new java.io.File(System.getProperty("java.io.tmpdir"));
        }
        Path tmpDir = Files.createTempDirectory(directory.toPath(), prefix, new FileAttribute[0]);
        directories.add(tmpDir.toString());
        File objRet = new File(tmpDir.toString());
        return objRet;
    }

    static void removeFile(java.io.File file) {
        files.remove(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<TmpFileUtils> clazz = TmpFileUtils.class;
        synchronized (TmpFileUtils.class) {
            ArrayList<String> toBeDeleted;
            LinkedHashSet<String> theFiles = files;
            files = null;
            LinkedHashSet<String> theDirectories = directories;
            directories = null;
            // ** MonitorExit[var2] (shouldn't be in output)
            if (theFiles != null) {
                toBeDeleted = new ArrayList<String>(theFiles);
                Collections.reverse(toBeDeleted);
                for (String filename : toBeDeleted) {
                    try {
                        Files.delete(new java.io.File(filename).toPath());
                    }
                    catch (IOException ex) {
                        logger.debug("runHooks not deleted --> {}", (Object)filename);
                        logger.debug("cause --> {}", (Object)ex.getMessage());
                    }
                }
            }
            if (theDirectories != null) {
                toBeDeleted = new ArrayList<String>(theDirectories);
                Collections.reverse(toBeDeleted);
                for (String filename : toBeDeleted) {
                    if (FileUtils.emptyDir(new java.io.File(filename), true)) continue;
                    logger.debug("runHooks not deleted --> {}", (Object)filename);
                }
            }
            logger.debug("runHooks ended");
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                TmpFileUtils.runHooks();
                if (scheduler != null) {
                    scheduler.shutdown();
                }
            }
        }));
    }
}

