/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.SignedData;

public class CadesStepSignatureETSICMSSignedDataCheck
extends SingleValidationSubStepImpl {
    public CadesStepSignatureETSICMSSignedDataCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if (param.getProfile() != null && param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) {
            if (validationDate.before(Constants.DPCM_CNIPA_45_2009)) {
                return null;
            }
            if (param.getSignature() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
            if (param.getSignature().getSignerInfoData() == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
            if (param.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null) {
                ASN1Set atab = param.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
                boolean haveMessageDigest = false;
                boolean haveContentType = false;
                boolean haveSigningCertificate = false;
                boolean haveSigningCertificateV2 = false;
                boolean haveSigningTime = false;
                for (int i = 0; i < atab.size(); ++i) {
                    String id = null;
                    id = atab.getObjectAt(i) instanceof DERSequence ? ((DERSequence)atab.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)atab.getObjectAt(i)).getObjectAt(0).toString();
                    if (id.equals(CMSAttributes.messageDigest.getId())) {
                        haveMessageDigest = true;
                    }
                    if (id.equals(CMSAttributes.contentType.getId())) {
                        haveContentType = true;
                    }
                    if (id.equals(SignedData.id_aa_signingCertificate.getId())) {
                        haveSigningCertificate = true;
                    }
                    if (id.equals(SignedData.id_aa_signingCertificateV2.getId())) {
                        haveSigningCertificateV2 = true;
                    }
                    if (!id.equals(CMSAttributes.signingTime.getId())) continue;
                    haveSigningTime = true;
                }
                if (!haveSigningTime) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]);
                }
                if (!haveSigningCertificate && !haveSigningCertificateV2) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0005_CADES_NOSIGNCERT, new Object[0]);
                }
                if (!haveSigningCertificateV2 && validationDate.before(Constants.DPCM_AGID_121_2019)) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0006_CADES_NOSIGNCERTV2, new Object[0]);
                }
                if (param.getSignature().isCounterSignature() && haveContentType) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0020_COUNTER_SIGNATURE_WITH_CONTENT_TYPE, new Object[0]);
                }
            } else {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0004_CADES_NOSIGNEDATTRS, new Object[0]);
            }
        }
        return null;
    }
}

