/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.EventHandlerSelectorWithMatcher;
import esecurity.validator.parser.utils.FileSignatureMatcher;
import esecurity.validator.parser.utils.ParserUtils;
import it.actalis.ellips.capi.cms.parser.CadesParserHelper;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class CadesParser
extends SignatureParser {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
    private static final Pattern SUB_DOC_PATTERN = Pattern.compile("sub_[0-9]+_");

    public CadesParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector handlerSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        ParsedTransientDocument doc = new ParsedTransientDocument(source);
        if (timeZone != null) {
            this.df.setTimeZone(timeZone);
        }
        OutputHandler oh = null;
        InputHandler ih = null;
        InputHandler handler = null;
        try {
            StreamSignedEnvelope env;
            block13: {
                String id_sub_doc = this.calculateSubDoc(doc.getShortName());
                Matcher m = SUB_DOC_PATTERN.matcher(id_sub_doc);
                if (m.find()) {
                    id_sub_doc = id_sub_doc.substring(m.end());
                }
                oh = DataHandlerBuilder.get().setTemp((File)TmpFileUtils.createTempFile((String)"sub_", (String)("_" + id_sub_doc), (File)tmpFolder)).buildOutput();
                ((TempFileOutputHandler)oh).setDeleteOnClose(false);
                env = null;
                try {
                    env = new StreamSignedEnvelope(source.getInputAsNewStream(), oh.getAsOutputStream());
                }
                catch (CapiException ex) {
                    if (ex.getErrorCode() != 50000 || handlerSelector == null) break block13;
                    try {
                        if (!(handlerSelector instanceof EventHandlerSelectorWithMatcher)) {
                            handler = handlerSelector.selectHandler();
                        } else {
                            final InputHandler sourceFinal = source;
                            StreamSignedEnvelope envelope = new StreamSignedEnvelope(sourceFinal.getInputAsNewStream(), new ByteArrayInputStream("a".getBytes()));
                            final byte[] envDigest = envelope.getMessageDigest(0);
                            final String envDigestAlg = envelope.getSignerDigestAlg(0);
                            handler = ((EventHandlerSelectorWithMatcher)handlerSelector).selectHandler(new FileSignatureMatcher(){

                                public boolean match(InputHandler inputHandler) {
                                    try {
                                        int bytesRead;
                                        MessageDigest digestEngine = MessageDigest.getInstance(envDigestAlg, ProvUtils.bcProvider);
                                        byte[] dataBuffer = new byte[4096];
                                        InputStream stream = inputHandler.getInputAsNewStream();
                                        while ((bytesRead = stream.read(dataBuffer)) >= 0) {
                                            digestEngine.update(dataBuffer, 0, bytesRead);
                                        }
                                        return Arrays.equals(envDigest, digestEngine.digest());
                                    }
                                    catch (Throwable t) {
                                        logger.error(t.getMessage(), t);
                                        return false;
                                    }
                                }

                                public InputHandler getCurrentHandler() {
                                    return sourceFinal;
                                }

                                public byte[] getCurrentHash() {
                                    return envDigest;
                                }
                            }, source.getName());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (handler == null) break block13;
                    env = new StreamSignedEnvelope(source.getInputAsNewStream(), handler.getInputAsNewStream());
                }
            }
            if (env != null) {
                ih = handler != null ? handler : DataHandlerBuilder.get().setTemp(((TempFileOutputHandler)oh).getFile()).buildInput();
                TransientDocument subDoc = ParserUtils.parseDoc((InputHandler)ih, (EventHandlerSelector)handlerSelector, (NetworkConfig)config, (TimeZone)this.df.getTimeZone(), (File)tmpFolder);
                doc.addRefDoc(subDoc);
                CadesParserHelper.parseCadesEnvelope((TransientDocument)doc, subDoc, env, handlerSelector, this.df, false);
            }
        }
        catch (Exception ex) {
            try {
                throw new ParsingException("Unable to parse file", (Throwable)ex);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(oh);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)oh);
        return doc;
    }

    private String calculateSubDoc(String doc) {
        if (doc.lastIndexOf(".") != -1) {
            return doc.substring(0, doc.lastIndexOf("."));
        }
        return doc;
    }
}

