/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.annotations.ParserBuilderOrder;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.cms.parser.CadesParser;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

@ParserBuilderOrder(order=3)
public class CadesParserBuilder
extends SignatureParserBuilder {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public SignatureParser build(InputHandler input) {
        try {
            String object_id = DerParserUtils.retrieveDerID((InputHandler)input, (boolean)false);
            if (object_id == null || !object_id.equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            return new CadesParser(this);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

