/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7.RFC5652;

import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeOutputStream;
import org.slf4j.Logger;

public class CheckSignerInformation {
    private static boolean isSigningTimeCheckedAgainstCert = false;
    private static boolean isSignedAttributesDEREncoded = true;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static boolean verify(SignerInformationVerifier verifier, SignerInformation si, CadesSignedDataProxy dataProxy) throws CMSException {
        X509CertificateHolder dcv;
        if (si == null) {
            return false;
        }
        SignerInfo info = si.toASN1Structure();
        Time signingTime = CheckSignerInformation.getSigningTime(info);
        if (verifier.hasAssociatedCertificate() && signingTime != null && !(dcv = verifier.getAssociatedCertificate()).isValidOn(signingTime.getDate()) && isSigningTimeCheckedAgainstCert) {
            throw new CMSVerifierCertificateNotValidException("verifier not valid at signingTime");
        }
        return CheckSignerInformation.doCustomVerify(verifier, si, dataProxy);
    }

    public static boolean isSigningTimeCheckedAgainstCert() {
        return isSigningTimeCheckedAgainstCert;
    }

    public static void setIsSigningTimeCheckedAgainstCert(boolean isSigningTimeCheckedAgainstCert) {
        CheckSignerInformation.isSigningTimeCheckedAgainstCert = isSigningTimeCheckedAgainstCert;
    }

    public static void setIsSignedAttributesDEREncoded(boolean isSignedAttributesDEREncoded) {
        CheckSignerInformation.isSignedAttributesDEREncoded = isSignedAttributesDEREncoded;
    }

    private static Time getSigningTime(SignerInfo info) throws CMSException {
        ASN1Primitive validSigningTime = CheckSignerInformation.getSingleValuedSignedAttribute(CMSAttributes.signingTime, "signing-time", info);
        if (validSigningTime == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)validSigningTime);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static boolean doCustomVerify(SignerInformationVerifier verifier, SignerInformation si, CadesSignedDataProxy dataProxy) throws CMSException {
        ASN1Primitive validMessageDigest;
        ContentVerifier contentVerifier;
        ASN1ObjectIdentifier contentType = si.getContentType();
        SignerInfo info = si.toASN1Structure();
        boolean isCounterSignature = contentType == null;
        ASN1Set signedAttributeSet = info.getAuthenticatedAttributes();
        byte[] resultDigest = null;
        CMSProcessable content = null;
        if (!isSignedAttributesDEREncoded && signedAttributeSet != null) {
            byte[] encSigAttr1 = null;
            byte[] encSigAttr2 = null;
            try {
                encSigAttr1 = signedAttributeSet.getEncoded("DER");
                encSigAttr2 = signedAttributeSet.getEncoded();
            }
            catch (IOException ex) {
                throw new CMSException("can't compare two signed attribute's encoding: " + ex.getMessage(), (Exception)ex);
            }
            if (java.util.Arrays.equals(encSigAttr1, encSigAttr2)) {
                return false;
            }
        }
        if (dataProxy != null && dataProxy.getSignedData() != null) {
            content = (CMSProcessable)dataProxy.getSignedData().getSignedContent().getContent();
        } else {
            resultDigest = si.getContentDigest();
        }
        String encName = CMSSignedHelper.INSTANCE.getEncryptionAlgName(si.getEncryptionAlgOID());
        try {
            contentVerifier = verifier.getContentVerifier(new AlgorithmIdentifier(new ASN1ObjectIdentifier(si.getEncryptionAlgOID())), new AlgorithmIdentifier(new ASN1ObjectIdentifier(si.getDigestAlgOID())));
        }
        catch (OperatorCreationException e) {
            throw new CMSException("can't create content verifier: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            OutputStream sigOut = contentVerifier.getOutputStream();
            if (resultDigest == null) {
                DigestCalculator calc = verifier.getDigestCalculator(new AlgorithmIdentifier(new ASN1ObjectIdentifier(si.getDigestAlgOID())));
                if (content != null) {
                    OutputStream digOut = calc.getOutputStream();
                    if (signedAttributeSet == null) {
                        if (contentVerifier instanceof RawContentVerifier) {
                            content.write(digOut);
                        } else {
                            TeeOutputStream cOut = new TeeOutputStream(digOut, sigOut);
                            content.write((OutputStream)cOut);
                            cOut.close();
                        }
                    } else {
                        content.write(digOut);
                        if (isSignedAttributesDEREncoded) {
                            sigOut.write(signedAttributeSet.getEncoded("DER"));
                        } else {
                            sigOut.write(signedAttributeSet.getEncoded());
                        }
                    }
                    digOut.close();
                } else if (signedAttributeSet != null) {
                    if (isSignedAttributesDEREncoded) {
                        sigOut.write(signedAttributeSet.getEncoded("DER"));
                    } else {
                        sigOut.write(signedAttributeSet.getEncoded());
                    }
                } else {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                resultDigest = calc.getDigest();
            } else if (signedAttributeSet == null) {
                if (content != null) {
                    content.write(sigOut);
                }
            } else if (isSignedAttributesDEREncoded) {
                sigOut.write(signedAttributeSet.getEncoded("DER"));
            } else {
                sigOut.write(signedAttributeSet.getEncoded());
            }
            sigOut.close();
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", (Exception)e);
        }
        catch (OperatorCreationException e) {
            throw new CMSException("can't create digest calculator: " + e.getMessage(), (Exception)((Object)e));
        }
        ASN1Primitive validContentType = CheckSignerInformation.getSingleValuedSignedAttribute(CMSAttributes.contentType, "content-type", info);
        if (validContentType == null) {
            if (!isCounterSignature && signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (isCounterSignature) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(validContentType instanceof ASN1ObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            ASN1ObjectIdentifier signedContentType = (ASN1ObjectIdentifier)validContentType;
            if (!signedContentType.equals((ASN1Primitive)contentType)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        AttributeTable signedAttrTable = null;
        if (info.getAuthenticatedAttributes() != null) {
            signedAttrTable = new AttributeTable(info.getAuthenticatedAttributes());
        }
        AttributeTable unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(CMSAttributes.cmsAlgorithmProtect).size() > 0) {
            throw new CMSException("A cmsAlgorithmProtect attribute MUST be a signed attribute");
        }
        if (signedAttrTable != null) {
            ASN1EncodableVector protectionAttributes = signedAttrTable.getAll(CMSAttributes.cmsAlgorithmProtect);
            if (protectionAttributes.size() > 1) {
                throw new CMSException("Only one instance of a cmsAlgorithmProtect attribute can be present");
            }
            if (protectionAttributes.size() > 0) {
                Attribute attr = Attribute.getInstance((Object)protectionAttributes.get(0));
                if (attr.getAttrValues().size() != 1) {
                    throw new CMSException("A cmsAlgorithmProtect attribute MUST contain exactly one value");
                }
                CMSAlgorithmProtection algorithmProtection = CMSAlgorithmProtection.getInstance((Object)attr.getAttributeValues()[0]);
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)algorithmProtection.getDigestAlgorithm(), (AlgorithmIdentifier)info.getDigestAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for digestAlgorithm");
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)algorithmProtection.getSignatureAlgorithm(), (AlgorithmIdentifier)info.getDigestEncryptionAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for signatureAlgorithm");
                }
            }
        }
        if ((validMessageDigest = CheckSignerInformation.getSingleValuedSignedAttribute(CMSAttributes.messageDigest, "message-digest", info)) == null) {
            if (signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(validMessageDigest instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            ASN1OctetString signedMessageDigest = (ASN1OctetString)validMessageDigest;
            if (!Arrays.constantTimeAreEqual((byte[])resultDigest, (byte[])signedMessageDigest.getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if (signedAttrTable != null && signedAttrTable.getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null) {
            ASN1EncodableVector csAttrs = unsignedAttrTable.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < csAttrs.size(); ++i) {
                Attribute csAttr = Attribute.getInstance((Object)csAttrs.get(i));
                if (csAttr.getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            if (signedAttributeSet == null && resultDigest != null && contentVerifier instanceof RawContentVerifier) {
                RawContentVerifier rawVerifier = (RawContentVerifier)contentVerifier;
                if (encName.equals("RSA")) {
                    DigestInfo digInfo = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(si.getDigestAlgOID()), (ASN1Encodable)DERNull.INSTANCE), resultDigest);
                    return rawVerifier.verify(digInfo.getEncoded("DER"), si.getSignature());
                }
                return rawVerifier.verify(resultDigest, si.getSignature());
            }
            return contentVerifier.verify(si.getSignature());
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", (Exception)e);
        }
    }

    public static VerificationResult customVerify(SignerInformationVerifier verifier, SignerInformation si, CadesSignedDataProxy dataProxy) throws CMSException {
        ASN1Primitive validMessageDigest;
        VerificationResult result = new VerificationResult();
        ASN1ObjectIdentifier contentType = si.getContentType();
        SignerInfo info = si.toASN1Structure();
        boolean isCounterSignature = contentType == null;
        ASN1Set signedAttributeSet = info.getAuthenticatedAttributes();
        byte[] resultDigest = null;
        CMSProcessable content = null;
        try {
            X509CertificateHolder dcv;
            Time signingTime = CheckSignerInformation.getSigningTime(info);
            if (verifier.hasAssociatedCertificate() && signingTime != null && !(dcv = verifier.getAssociatedCertificate()).isValidOn(signingTime.getDate())) {
                result.setValidSigningTime(false);
            }
        }
        catch (CMSException cmse) {
            result.setValidSigningTime(false);
            logger.debug(cmse.getMessage(), (Throwable)cmse);
        }
        if (signedAttributeSet != null) {
            byte[] encSigAttr1 = null;
            byte[] encSigAttr2 = null;
            try {
                encSigAttr1 = signedAttributeSet.getEncoded("DER");
                encSigAttr2 = signedAttributeSet.getEncoded();
                if (java.util.Arrays.equals(encSigAttr1, encSigAttr2)) {
                    result.setDerEncodedSignedAttributes(true);
                    isSignedAttributesDEREncoded = true;
                } else {
                    isSignedAttributesDEREncoded = false;
                    result.setDerEncodedSignedAttributes(false);
                }
            }
            catch (IOException ex) {
                isSignedAttributesDEREncoded = false;
                result.setDerEncodedSignedAttributes(false);
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        if (dataProxy != null && dataProxy.getSignedData() != null) {
            content = (CMSProcessable)dataProxy.getSignedData().getSignedContent().getContent();
        } else {
            try {
                resultDigest = si.getContentDigest();
            }
            catch (IllegalStateException ise) {
                if (si instanceof CapiSignerInformation) {
                    content = ((CapiSignerInformation)si).getSignedContent();
                }
                logger.debug(ise.getMessage(), (Throwable)ise);
            }
        }
        String encName = CMSSignedHelper.INSTANCE.getEncryptionAlgName(si.getEncryptionAlgOID());
        ContentVerifier contentVerifier = null;
        try {
            contentVerifier = verifier.getContentVerifier(info.getDigestEncryptionAlgorithm(), info.getDigestAlgorithm());
        }
        catch (OperatorCreationException e) {
            result.setCreateContentVerifier(false);
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (contentVerifier != null) {
            try {
                OutputStream sigOut = contentVerifier.getOutputStream();
                if (resultDigest == null) {
                    DigestCalculator calc = verifier.getDigestCalculator(si.getDigestAlgorithmID());
                    if (content != null) {
                        OutputStream digOut = calc.getOutputStream();
                        if (signedAttributeSet == null) {
                            if (contentVerifier instanceof RawContentVerifier) {
                                content.write(digOut);
                            } else {
                                TeeOutputStream cOut = new TeeOutputStream(digOut, sigOut);
                                content.write((OutputStream)cOut);
                                cOut.close();
                            }
                        } else {
                            content.write(digOut);
                            if (isSignedAttributesDEREncoded) {
                                sigOut.write(signedAttributeSet.getEncoded("DER"));
                            } else {
                                sigOut.write(signedAttributeSet.getEncoded());
                            }
                        }
                        digOut.close();
                    } else if (signedAttributeSet != null) {
                        if (isSignedAttributesDEREncoded) {
                            sigOut.write(signedAttributeSet.getEncoded("DER"));
                        } else {
                            sigOut.write(signedAttributeSet.getEncoded());
                        }
                    } else {
                        result.setDataEncapsulatedInSignature(false);
                    }
                    resultDigest = calc.getDigest();
                } else if (signedAttributeSet == null) {
                    if (content != null) {
                        content.write(sigOut);
                    }
                } else if (isSignedAttributesDEREncoded) {
                    sigOut.write(signedAttributeSet.getEncoded("DER"));
                } else {
                    sigOut.write(signedAttributeSet.getEncoded());
                }
                sigOut.close();
            }
            catch (IOException e) {
                result.setProcessMimeObjectToCreateSignature(false);
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (OperatorCreationException e) {
                result.setCreateDigestCalculator(false);
                logger.debug(e.getMessage(), (Throwable)e);
            }
            ASN1Primitive validContentType = CheckSignerInformation.getSingleValuedSignedAttribute(CMSAttributes.contentType, "content-type", info);
            if (validContentType == null) {
                if (!isCounterSignature && signedAttributeSet != null) {
                    result.setContentTypePresent(false);
                }
            } else if (isCounterSignature) {
                result.setSignedAttributesContainContentType(true);
            } else if (!(validContentType instanceof ASN1ObjectIdentifier)) {
                result.setContentTypeValueOfObjectIdentifier(false);
            } else {
                ASN1ObjectIdentifier signedContentType = (ASN1ObjectIdentifier)validContentType;
                if (!signedContentType.equals((ASN1Primitive)contentType)) {
                    result.setContentTypeMatchEContentType(false);
                }
            }
        }
        AttributeTable signedAttrTable = null;
        if (info.getAuthenticatedAttributes() != null) {
            signedAttrTable = new AttributeTable(info.getAuthenticatedAttributes());
        }
        AttributeTable unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(CMSAttributes.cmsAlgorithmProtect).size() > 0) {
            result.setCmsAlgorithmProtectASignedAttribute(false);
        }
        if (signedAttrTable != null) {
            ASN1EncodableVector protectionAttributes = signedAttrTable.getAll(CMSAttributes.cmsAlgorithmProtect);
            if (protectionAttributes.size() > 1) {
                result.setCmsAlgorithmProtectOnlyOneInstance(false);
            }
            if (protectionAttributes.size() > 0) {
                CMSAlgorithmProtection algorithmProtection;
                Attribute attr = Attribute.getInstance((Object)protectionAttributes.get(0));
                if (attr.getAttrValues().size() != 1) {
                    result.setCmsAlgorithmProtectAttributeContainExactlyOneValue(false);
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)(algorithmProtection = CMSAlgorithmProtection.getInstance((Object)attr.getAttributeValues()[0])).getDigestAlgorithm(), (AlgorithmIdentifier)info.getDigestAlgorithm())) {
                    result.setDigestAlgorithmCMSAlgorithmIdentifierProtectionCheckFailed(true);
                }
                if (!CMSUtils.isEquivalent((AlgorithmIdentifier)algorithmProtection.getSignatureAlgorithm(), (AlgorithmIdentifier)info.getDigestEncryptionAlgorithm())) {
                    result.setSignatureAlgorithmCMSAlgorithmIdentifierProtectionCheckFailed(true);
                }
            }
        }
        if ((validMessageDigest = CheckSignerInformation.getSingleValuedSignedAttribute(CMSAttributes.messageDigest, "message-digest", info)) == null) {
            if (signedAttributeSet != null) {
                result.setMessageDigestSignedAttributeTypePresent(false);
            }
        } else {
            ASN1OctetString signedMessageDigest;
            if (!(validMessageDigest instanceof ASN1OctetString)) {
                result.setMessageDigestValueOfOctetString(false);
            }
            if (!Arrays.constantTimeAreEqual((byte[])resultDigest, (byte[])(signedMessageDigest = (ASN1OctetString)validMessageDigest).getOctets())) {
                result.setMessageDigestMatchCalculatedValue(false);
            }
        }
        if (signedAttrTable != null && signedAttrTable.getAll(CMSAttributes.counterSignature).size() > 0) {
            result.setCounterSignatureASignedAttribute(true);
        }
        unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null) {
            ASN1EncodableVector csAttrs = unsignedAttrTable.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < csAttrs.size(); ++i) {
                Attribute csAttr = Attribute.getInstance((Object)csAttrs.get(i));
                if (csAttr.getAttrValues().size() >= 1) continue;
                result.setCounterSignatureContainAttributeValue(false);
            }
        }
        if (contentVerifier != null) {
            try {
                boolean res = false;
                if (signedAttributeSet == null && resultDigest != null) {
                    if (contentVerifier instanceof RawContentVerifier) {
                        RawContentVerifier rawVerifier = (RawContentVerifier)contentVerifier;
                        if (encName.equals("RSA")) {
                            DigestInfo digInfo = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(si.getDigestAlgOID()), (ASN1Encodable)DERNull.INSTANCE), resultDigest);
                            res = rawVerifier.verify(digInfo.getEncoded("DER"), si.getSignature());
                        } else {
                            res = rawVerifier.verify(resultDigest, si.getSignature());
                        }
                    }
                } else {
                    res = contentVerifier.verify(si.getSignature());
                }
                result.setSignatureVerified(res);
            }
            catch (IOException e) {
                result.setProcessMimeObjectToCreateSignature(false);
                result.setSignatureVerified(false);
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private static ASN1Primitive getSingleValuedSignedAttribute(ASN1ObjectIdentifier attrOID, String printableName, SignerInfo info) throws CMSException {
        AttributeTable unsignedAttrTable = null;
        if (info.getUnauthenticatedAttributes() != null) {
            unsignedAttrTable = new AttributeTable(info.getUnauthenticatedAttributes());
        }
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(attrOID).size() > 0) {
            throw new CMSException("The " + printableName + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable signedAttrTable = null;
        if (info.getAuthenticatedAttributes() != null) {
            signedAttrTable = new AttributeTable(info.getAuthenticatedAttributes());
        }
        if (signedAttrTable == null) {
            return null;
        }
        ASN1EncodableVector v = signedAttrTable.getAll(attrOID);
        switch (v.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute t = (Attribute)v.get(0);
                ASN1Set attrValues = t.getAttrValues();
                if (attrValues.size() != 1) {
                    throw new CMSException("A " + printableName + " attribute MUST have a single attribute value");
                }
                return attrValues.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + printableName + " attribute");
    }
}

