/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card.athena;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.athena.AthenaConstants;
import it.arubapec.ca.pkcs11.card.athena.AthenaFsStrategyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class AthenaDsFsGenerator {
    private NativePKCS11Slot a;
    private AthenaFsStrategyParameters b;
    private static final Logger c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public AthenaDsFsGenerator(NativePKCS11 nativePKCS11, NativePKCS11Slot nativePKCS11Slot, AthenaFsStrategyParameters athenaFsStrategyParameters) {
        this.a = nativePKCS11Slot;
        this.b = athenaFsStrategyParameters;
    }

    public void generateDsFs() throws CapiException {
        c.info("Inizio Procedura di creazione FileSystem di Firma Athena");
        Object object = new String(this.a.getInfo().description());
        object = ((String)object).replaceFirst("\\s++$", "");
        c.debug("Individuato Lettore :{}", object);
        c.debug("Inizialiazzazione policy pin");
        this.a.setPinRules();
        c.debug("Inizialiazzazione policy pin avvenuta con successo");
        c.debug("Inizio Control CONTROL_GET_DFDS_SM_ENCRYPTED_KEYS");
        Object object2 = new byte[128];
        this.a.control(AthenaConstants.f, (byte[])object2, 128L);
        c.debug("Control CONTROL_GET_DFDS_SM_ENCRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])object2));
        object2 = Hex.toHexString((byte[])this.b.getClient().serverReq("DF-DS", "D", (byte[])object2));
        byte[] byArray = object2;
        object2 = byArray.substring(byArray.length() / 2) + object2.substring(0, object2.length() / 2);
        c.debug("Risultanto inversione Byte {}", object2);
        object2 = Hex.decode((String)object2);
        c.debug("Inizio Control CONTROL_SET_DFDS_SM_DECRYPTED_KEYS");
        this.a.control(AthenaConstants.g, (byte[])object2, ((byte[])object2).length);
        c.debug("Control CONTROL_SET_DFDS_SM_DECRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])object2));
        c.debug("Inizio Control2 CONTROL_GET_CHALLENGE");
        object2 = new byte[16];
        this.a.control2((String)object, AthenaConstants.e, (byte[])object2, 16L);
        c.debug("Control2 CONTROL_GET_CHALLENGE Terminato con successo {}", (Object)Hex.toHexString((byte[])object2));
        c.debug("Send Challenge to Admin Server");
        object2 = this.b.getClient().serverReq("DF-DS", "A", (byte[])object2);
        c.debug("Admin Server Return Signed Challenge {}", (Object)Hex.toHexString((byte[])object2));
        c.debug("Inizio Control2 CONTROL_EXTERNAL_AUTHENTICATE_DFDS");
        this.a.control2((String)object, AthenaConstants.a, (byte[])object2, ((byte[])object2).length);
        c.debug("Control2 CONTROL_EXTERNAL_AUTHENTICATE_DFDS Terminato con successo");
        object = "";
        for (int i = 0; i < 32; ++i) {
            object = (String)object + " ";
        }
        c.debug("Inizio Init Token");
        this.a.initToken(this.b.getPuk(), (String)object);
        c.debug("Init Token terminata con successo");
        c.debug("Inizio Open Session");
        PKCS11Session pKCS11Session = this.a.openSession(6, null, null);
        c.debug("Inizio Login");
        pKCS11Session.login(true, this.b.getPuk());
        pKCS11Session.initPIN(this.b.getPin());
        c.debug("Impostato PIN CNS");
        ((NativePKCS11Session)pKCS11Session).initPIN4(null, this.b.getPuk(), (byte)4, (byte)0);
        c.debug("InitPIN4 Impostato PUK di FIRMA");
        ((NativePKCS11Session)pKCS11Session).initPIN4(this.b.getPuk(), this.b.getPin(), (byte)3, (byte)0);
        c.debug("InitPIN4 Impostato PIN di FIRMA");
        pKCS11Session.logout();
        pKCS11Session.close();
        c.debug("Chiusa Sessione");
        c.debug("Inizio Control CONTROL_GET_DF2_SM_ENCRYPTED_KEYS");
        object = new byte[128];
        this.a.control(AthenaConstants.b, (byte[])object, 128L);
        c.debug("Control2 CONTROL_GET_DF2_SM_ENCRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])object));
        c.debug("Send CONTROL_GET_DF2_SM_ENCRYPTED_KEYS to Admin Server");
        byte[] byArray2 = this.b.getClient().serverReq("DF2", "D", (byte[])object);
        object = byArray2;
        if (byArray2 != null) {
            try {
                object = Hex.toHexString((byte[])object);
                c.debug("Admin Server Return Decrypted 4142 {}", object);
                Object object3 = object;
                object = ((String)object3).substring(((String)object3).length() / 2) + ((String)object).substring(0, ((String)object).length() / 2);
                object = Hex.decode((String)object);
                c.debug("Inizio Control CONTROL_SET_DF2_SM_DECRYPTED_KEYS");
                Object object4 = object;
                this.a.control(AthenaConstants.c, (byte[])object4, ((Object)object4).length);
                c.debug("Control2 CONTROL_SET_DF2_SM_DECRYPTED_KEYS Terminato con successo {}", (Object)Hex.toHexString((byte[])object));
                byte[] byArray3 = new byte[2];
                object = byArray3;
                byArray3[0] = -17;
                object[1] = 21;
                c.debug("Inizio Control CONTROL_UPDATE_DF2_EF_AVAIL_MEMORY");
                this.a.control(AthenaConstants.d, (byte[])object, 2L);
                c.debug("Control2 CONTROL_UPDATE_DF2_EF_AVAIL_MEMORY Terminato con successo {}", (Object)Hex.toHexString((byte[])object));
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage(), (Throwable)pKCS11Exception);
            }
        } else {
            c.info("Attenzione chiave ");
        }
        c.info("Terminata Procedura di creazione FileSystem di Firma Athena");
    }
}

