/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;

public abstract class TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String b = null;

    @Deprecated
    public abstract void initializeLib(String[] var1) throws CapiException;

    @Deprecated
    public abstract void initializeLib(String[] var1, boolean var2) throws CapiException;

    public abstract void initializeLib(TokenParameters var1) throws CapiException;

    public abstract void finalizeLib();

    public abstract String[] getLibInfo();

    public abstract String getLibName();

    public abstract boolean isTokenInserted() throws CapiException;

    public abstract String getLabel() throws CapiException;

    public abstract String getSerialNumber() throws CapiException;

    public abstract int getFreeSpace() throws CapiException;

    public abstract void changePIN(String var1, String var2) throws CapiException;

    public abstract void changePUK(String var1, String var2) throws CapiException;

    public abstract int getMaxRSAKeyLength() throws CapiException;

    public abstract int getMinRSAKeyLength() throws CapiException;

    public abstract void unblockPIN(String var1, String var2) throws CapiException;

    public abstract int getMaxPINLen() throws CapiException;

    public abstract int getMinPINLen() throws CapiException;

    public abstract void openSession(boolean var1, String var2) throws CapiException;

    public abstract void openSession(boolean var1, String var2, int var3) throws CapiException;

    public abstract void openSessionAuthPath(boolean var1) throws CapiException;

    public abstract void openPublicSession() throws CapiException;

    public abstract void closeSession() throws CapiException;

    public abstract boolean isSessionOpen() throws CapiException;

    public abstract byte[] getData(String var1) throws CapiException;

    public abstract void setData(String var1, byte[] var2, int var3) throws CapiException;

    public abstract String getCert(String var1) throws CapiException;

    @Deprecated
    public abstract void setCert(String var1, byte[] var2, int var3, boolean var4) throws CapiException;

    public abstract String installCertificate(Certificate var1) throws CapiException;

    public abstract boolean canImport();

    public abstract boolean canExport(String var1);

    public abstract int canUnblock();

    public abstract void genKeyPair(String var1, int var2, int var3, int var4) throws CapiException;

    public abstract void genKeyPair(String var1, KeyAlgo var2, int var3, int var4, int var5) throws CapiException;

    public abstract String impCred(String var1, PrivateKey var2, int var3, int var4) throws CapiException;

    public abstract PrivateKey expCred(String var1) throws CapiException;

    public abstract PublicKey getPublicKey(String var1) throws CapiException;

    public abstract PrivateKey getPrivateKey(String var1) throws CapiException;

    @Deprecated
    public abstract void instCert(String var1, Certificate var2, boolean var3, boolean var4) throws CapiException;

    public abstract int getKeyUsage(String var1, boolean var2) throws CapiException;

    public abstract int getKeyLength(String var1) throws CapiException;

    public abstract byte[] doSign(byte[] var1, String var2, int var3) throws CapiException;

    public abstract byte[] doDecrypt(byte[] var1, String var2, int var3) throws CapiException;

    public abstract String[] listObjects(String var1, byte var2) throws CapiException;

    public abstract void deleteObject(String var1) throws CapiException;

    public abstract byte getObjectType(String var1) throws CapiException;

    public abstract String getObjectID(String var1) throws CapiException;

    public abstract int getObjectSize(String var1) throws CapiException;

    public abstract void renameObject(String var1, String var2, int var3) throws CapiException;

    public abstract void setCert(String var1, Certificate var2, int var3, byte[] var4, boolean var5) throws CapiException;

    public abstract void setCkaId(String var1, String var2, byte[] var3) throws CapiException;

    public abstract boolean exist(String var1) throws CapiException;

    public abstract String generateID(String[] var1);

    public abstract boolean requiredExtendedAuth();

    public abstract SessionCredentials openSessionWithExtendedAuth(boolean var1, String var2, ExtendedCredentials var3) throws CapiException;

    public abstract void resetToken(String var1) throws CapiException;

    public String reqRenew(String string, boolean bl, String string2, int n) throws CapiException {
        if ((this.getObjectType(string) & 4) == 0) {
            throw new CapiException("Alias is not a credential with installed cert", 10025);
        }
        Certificate certificate = new Certificate(Util.getBytes(this.getCert(string)));
        if (bl) {
            this.genKeyPair(string2, this.getKeyUsage(string, false), this.getKeyLength(string), n);
            return this.certReq(string2, certificate.getX500SubjectName());
        }
        return this.certReq(string, certificate.getX500SubjectName());
    }

    @Deprecated
    public abstract CertificationRequest generatePKCS10CertificationRequest(X500Name var1, PublicKey var2, PrivateKey var3) throws Exception;

    @Deprecated
    public abstract String certReq(X500Name var1, PublicKey var2, PrivateKey var3, String var4) throws CapiException;

    @Deprecated
    public abstract String certReq(X500Name var1, PublicKey var2, PrivateKey var3, Provider var4) throws CapiException;

    @Deprecated
    public abstract String certReq(String var1, X500Name var2) throws CapiException;

    public abstract byte[] generateCertificateRequest(KeyType var1, KeyAlgo var2, int var3, String var4, GeneralNames[] var5, String var6) throws CapiException;

    public boolean checkKeyUsage(int n, int n2) {
        a.debug("checkKeyUsage type=" + n + " keyUsage=" + n2);
        switch (n) {
            case 1: {
                return (n2 & 3) > 0;
            }
            case 2: {
                return (n2 & 0x19C) > 0;
            }
        }
        return true;
    }

    public static final void addProvider(Provider provider, int n) throws CapiException {
        a.debug("getting system properties ...");
        try {
            String string = System.getProperty("java.version");
            a.debug("Java version is " + string);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
        }
        a.debug("adding provider ");
        TokenSpi.addProvider(provider, n, null);
    }

    public static final synchronized void addProvider(Provider provider, int n, String string) throws CapiException {
        int n2;
        if (Security.getProvider("SunRsaSign") != null) {
            TokenSpi.removeProvider("SunRsaSign");
        }
        string = provider.getName();
        Provider[] providerArray = Security.getProviders();
        for (n2 = 0; n2 < providerArray.length; ++n2) {
            if (providerArray[n2].getName().compareToIgnoreCase(string) != 0) continue;
            a.debug("found Provider " + string + " at idx " + n2 + ". Comparing to requested position " + n);
            if (n2 > n) continue;
            a.debug("already present Provider name = " + string + " at position " + n);
            return;
        }
        TokenSpi.removeProvider(string);
        a.debug("addingProvider name=" + string);
        n2 = Security.insertProviderAt(provider, n);
        if (n2 < 0 || n2 != n) {
            throw new CapiException("Cannot set JCE provider at position " + n + " result is " + n2, 1003);
        }
    }

    public static final void removeProvider(String string) {
        ProvUtils.removeProvider(string);
    }

    public static KeyPair genSoftKeyPair(KeyAlgo object, int n) throws CapiException {
        a.debug(System.currentTimeMillis() + ":[TokenSpi] genSoftKeyPair bits=" + n);
        try {
            Serializable serializable;
            if (object == KeyAlgo.RSA) {
                object = KeyPairGenerator.getInstance("RSA", ProvUtils.bcProvider);
                serializable = new SecureRandom();
                ((KeyPairGenerator)object).initialize(n, (SecureRandom)serializable);
            } else {
                object = KeyPairGenerator.getInstance("EC", ProvUtils.bcProvider);
                serializable = new SecureRandom();
                ((KeyPairGenerator)object).initialize(n, (SecureRandom)serializable);
            }
            serializable = ((KeyPairGenerator)object).generateKeyPair();
            a.debug(System.currentTimeMillis() + ":[TokenSpi] key pair generated");
            return serializable;
        }
        catch (InvalidParameterException invalidParameterException) {
            a.debug(invalidParameterException.getMessage(), (Throwable)invalidParameterException);
            throw new CapiException("Invalid key length " + n, 10031);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error during key pair generation", 10032);
        }
    }

    public static byte[] toPKCS8(PrivateKey object, String object2) throws CapiException {
        a.debug(System.currentTimeMillis() + ":[TokenSpi] toPKCS8");
        Object object3 = "1.2.840.113549.1.12.1.3";
        Object object4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        object4 = new PBEParameterSpec((byte[])object4, 100);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance((String)object3, ProvUtils.bcProvider);
            algorithmParameters.init((AlgorithmParameterSpec)object4);
            object2 = new PBEKeySpec(((String)object2).toCharArray());
            object4 = SecretKeyFactory.getInstance((String)object3, ProvUtils.bcProvider);
            object3 = Cipher.getInstance((String)object3, ProvUtils.bcProvider);
            ((Cipher)object3).init(3, (Key)((SecretKeyFactory)object4).generateSecret((KeySpec)object2), algorithmParameters);
            object = ((Cipher)object3).wrap((Key)object);
            object = new EncryptedPrivateKeyInfo(algorithmParameters, (byte[])object);
            return ((EncryptedPrivateKeyInfo)object).getEncoded();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException(exception.getMessage(), 1003);
        }
    }

    public static PKCS8EncodedKeySpec fromPKCS8(byte[] object, String object2) throws CapiException {
        Object object3 = "1.2.840.113549.1.12.1.3";
        a.debug(System.currentTimeMillis() + ":[TokenSpi] fromPKCS8");
        try {
            object = new EncryptedPrivateKeyInfo((byte[])object);
            object2 = new PBEKeySpec(((String)object2).toCharArray());
            a.debug("pInfo.getAlgName(): " + ((EncryptedPrivateKeyInfo)object).getAlgName());
            Cipher cipher = Cipher.getInstance(((EncryptedPrivateKeyInfo)object).getAlgName(), ProvUtils.bcProvider);
            object3 = SecretKeyFactory.getInstance((String)object3, ProvUtils.bcProvider);
            object2 = ((SecretKeyFactory)object3).generateSecret((KeySpec)object2);
            cipher.init(2, (Key)object2, ((EncryptedPrivateKeyInfo)object).getAlgParameters());
            object = ((EncryptedPrivateKeyInfo)object).getKeySpec(cipher);
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid encrypted key", 3000);
        }
    }

    public byte[] hash(byte[] byArray) throws CapiException {
        a.debug("calculating hash");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public void initProviders(TokenSpi tokenSpi) throws CapiException {
        a.debug("init security providers");
    }

    public void setId(String string) {
        this.b = string;
    }

    public String getId() {
        return this.b;
    }
}

