/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.tsa;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.tsa.a;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.EventHandlerSelectorWithMatcher;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;

public class TSRParser
extends SignatureParser {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat b = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public TSRParser(SignatureParserBuilder signatureParserBuilder) {
        super(signatureParserBuilder);
        this.b.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    @Override
    public ParsedTransientDocument parse(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone timeZone, File file) throws ParsingException {
        Object object;
        Object object2;
        Closeable closeable;
        ParsedTransientDocument parsedTransientDocument = new ParsedTransientDocument(inputHandler);
        InputHandler inputHandler2 = null;
        try {
            if (!(eventHandlerSelector instanceof EventHandlerSelectorWithMatcher)) {
                inputHandler2 = eventHandlerSelector.selectHandler();
            } else {
                closeable = inputHandler;
                object2 = new TimeStampToken(Util.getBytesFromInputStream(((InputHandler)closeable).getInputAsNewStream()));
                object = ((TimeStampToken)object2).getHashedMessage();
                inputHandler2 = ((EventHandlerSelectorWithMatcher)eventHandlerSelector).selectHandler(new a(this, (TimeStampToken)object2, (InputHandler)closeable, (byte[])object), inputHandler.getName());
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        if (timeZone != null) {
            this.b.setTimeZone(timeZone);
        }
        object2 = null;
        try {
            closeable = ParserUtils.parseDoc(inputHandler2, eventHandlerSelector, networkConfig, this.b.getTimeZone(), file);
            parsedTransientDocument.setSigned(true);
            parsedTransientDocument.addRefDoc((TransientDocument)closeable);
            object2 = ((TransientDocument)closeable).getId();
        }
        catch (Exception exception) {}
        try {
            object = TSTUtils.tstToVol(parsedTransientDocument, Util.getBytesFromInputStream(inputHandler.getInputAsNewStream()), inputHandler2, (String)object2, this.b);
            parsedTransientDocument.addSignerInfo((SignatureInformation)object);
        }
        catch (Exception exception) {
            throw new ParsingException("Unable to parse file", exception);
        }
        return parsedTransientDocument;
    }

    static /* synthetic */ Logger a() {
        return a;
    }
}

