/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.validator.bean.CertStatusValidation;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import esecurity.validator.constants.StatusValidation;
import esecurity.validator.parser.utils.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;

public class LevelValidationUtils {
    public static LevelValidation validateLevel(TimeStampToken timeStampToken, Certificate certificate, LinkedList<Certificate> linkedList, LinkedList<BasicOCSPResp> linkedList2, LinkedList<CRL> object, Logger logger, NetworkConfig networkConfig) {
        LevelValidation levelValidation;
        block9: {
            levelValidation = new LevelValidation();
            levelValidation.setSignerCertificate(certificate);
            if (timeStampToken == null) {
                return levelValidation;
            }
            LinkedList<Certificate> linkedList3 = new LinkedList<Certificate>();
            try {
                Certificate certificate2 = timeStampToken.getTSACert();
                if (certificate2 == null) {
                    return levelValidation;
                }
                if (linkedList != null) {
                    linkedList3.addAll(linkedList);
                }
                linkedList3.add(certificate2);
                LinkedList<RefCRL> linkedList4 = new LinkedList<RefCRL>();
                if (object != null) {
                    object = ((AbstractSequentialList)object).iterator();
                    while (object.hasNext()) {
                        CRL cRL = (CRL)object.next();
                        CRLUtils.addRefCrl(linkedList4, cRL, linkedList3);
                    }
                }
                return LevelValidationUtils.validateLevelByRefCRL(timeStampToken.getDate(), certificate, certificate2, linkedList, linkedList2, linkedList4, logger, networkConfig);
            }
            catch (ApiGeneralException apiGeneralException) {
                if (logger != null) {
                    logger.error("Invalid timestamp: " + apiGeneralException.getMessage());
                }
            }
            catch (CapiException capiException) {
                if (logger == null) break block9;
                logger.error("Invalid timestamp: " + capiException.getMessage());
            }
        }
        return levelValidation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LevelValidation validateLevelByRefCRL(Date date, Certificate certificate, Certificate certificate2, LinkedList<Certificate> linkedList, LinkedList<BasicOCSPResp> linkedList2, LinkedList<RefCRL> linkedList3, Logger logger, NetworkConfig networkConfig) {
        Object object;
        Object object2;
        LevelValidation levelValidation;
        block35: {
            block34: {
                block33: {
                    Object object3;
                    block32: {
                        levelValidation = new LevelValidation();
                        levelValidation.setSignerCertificate(certificate);
                        levelValidation.setChain(linkedList);
                        levelValidation.setOcsps(linkedList2);
                        levelValidation.setCrls(linkedList3);
                        levelValidation.setVerificationDate(date);
                        if (certificate2 != null) {
                            levelValidation.setTsaCertificate(certificate2);
                            levelValidation.setLevel(SignatureLevel.T);
                        }
                        if (linkedList != null) {
                            try {
                                object2 = LevelValidationUtils.a(linkedList, networkConfig);
                                object = null;
                                try {
                                    if (((CertDb)object2).containsCertificate(certificate)) {
                                        ((CertDb)object2).removeServiceItem(certificate);
                                    }
                                    if ((object3 = ((CertDb)object2).retrieveCertificateChain(certificate)) != null && ((CertChain)object3).overAllOk()) {
                                        levelValidation.setSignerChain((CertChain)object3);
                                    }
                                    if (object2 == null) break block32;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        Throwable throwable2 = throwable;
                                        object = throwable;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (object2 == null) throw throwable3;
                                        if (object == null) {
                                            object2.close();
                                            throw throwable3;
                                        }
                                        try {
                                            object2.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            ((Throwable)object).addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                }
                                object2.close();
                            }
                            catch (CapiException | IOException | NullPointerException exception) {
                                if (logger == null) break block32;
                                logger.error("Error verifying signer certificate chain: " + exception.getMessage());
                            }
                        }
                    }
                    if (linkedList != null) {
                        try {
                            object2 = LevelValidationUtils.a(linkedList, networkConfig);
                            object = null;
                            try {
                                if (((CertDb)object2).containsCertificate(certificate2)) {
                                    ((CertDb)object2).removeServiceItem(certificate2);
                                }
                                if ((object3 = ((CertDb)object2).retrieveCertificateChain(certificate2)) != null && ((CertChain)object3).overAllOk()) {
                                    levelValidation.setTsaChain((CertChain)object3);
                                }
                                if (object2 == null) break block33;
                            }
                            catch (Throwable throwable) {
                                try {
                                    object3 = throwable;
                                    object = throwable;
                                    throw object3;
                                }
                                catch (Throwable throwable5) {
                                    if (object2 == null) throw throwable5;
                                    if (object == null) {
                                        object2.close();
                                        throw throwable5;
                                    }
                                    try {
                                        object2.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        ((Throwable)object).addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                            }
                            object2.close();
                        }
                        catch (CapiException | IOException | NullPointerException exception) {
                            if (logger == null) break block33;
                            logger.error("Error verifying TSA certificate chain: " + exception.getMessage());
                        }
                    }
                }
                try {
                    levelValidation.setSignerStatus(LevelValidationUtils.a(date, certificate, linkedList, linkedList2, linkedList3, networkConfig));
                }
                catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException throwable) {
                    if (logger == null) break block34;
                    logger.error("Error checking CRL/OCSP status for signer: " + throwable.getMessage());
                }
            }
            try {
                levelValidation.setTsaSignerStatus(LevelValidationUtils.a(date, certificate2, linkedList, linkedList2, linkedList3, networkConfig));
            }
            catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException throwable) {
                if (logger == null) break block35;
                logger.error("Error checking CRL/OCSP status for TSA: " + throwable.getMessage());
            }
        }
        object2 = levelValidation.getSignerStatus();
        object = levelValidation.getTsaSignerStatus();
        if (object2 == null) return levelValidation;
        if (object == null) return levelValidation;
        boolean bl = ((CertStatusValidation)object2).getValidationType() == StatusValidation.EMBEDDED_CRL || ((CertStatusValidation)object2).getValidationType() == StatusValidation.EMBEDDED_OCSP;
        boolean bl2 = ((CertStatusValidation)object).getValidationType() == StatusValidation.EMBEDDED_CRL || ((CertStatusValidation)object).getValidationType() == StatusValidation.EMBEDDED_OCSP;
        boolean bl3 = levelValidation.getSignerChain() != null && levelValidation.getTsaChain() != null;
        if (bl3) {
            if (!bl) {
                logger.info("Formato non LT: non sono state trovate informazioni di revoca embedded per il signer {}", (Object)certificate.getSubjectDN());
            }
            if (!bl2) {
                logger.info("Formato non LT non sono state trovate informazioni di revoca embedded per la TSA {}", (Object)certificate2.getSubjectDN());
            }
        }
        if (!bl) return levelValidation;
        if (!bl2) return levelValidation;
        if (!bl3) return levelValidation;
        levelValidation.setLevel(SignatureLevel.LT);
        return levelValidation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CertStatusValidation a(Date date, Certificate certificate, LinkedList<Certificate> revokedStatus, LinkedList<BasicOCSPResp> linkedList, LinkedList<RefCRL> object, NetworkConfig networkConfig) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        Object object2;
        CertStatusValidation certStatusValidation = new CertStatusValidation();
        if (certificate == null) {
            return certStatusValidation;
        }
        if (object != null) {
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                object2 = (RefCRL)object.next();
                if (((RefCRL)object2).getNextUpdate().before(date)) continue;
                for (VerifiedSerial verifiedSerial : ((RefCRL)object2).getVerifiedSerial()) {
                    if (!verifiedSerial.getSerial().equals(certificate.getSerialNumber().toString(16))) continue;
                    certStatusValidation.setValidationType(StatusValidation.EMBEDDED_CRL);
                    certStatusValidation.setCrl((RefCRL)object2);
                    if (verifiedSerial.isRevoked() && verifiedSerial.getRevocationDate().before(date)) {
                        certStatusValidation.setReasonCode(verifiedSerial.getReasonCode());
                        certStatusValidation.setRevocationDate(verifiedSerial.getRevocationDate());
                        certStatusValidation.setRevoked(true);
                        break;
                    }
                    certStatusValidation.setRevoked(false);
                    break;
                }
                if (certStatusValidation.getValidationType() == StatusValidation.NONE) continue;
            }
        }
        if (certStatusValidation.getValidationType() != StatusValidation.NONE) {
            return certStatusValidation;
        }
        if (linkedList == null) return certStatusValidation;
        object = LevelValidationUtils.a((List<Certificate>)revokedStatus, networkConfig);
        object2 = null;
        try {
            for (BasicOCSPResp basicOCSPResp : linkedList) {
                if (basicOCSPResp.getProducedAt().before(date) || !certificate.getSerialNumber().equals(basicOCSPResp.getResponses()[0].getCertID().getSerialNumber())) continue;
                RevokedStatus revokedStatus2 = basicOCSPResp.getCerts();
                revokedStatus = revokedStatus2;
                revokedStatus = revokedStatus2;
                int n = ((X509CertificateHolder[])revokedStatus2).length;
                for (int i = 0; i < n; ++i) {
                    CertChain certChain;
                    Object object3 = revokedStatus[i];
                    object3 = new Certificate(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate((X509CertificateHolder)object3));
                    if (((CertDb)object).containsCertificate((Certificate)object3)) {
                        ((CertDb)object).removeServiceItem((Certificate)object3);
                    }
                    if ((certChain = ((CertDb)object).retrieveCertificateChain((Certificate)object3)) != null && certChain.getStartEntry().getParent() != null && basicOCSPResp.getResponses()[0].getCertID().matchesIssuer(new X509CertificateHolder(certChain.getStartEntry().getParent().getCert().getInternalCert().getEncoded()), new JcaDigestCalculatorProviderBuilder().build())) {
                        certChain = new JcaContentVerifierProviderBuilder();
                        certChain.setProvider(ProvUtils.bcProvider);
                        if (basicOCSPResp.isSignatureValid(certChain.build(((Certificate)object3).getPublicKey()))) {
                            certStatusValidation.setValidationType(StatusValidation.EMBEDDED_OCSP);
                            certStatusValidation.setOcsp(basicOCSPResp);
                            revokedStatus = (RevokedStatus)basicOCSPResp.getResponses()[0].getCertStatus();
                            if (revokedStatus != null && revokedStatus.getRevocationTime().before(date)) {
                                certStatusValidation.setRevocationDate(revokedStatus.getRevocationTime());
                                certStatusValidation.setReasonCode(revokedStatus.getRevocationReason());
                                certStatusValidation.setRevoked(true);
                                break;
                            }
                            certStatusValidation.setRevoked(false);
                            break;
                        }
                    }
                    if (certStatusValidation.getValidationType() != StatusValidation.NONE) break;
                }
                if (certStatusValidation.getValidationType() == StatusValidation.NONE) continue;
            }
            if (object == null) return certStatusValidation;
        }
        catch (Throwable throwable) {
            try {
                Iterator iterator = throwable;
                object2 = throwable;
                throw iterator;
            }
            catch (Throwable throwable2) {
                if (object == null) throw throwable2;
                if (object2 != null) {
                    try {
                        object.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object2).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    object.close();
                }
                throw throwable2;
            }
        }
        object.close();
        return certStatusValidation;
    }

    private static CertDb a(List<Certificate> object, NetworkConfig object2) throws CapiException, IOException {
        object2 = CertDbBuilder.get().setNetworkConfig((NetworkConfig)object2).setType(CertDbType.MEMORY).build();
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = (Certificate)object.next();
            int n = LevelValidationUtils.a((Certificate)object3);
            object3 = (n & 3) == 0 ? new X509ServiceDbItem((Certificate)object3, TSLServiceTypeIdentifiers.Fea) : new X509ServiceDbItem((Certificate)object3, TSLServiceTypeIdentifiers.unspecified);
            ((CertDb)object2).importService((ServiceDbItem)object3);
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int a(Certificate certificate) throws CapiException {
        int n;
        boolean bl = certificate.isCritical(X509Extension.keyUsage.getId());
        int n2 = certificate.getKeyUsage();
        boolean bl2 = certificate.isCritical(X509Extension.extendedKeyUsage.getId());
        String[] stringArray = certificate.getExtendedKeyUsage();
        boolean bl3 = false;
        String string = "1.3.6.1.5.5.7.3.4";
        String string2 = "1.3.159.5.1";
        String string3 = "1.2.840.113583.1.1.5";
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equals(stringArray[n])) continue;
            bl3 = true;
            break;
        }
        if (n2 == 0) {
            if (stringArray.length <= 0) return 16;
            for (n = 0; n < stringArray.length; ++n) {
                if (string.equals(stringArray[n]) || string2.equals(stringArray[n]) || string3.equals(stringArray[n])) continue;
                if (!bl2) return 32;
                return 64;
            }
            return 16;
        }
        if ((n2 & 2) > 0) {
            if (n2 == 2 || n2 == 3) {
                if (stringArray.length > 0) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (string.equals(stringArray[n]) || string2.equals(stringArray[n]) || string3.equals(stringArray[n])) continue;
                        if (!bl2) return 32;
                        return 64;
                    }
                    return 2;
                }
                if (n2 != 2) return 2;
                if (!bl) return 2;
                return 1;
            }
            if ((n2 & 0xC) > 0) {
                if (stringArray.length <= 0) return 16;
                for (n = 0; n < stringArray.length; ++n) {
                    if (string.equals(stringArray[n]) || string2.equals(stringArray[n]) || string3.equals(stringArray[n])) continue;
                    if (!bl2) return 32;
                    return 64;
                }
                return 16;
            }
            if (stringArray.length > 0) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (string.equals(stringArray[n]) || string2.equals(stringArray[n]) || string3.equals(stringArray[n])) continue;
                    if (!bl2) return 32;
                    return 64;
                }
                if (!bl) return 32;
                return 64;
            }
            if (!bl) return 32;
            return 64;
        }
        if (certificate.isCNSAuthentication()) {
            return 16;
        }
        if (n2 == 1) {
            return 2;
        }
        if ((n2 & 0xD) > 0) {
            if (n2 == 8 || n2 == 4 || n2 == 12 || n2 == 5) {
                if (stringArray.length <= 0) return 16;
                if (bl3) {
                    if (!bl) return 8;
                    return 4;
                }
                if (!bl2) return 32;
                return 64;
            }
            if ((n2 & 2) > 0) {
                if (stringArray.length <= 0) return 16;
                if (bl3) {
                    return 16;
                }
                if (!bl2) return 32;
                return 64;
            }
            if (stringArray.length > 0) {
                if (bl3) {
                    if (!bl) return 8;
                    return 4;
                }
                if (!bl2) return 32;
                return 64;
            }
            if (!bl) return 8;
            return 4;
        }
        if ((n2 & 0xE) != 0) return 16;
        if (stringArray.length > 0) {
            if (bl3) {
                if (!bl) return 32;
                return 64;
            }
            if (!bl2) return 32;
            return 64;
        }
        if (!bl) return 32;
        return 64;
    }

    public static CertStatusValidation retrieveCertificateStatus(Certificate certificate, LevelValidation levelValidation, NetworkConfig networkConfig) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        return LevelValidationUtils.a(levelValidation.getVerificationDate(), certificate, levelValidation.getChain(), levelValidation.getOcsps(), levelValidation.getCrls(), networkConfig);
    }
}

