/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.KnownP11LibraryInfo;
import it.actalis.ellips.capi.core.KnownSmartcardInfo;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ATRHashtable;
import it.actalis.ellips.util.ATR;
import it.actalis.ellips.util.ATRException;
import it.actalis.ellips.util.java6.PCSC6;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;

public class Token {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static long b = 0L;
    private boolean c = false;
    private String d = null;
    private static Map e = null;
    private static ATRHashtable f = null;
    private static Hashtable g = null;
    private static String h = null;
    private static KnownSmartcardInfo[] i = null;
    private static KnownP11LibraryInfo[] j = null;
    protected static Hashtable tokenTable = new Hashtable();
    private static TokenSpi k = null;
    private static String l = "semaphore for init and destroy";

    public final void init(String string, String[] stringArray, boolean bl) throws CapiException {
        this.c = bl;
        this.init("SoftToken", stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(String string, String[] stringArray) throws CapiException {
        if (string == null) {
            a.debug("Token initialization with null parameters");
            throw new CapiException("Null parameters", 1001);
        }
        if (string.equals("PKCS11Token")) {
            long l;
            a.debug("parsing Token PKCS11...");
            long l2 = 5000L;
            try {
                if (stringArray != null && stringArray.length > 3 && stringArray[3] != null) {
                    l2 = l = Long.parseLong(stringArray[3]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                a.debug(numberFormatException.getMessage(), (Throwable)numberFormatException);
            }
            if (b != 0L) {
                l = System.currentTimeMillis() - b;
                a.debug("elapsed after last destroy: " + l + " ms");
                if (l >= 0L) {
                    if (l2 > l) {
                        l2 -= l;
                        try {
                            a.debug("SLEEP start");
                            Thread.sleep(l2);
                            a.debug("SLEEP stop");
                            a.debug("slept: " + l2 + " ms");
                        }
                        catch (InterruptedException interruptedException) {
                            a.debug(interruptedException.getMessage());
                        }
                    } else {
                        try {
                            a.debug("SLEEP start");
                            Thread.sleep(l2);
                            a.debug("SLEEP stop");
                        }
                        catch (InterruptedException interruptedException) {
                            a.debug(interruptedException.getMessage());
                        }
                    }
                } else {
                    try {
                        a.debug("SLEEP start");
                        Thread.sleep(l2);
                        a.debug("SLEEP stop");
                    }
                    catch (InterruptedException interruptedException) {
                        a.debug(interruptedException.getMessage());
                    }
                }
            } else {
                try {
                    Thread.sleep(l2);
                    a.debug("first time slept: " + l2 + " ms");
                }
                catch (InterruptedException interruptedException) {
                    a.debug(interruptedException.getMessage());
                }
            }
            for (int i = 0; i < 20 && k != null; ++i) {
                try {
                    a.debug("loop " + i + ": waiting tk null for 100ms");
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    a.debug(interruptedException.getMessage());
                }
            }
        }
        String string2 = l;
        synchronized (string2) {
            if (k != null) {
                a.debug("Token already initialized");
                throw new CapiException("Token already initialized", 10002);
            }
            k = TokenHelper.initToken(string, stringArray);
            String string3 = k.getClass().getName() + ":" + k.generateID(stringArray);
            if (tokenTable.containsKey(string3)) {
                a.debug("Token cached with id:" + string3);
                k = (TokenSpi)tokenTable.get(string3);
                a.debug("Token already initialized");
                throw new CapiException("Token already initialized", 10002);
            }
            k.setId(string3);
            a.debug("Token loaded, now initializing...");
            try {
                k.initializeLib(stringArray, this.isTokenSoftSia());
                tokenTable.put(k.getId(), k);
                a.debug("Token initialized");
            }
            catch (CapiException capiException) {
                a.debug("Token NOT initialized");
                a.debug(capiException.getMessage(), (Throwable)capiException);
                k = null;
                throw capiException;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws CapiException {
        String string = l;
        synchronized (string) {
            a.debug("destroy");
            this.d = null;
            if (k != null) {
                tokenTable.remove(k.getId());
                b = System.currentTimeMillis();
                a.debug("finalize starting at TlastDestroyTM: " + b + " ms");
                k.finalizeLib();
                k = null;
                b = System.currentTimeMillis();
                a.debug("finalize ok at TlastDestroyTM: " + b + " ms");
            }
            return;
        }
    }

    public final String[] getInfo() throws CapiException {
        a.debug("getInfo");
        if (k == null) {
            throw new CapiException("Token not initalized", 10003);
        }
        return k.getLibInfo();
    }

    public final void login(String string) throws CapiException {
        a.debug("login");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        k.openSession(false, string);
        a.debug("login OK");
    }

    public final void login(int n, String string) throws CapiException {
        a.debug("slot - login");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        k.openSession(false, string, n);
        a.debug("login OK");
    }

    public final void openPublicSession() throws CapiException {
        a.debug("openPublicSession");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        k.openPublicSession();
        a.debug("openPublicSession OK");
    }

    public final void login() throws CapiException {
        a.debug("login");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        k.openSessionAuthPath(false);
        a.debug("login OK");
    }

    public final void logout() throws CapiException {
        a.debug("logout");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        k.closeSession();
    }

    public final boolean isLogged() throws CapiException {
        a.debug("isLogged");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.isSessionOpen();
    }

    public final boolean isAvailable() throws CapiException {
        a.debug("isAvailable");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.isTokenInserted();
    }

    public final String getLabel() throws CapiException {
        a.debug("getLabel");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getLabel();
    }

    public final String getSerialNumber() throws CapiException {
        a.debug("getSerialNumber");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getSerialNumber();
    }

    public final long getMaxRSAKeyLength() throws CapiException {
        a.debug("getMaxRSAKeyLength");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        long l = k.getMaxRSAKeyLength();
        a.debug("MaxRSAKeyLength is: " + l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changePUK(String string, String string2) throws CapiException {
        a.debug("changePUK");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.changePUK(string, string2);
        }
        a.debug("changePUK OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changePIN(String string, String string2) throws CapiException {
        a.debug("changePIN");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.changePIN(string, string2);
        }
        a.debug("changePIN OK");
    }

    public final byte[] getData(String string) throws CapiException {
        a.debug("getData (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getData(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setData(String string, byte[] byArray, int n) throws CapiException {
        a.debug("setData (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (byArray == null || string == null || string.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.setData(string, byArray, n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
        a.debug("setCkaId (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string2 == null || byArray == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.setCkaId(string, string2, byArray);
            return;
        }
    }

    public final String getCertificate(String string) throws CapiException {
        a.debug("getCertificate (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getCert(string);
    }

    public final void setCertificate(String string, byte[] byArray, int n) throws CapiException {
        this.setCertificate(string, byArray, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCertificate(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        a.debug("setCertificate (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0 || byArray == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.setCert(string, byArray, n, bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setCert(String string, it.actalis.ellips.capi.core.Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
        a.debug("setCertificate (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0 || certificate == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.setCert(string, certificate, n, byArray, bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installCertificate(it.actalis.ellips.capi.core.Certificate certificate) throws CapiException {
        a.debug("installCertificate");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.installCertificate(certificate);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateRSAKeyPair(String string, int n, int n2, int n3) throws CapiException {
        a.debug("generateRSAKeyPair (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n3, 0, 2);
        Token.a("usage", n, 1, 3);
        this.a(n2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            boolean bl;
            int n4 = 0;
            int n5 = 0;
            do {
                CapiException capiException;
                k.genKeyPair(string, n, n2, n3);
                try {
                    RSAPublicKey rSAPublicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(k.getPublicKey(string).getEncoded()));
                    n4 = rSAPublicKey.getModulus().bitLength();
                    if (n4 == n2) {
                        bl = false;
                        a.debug(string + ": keypair length ok (" + n4 + " bit)");
                        continue;
                    }
                    bl = true;
                    a.debug(string + ": keypair length ko (" + n4 + " bit)");
                    try {
                        k.deleteObject(string);
                        a.debug("keypair deleted");
                    }
                    catch (CapiException capiException2) {
                        capiException = capiException2;
                        capiException2.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    a.debug(string + ": keypair invalid");
                    try {
                        k.deleteObject(string);
                        a.debug("keypair deleted");
                    }
                    catch (CapiException capiException3) {
                        capiException = capiException3;
                        capiException3.printStackTrace();
                    }
                }
            } while (bl && ++n5 < 5);
            if (bl) {
                throw new CapiException("keypair length error (" + n4 + " <> " + n2 + ")", 10031);
            }
            return;
        }
    }

    public boolean canImportKeys() throws CapiException {
        a.debug("canImportKeys");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.canImport();
    }

    public boolean canExportKeys(String string) throws CapiException {
        a.debug("canExportKeys (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            return k.canExport(null);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        if ((this.getObjectType(string) & 0xC) == 0) {
            throw new CapiException("Alias is not a credential", 10021);
        }
        a.debug("canExport tk ... calling ");
        return k.canExport(string);
    }

    public final void importPKCS12(String string, byte[] byArray, String string2, int n, int n2, boolean bl) throws CertificateExpiredException, CapiException {
        this.importPKCS12(string, byArray, string2, n, n2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importPKCS12(String string, byte[] object, String string2, int n, int n2, boolean bl, boolean bl2) throws CertificateExpiredException, CapiException {
        int n3;
        String string3;
        KeyStore keyStore;
        a.debug("importPKCS12 (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0 || object == null || string2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        Token.a("usage", n2, 1, 3);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        PrivateKey privateKey = null;
        it.actalis.ellips.capi.core.Certificate certificate = null;
        try {
            a.debug("loading pkcs12 ...");
            keyStore = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            keyStore.load(new ByteArrayInputStream((byte[])object), string2.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            a.debug(keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new CapiException("KeyStoreException", 10035);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.debug(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            throw new CapiException("IllegalArgumentException-Cannot instance PKCS12", 10035);
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException(iOException.getMessage(), 10036);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("NoSuchAlgorithmException", 10035);
        }
        catch (CertificateException certificateException) {
            a.debug(certificateException.getMessage(), (Throwable)certificateException);
            throw new CapiException("CertificateException", 10035);
        }
        catch (ClassCastException classCastException) {
            a.debug(classCastException.getMessage(), (Throwable)classCastException);
            throw new CapiException("Invalid PKCS12", 10035);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        try {
            object = keyStore.aliases();
            a.debug("extracting pkcs12 key ...");
            while (object.hasMoreElements()) {
                Certificate certificate2;
                privateKey = null;
                string3 = (String)object.nextElement();
                if (!keyStore.isKeyEntry(string3) || (privateKey = (PrivateKey)keyStore.getKey(string3, string2.toCharArray())) == null || (certificate2 = keyStore.getCertificate(string3)) == null) continue;
                certificate = new it.actalis.ellips.capi.core.Certificate(certificate2.getEncoded());
                break;
            }
            if (certificate == null) {
                throw new CapiException("PKCS12 Key and Certificate not found", 10035);
            }
            if (certificate.getInternalCert().getKeyUsage() == null || !certificate.getInternalCert().getKeyUsage()[2] && !certificate.getInternalCert().getKeyUsage()[3] && !certificate.getInternalCert().getKeyUsage()[7] && !certificate.getInternalCert().getKeyUsage()[8]) {
                Token.a(certificate);
            }
            n3 = ((RSAKey)((Object)privateKey)).getModulus().bitLength();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        a.debug("pkcs12 key length=" + n3);
        this.a(n3);
        if (bl) {
            a.debug("pkcs12 check key usage");
            if (!k.checkKeyUsage(n2, certificate.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            a.debug("pkcs12 impcred ...");
            string3 = k.impCred(string, privateKey, n2, n);
            a.debug("pkcs12 instcert...");
            try {
                k.instCert(string3, certificate, false, bl2);
                a.debug("pkcs12 instcert ok");
            }
            catch (CapiException capiException) {
                a.debug("install cert KO. Deleting keys for " + string3 + " ...");
                try {
                    k.deleteObject(string3);
                    a.debug("PKCS12 import failed. Keys deleted");
                }
                catch (CapiException capiException2) {
                    a.debug(capiException2.getMessage(), (Throwable)capiException2);
                    a.debug("PKCS12 import failed. Keys left on token.");
                }
                throw capiException;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String certificateRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) throws CapiException {
        Object object;
        a.debug("certificateRequest (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (string2 == null) {
            string2 = "E,D,CN,OU3,OU2,OU1,O,L,ST,C";
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("2.5.4.13");
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        a.debug("parsing orderRDN for subject creation");
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        try {
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().toUpperCase();
                if (string2.equalsIgnoreCase("CN")) {
                    if (string3 == null || string3.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.CN, string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("E")) {
                    if (string11 == null || string11.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.E, string11);
                    continue;
                }
                if (string2.equalsIgnoreCase("D")) {
                    if (string12 == null || string12.trim().equals("")) continue;
                    x500NameBuilder.addRDN(aSN1ObjectIdentifier, string12);
                    continue;
                }
                if (string2.equalsIgnoreCase("O")) {
                    if (string4 == null || string4.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.O, string4);
                    continue;
                }
                if (string2.equalsIgnoreCase("OU1")) {
                    if (string5 == null || string5.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.OU, string5);
                    continue;
                }
                if (string2.equalsIgnoreCase("OU2")) {
                    if (string6 == null || string6.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.OU, string6);
                    continue;
                }
                if (string2.equalsIgnoreCase("OU3")) {
                    if (string7 == null || string7.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.OU, string7);
                    continue;
                }
                if (string2.equalsIgnoreCase("L")) {
                    if (string8 == null || string8.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.L, string8);
                    continue;
                }
                if (string2.equalsIgnoreCase("ST")) {
                    if (string9 == null || string9.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.ST, string9);
                    continue;
                }
                if (string2.equalsIgnoreCase("C")) {
                    if (string10 == null || string10.trim().equals("")) continue;
                    x500NameBuilder.addRDN(BCStyle.C, string10);
                    continue;
                }
                a.debug("unsupported RDN type '" + string2 + "': skipped");
            }
            string2 = x500NameBuilder.build();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        object = k;
        synchronized (object) {
            return k.certReq(string, (X500Name)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final String certificateRequest(String string, Hashtable hashtable) throws CapiException {
        a.debug("certificateRequest (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        a.debug("parsing orderRDN for subject creation");
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)object.nextElement();
            try {
                x500NameBuilder.addRDN(aSN1ObjectIdentifier, (String)hashtable.get(aSN1ObjectIdentifier));
                a.debug("RDN: " + null);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 1003);
            }
        }
        hashtable = x500NameBuilder.build();
        object = k;
        synchronized (object) {
            return k.certReq(string, (X500Name)hashtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] exportPKCS12(String object, String object2) throws CapiException {
        PrivateKey privateKey;
        a.debug("exportPKCS12 (alias= " + (String)object + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (object == null || object2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        Object object3 = k;
        synchronized (object3) {
            privateKey = k.expCred((String)object);
            k.getCert((String)object);
        }
        try {
            object3 = KeyStore.getInstance("PKCS12", ProvUtils.bcProvider);
            ((KeyStore)object3).load(null, null);
            it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate(k.getCert((String)object).getBytes());
            Certificate[] certificateArray = new X509Certificate[1];
            Certificate[] certificateArray2 = certificateArray;
            certificateArray[0] = certificate.getInternalCert();
            ((KeyStore)object3).setKeyEntry((String)object, privateKey, ((String)object2).toCharArray(), certificateArray2);
            object = new ByteArrayOutputStream();
            ((KeyStore)object3).store((OutputStream)object, ((String)object2).toCharArray());
            object2 = ((ByteArrayOutputStream)object).toByteArray();
            ((ByteArrayOutputStream)object).close();
            return object2;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    @Deprecated
    public final void installCertificate(String string, byte[] byArray, boolean bl) throws CertificateExpiredException, CapiException {
        this.installCertificate(string, byArray, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void installCertificate(String string, byte[] object, boolean bl, boolean bl2) throws CertificateExpiredException, CapiException {
        a.debug("installCertificate (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0 || object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate((byte[])object);
        object = certificate;
        Token.a(certificate);
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.instCert(string, (it.actalis.ellips.capi.core.Certificate)object, bl, bl2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String requestRenewal(String string, boolean bl, String string2, int n) throws CapiException {
        a.debug("installCertificate (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        if (string2 == null) {
            string2 = string + "_NEW";
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            return k.reqRenew(string, bl, string2, n);
        }
    }

    public final String[] listObjects(String string, byte by) throws CapiException {
        a.debug("listObjects");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.listObjects(string, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteObject(String string) throws CapiException {
        a.debug("deleteObject (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.deleteObject(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renameObject(String string, String string2, int n) throws CapiException {
        a.debug("renameObject (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            throw new CapiException("Null parameters", 1001);
        }
        if (string.equals(string2)) {
            throw new CapiException("Wrong parameters", 1002);
        }
        Token.a("mode", n, 0, 2);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.renameObject(string, string2, n);
            return;
        }
    }

    public final byte getObjectType(String string) throws CapiException {
        a.debug("getObjectType (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getObjectType(string);
    }

    public final String getObjectID(String string) throws CapiException {
        a.debug("getObjectType (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getObjectID(string);
    }

    public final int getKeyUsage(String string) throws CapiException {
        a.debug("getKeyUsage (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getKeyUsage(string, true);
    }

    public final int getKeyLength(String string) throws CapiException {
        a.debug("getKeyLength (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getKeyLength(string);
    }

    public int getObjectSize(String string) throws CapiException {
        a.debug("getObjectSize (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        return k.getObjectSize(string);
    }

    public long getFreeSpace() throws CapiException {
        a.debug("getFreeSpace");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getFreeSpace();
    }

    public int canUnblock() throws CapiException {
        a.debug("canUnblock");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.canUnblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unblockPIN(String string, String string2) throws CapiException {
        a.debug("UnblockPIN");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        int n = k.canUnblock();
        switch (n) {
            case 0: {
                throw new CapiException("The token cannot be unblocked", 1004);
            }
            case 1: {
                throw new CapiException("The token can be unblocked using the vendor tool but it will be reinitialized", 1004);
            }
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            k.unblockPIN(string, string2);
        }
        a.debug("unblockPIN OK");
    }

    private static byte[] a() {
        a.debug("[getATR6] ...");
        try {
            Object object = new PCSC6();
            byte[] byArray = ((PCSC6)object).getATR();
            object = byArray;
            if (byArray == null || ((Object)object).length == 0) {
                a.debug("[getATR6] No ATR detected.");
                return null;
            }
            String string = Util.dumpHex((byte[])object);
            a.debug("[getATR6]atrValue: " + string);
            return object;
        }
        catch (Exception exception) {
            a.debug("[getATR6] Exception " + exception.getMessage());
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static String[] getPCSCReaders6() throws Exception {
        String[] stringArray = "1.6";
        String[] stringArray2 = System.getProperty("java.version");
        a.debug("[getPCSCReaders6] Java Version: " + (String)stringArray2);
        if (stringArray2.compareTo((String)stringArray) < 0) {
            throw new Exception("Java Version " + (String)stringArray2 + " not support this method");
        }
        try {
            stringArray = Token.class.getClassLoader();
            stringArray = stringArray.loadClass("it.actalis.ellips.util.java6.PCSC6");
            stringArray2 = stringArray.newInstance();
            stringArray = stringArray.getMethod("getPcscReaders", null);
            stringArray = (String[])stringArray.invoke((Object)stringArray2, null);
            if (stringArray == null || stringArray.length == 0) {
                a.debug("[getPCSCReaders6] No reader detected.");
                return null;
            }
            stringArray2 = new String[stringArray.length];
            a.debug("[getPCSCReaders6] N. readers detected: " + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                a.debug("[getPCSCReaders6] Slot n. " + i + " Reader: " + stringArray[i]);
                stringArray2[i] = stringArray[i].trim();
            }
            return stringArray2;
        }
        catch (Exception exception) {
            a.debug("[getPCSCReaders6] Exception " + exception.getMessage());
            a.debug(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    public static final byte[] getATR() {
        String string = System.getProperty("java.version");
        a.debug("[getATR] Java Version: " + string);
        return Token.a();
    }

    protected String getlibNameFromID(String string) {
        try {
            a.debug("finding libName for ID <" + string + ">");
            string = (String)g.get(string);
            if (string == null) {
                a.debug("ID not present");
                return null;
            }
            a.debug("found   position <" + string + ">");
            if (h == null || h.startsWith("Win")) {
                String string2 = Token.c("lib." + string + ".p11lib");
                a.debug("lib." + string + ".p11lib=" + string2);
                return string2;
            }
            String string3 = Token.c("lib." + string + ".p11lib." + h);
            a.debug("lib." + string + ".p11lib." + h + "=" + string3);
            return string3;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public String[] getLibNamesfromSmartcardInfo(KnownSmartcardInfo object) {
        try {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = ((KnownSmartcardInfo)object).getP11LibraryID();
            stringArray2[1] = ((KnownSmartcardInfo)object).getBackupP11LibraryID();
            object = this.getlibNameFromID(stringArray2[0]);
            if (stringArray2[1] == null) {
                stringArray2 = new String[]{object};
                return stringArray2;
            }
            if ((stringArray2 = stringArray2[1].split(";")) == null || stringArray2.length <= 0) {
                String[] stringArray3 = new String[]{object};
                return stringArray3;
            }
            String[] stringArray4 = new String[stringArray2.length + 1];
            String[] stringArray5 = stringArray4;
            stringArray4[0] = object;
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray5[i + 1] = this.getlibNameFromID(stringArray2[i]);
            }
            return stringArray5;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public final void init(KnownSmartcardInfo knownSmartcardInfo) throws CapiException {
        a.debug("init... " + knownSmartcardInfo.getDescription());
        try {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = knownSmartcardInfo.getP11LibraryID();
            stringArray2[1] = knownSmartcardInfo.getBackupP11LibraryID();
            for (int i = 0; i < 2; ++i) {
                if (stringArray2[i] == null) continue;
                if (i == 0) {
                    try {
                        this.b(stringArray2[i]);
                        return;
                    }
                    catch (Exception exception) {
                        a.debug(exception.getMessage(), (Throwable)exception);
                        continue;
                    }
                }
                String[] stringArray3 = stringArray2[i].split(";");
                this.init(stringArray3);
                return;
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        throw new CapiException("No smartcard", 10000);
    }

    public final void init(String[] stringArray) throws CapiException {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                try {
                    a.debug(i + ":" + stringArray[i]);
                    this.b(stringArray[i]);
                    return;
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
        throw new CapiException("No smartcard", 10000);
    }

    public final void init(String[] stringArray, boolean n) throws CapiException {
        if (n == 0) {
            this.init(stringArray);
        } else {
            try {
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n] == null) continue;
                    try {
                        a.debug(n + ":" + stringArray[n]);
                        if (k != null) {
                            this.destroy();
                        }
                        this.b(stringArray[n]);
                        a.info("Carta inserita e verificata - SerialNumber" + this.getSerialNumber());
                        return;
                    }
                    catch (Exception exception) {
                        a.debug(exception.getMessage(), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 1003);
            }
        }
        throw new CapiException("No smartcard", 10000);
    }

    public static final String describeATR(byte[] object) {
        a.debug("describeATR ");
        try {
            object = ATR.toHexString(object).toLowerCase();
            a.debug("finding descr for ATR <" + (String)object + ">");
            String string = (String)f.get((String)object + ".descr");
            if (string == null) {
                a.debug("getMatching ATR <" + (String)object + ">");
                string = (String)f.getMatching((String)object + ".descr");
            }
            a.debug("found description for ATR <" + string + ">");
            return string;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static void registerNewSmartCard(KnownSmartcardInfo[] knownSmartcardInfoArray) {
        try {
            for (int i = 0; i < knownSmartcardInfoArray.length; ++i) {
                int n;
                int n2;
                if (knownSmartcardInfoArray[i].getATR() == null || knownSmartcardInfoArray[i].getDescription() == null || knownSmartcardInfoArray[i].getP11LibraryID() == null) {
                    a.debug("NULL atr or description or P11 for item n. " + i + " ...item skipped...");
                    continue;
                }
                for (n2 = 0; n2 < Token.i.length; ++n2) {
                    if (Token.i[n2].getATR() == null || !knownSmartcardInfoArray[i].getATR().equals(Token.i[n2].getATR())) continue;
                    a.debug("overwriting smart card info in token list...");
                    Token.i[n2].setDescription(knownSmartcardInfoArray[i].getDescription());
                    Token.i[n2].setP11LibraryID(knownSmartcardInfoArray[i].getP11LibraryID());
                    Token.i[n2].setBackupP11LibraryID(knownSmartcardInfoArray[i].getBackupP11LibraryID());
                    a.debug("token ATR = " + knownSmartcardInfoArray[i].getATR());
                    a.debug("token des = " + knownSmartcardInfoArray[i].getDescription());
                    a.debug("token lib = " + knownSmartcardInfoArray[i].getP11LibraryID());
                    if (knownSmartcardInfoArray[i].getBackupP11LibraryID() != null) {
                        a.debug("token bk lib = " + knownSmartcardInfoArray[i].getBackupP11LibraryID());
                    }
                    int n3 = Integer.parseInt((String)e.get("ncards"));
                    for (n = 1; n <= n3; ++n) {
                        String string = (String)e.get("card." + n + ".ATR");
                        if (string == null || !string.equals(knownSmartcardInfoArray[i].getATR())) continue;
                        e.put("card." + n + ".descr", knownSmartcardInfoArray[i].getDescription());
                        e.put("card." + n + ".lib", knownSmartcardInfoArray[i].getP11LibraryID());
                        if (knownSmartcardInfoArray[i].getBackupP11LibraryID() != null) {
                            e.put("card." + n + ".backuplib", knownSmartcardInfoArray[i].getBackupP11LibraryID());
                        }
                        a.debug("updated p11list ");
                        break;
                    }
                    if (!f.containsKey(knownSmartcardInfoArray[i].getATR() + ".lib0")) break;
                    f.put(knownSmartcardInfoArray[i].getATR() + ".lib0", knownSmartcardInfoArray[i].getP11LibraryID());
                    if (knownSmartcardInfoArray[i].getBackupP11LibraryID() != null) {
                        f.put(knownSmartcardInfoArray[i].getATR() + ".lib1", knownSmartcardInfoArray[i].getBackupP11LibraryID());
                    }
                    a.debug("updated atr list... ");
                    break;
                }
                if (n2 != Token.i.length) continue;
                a.debug("adding smart card info to token list...");
                Vector<KnownSmartcardInfo> vector = new Vector<KnownSmartcardInfo>();
                for (n = 0; n < Token.i.length; ++n) {
                    vector.add(Token.i[n]);
                }
                vector.add(new KnownSmartcardInfo(knownSmartcardInfoArray[i].getATR(), knownSmartcardInfoArray[i].getDescription(), knownSmartcardInfoArray[i].getP11LibraryID(), knownSmartcardInfoArray[i].getBackupP11LibraryID()));
                Token.i = new KnownSmartcardInfo[n2 + 1];
                vector.toArray(Token.i);
                a.debug("token ATR = " + knownSmartcardInfoArray[i].getATR());
                a.debug("token des = " + knownSmartcardInfoArray[i].getDescription());
                a.debug("token lib = " + knownSmartcardInfoArray[i].getP11LibraryID());
                if (knownSmartcardInfoArray[i].getBackupP11LibraryID() != null) {
                    a.debug("token bk lib = " + knownSmartcardInfoArray[i].getBackupP11LibraryID());
                }
                n = Integer.parseInt((String)e.get("ncards"));
                e.put("card." + ++n + ".ATR", knownSmartcardInfoArray[i].getATR());
                e.put("card." + n + ".descr", knownSmartcardInfoArray[i].getDescription());
                e.put("card." + n + ".lib", knownSmartcardInfoArray[i].getP11LibraryID());
                e.put("card." + n + ".backuplib", knownSmartcardInfoArray[i].getBackupP11LibraryID());
                e.put("ncards", "" + n);
                a.debug("updated p11list ");
                f.put(knownSmartcardInfoArray[i].getATR() + ".lib0", knownSmartcardInfoArray[i].getP11LibraryID());
                if (knownSmartcardInfoArray[i].getBackupP11LibraryID() != null) {
                    f.put(knownSmartcardInfoArray[i].getATR() + ".lib1", knownSmartcardInfoArray[i].getBackupP11LibraryID());
                }
                a.debug("updated atr list... ");
            }
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public static void registerNewP11Library(KnownP11LibraryInfo[] knownP11LibraryInfoArray) {
        try {
            for (int i = 0; i < knownP11LibraryInfoArray.length; ++i) {
                int n;
                int n2;
                if (knownP11LibraryInfoArray[i].getID() == null || knownP11LibraryInfoArray[i].getDescription() == null || knownP11LibraryInfoArray[i].getp11lib() == null || knownP11LibraryInfoArray[i].getslot() == null || knownP11LibraryInfoArray[i].getflags() == null || knownP11LibraryInfoArray[i].gettimeout() == null) {
                    a.debug("Null param in KnownP11LibraryInfo for item n. " + i + " ...item skipped...");
                    continue;
                }
                for (n2 = 0; n2 < j.length; ++n2) {
                    String string;
                    if (!knownP11LibraryInfoArray[i].getID().equals(j[n2].getID())) continue;
                    a.debug("overwriting p11 info in token list...");
                    j[n2].setDescription(knownP11LibraryInfoArray[i].getDescription());
                    j[n2].setp11lib(knownP11LibraryInfoArray[i].getp11lib());
                    j[n2].setflags(knownP11LibraryInfoArray[i].getflags());
                    j[n2].setslot(knownP11LibraryInfoArray[i].getslot());
                    j[n2].settimeout(knownP11LibraryInfoArray[i].gettimeout());
                    a.debug("P11 ID = " + knownP11LibraryInfoArray[i].getID());
                    a.debug("P11 des = " + knownP11LibraryInfoArray[i].getDescription());
                    a.debug("P11 lib = " + knownP11LibraryInfoArray[i].getp11lib());
                    int n3 = Integer.parseInt((String)e.get("nlibs"));
                    for (n = 1; n <= n3; ++n) {
                        string = (String)e.get("lib." + n + ".ID");
                        if (string == null || !string.equals(knownP11LibraryInfoArray[i].getID())) continue;
                        e.put("lib." + n + ".descr", knownP11LibraryInfoArray[i].getDescription());
                        e.put("lib." + n + ".p11lib", knownP11LibraryInfoArray[i].getp11lib());
                        e.put("lib." + n + ".slot", knownP11LibraryInfoArray[i].getslot());
                        e.put("lib." + n + ".flags", knownP11LibraryInfoArray[i].getflags());
                        e.put("lib." + n + ".timeout", knownP11LibraryInfoArray[i].gettimeout());
                        a.debug("updated p11list ");
                        break;
                    }
                    for (n = 0; n < Token.i.length; ++n) {
                        if (!knownP11LibraryInfoArray[i].getID().equals(Token.i[n].getP11LibraryID()) || !f.containsKey((string = Token.i[n].getATR()) + ".lib0")) continue;
                        f.put(string + ".lib0", knownP11LibraryInfoArray[i].getID());
                        a.debug("updated atr list... " + string + ".lib0: " + knownP11LibraryInfoArray[i].getID());
                    }
                    break;
                }
                if (n2 != j.length) continue;
                a.debug("adding P11 to the list ...");
                Vector<KnownP11LibraryInfo> vector = new Vector<KnownP11LibraryInfo>();
                for (n = 0; n < j.length; ++n) {
                    vector.add(j[n]);
                }
                vector.add(new KnownP11LibraryInfo(knownP11LibraryInfoArray[i].getID(), knownP11LibraryInfoArray[i].getDescription(), knownP11LibraryInfoArray[i].getp11lib(), knownP11LibraryInfoArray[i].getslot(), knownP11LibraryInfoArray[i].getflags(), knownP11LibraryInfoArray[i].gettimeout()));
                j = new KnownP11LibraryInfo[n2 + 1];
                vector.toArray(j);
                a.debug("P11 ID = " + knownP11LibraryInfoArray[i].getID());
                a.debug("P11 des = " + knownP11LibraryInfoArray[i].getDescription());
                a.debug("P11 lib = " + knownP11LibraryInfoArray[i].getp11lib());
                n = Integer.parseInt((String)e.get("nlibs"));
                e.put("lib." + ++n + ".ID", knownP11LibraryInfoArray[i].getID());
                e.put("lib." + n + ".descr", knownP11LibraryInfoArray[i].getDescription());
                e.put("lib." + n + ".p11lib", knownP11LibraryInfoArray[i].getp11lib());
                e.put("lib." + n + ".slot", knownP11LibraryInfoArray[i].getslot());
                e.put("lib." + n + ".flags", knownP11LibraryInfoArray[i].getflags());
                e.put("lib." + n + ".timeout", knownP11LibraryInfoArray[i].gettimeout());
                e.put("nlibs", "" + n);
                g.put(knownP11LibraryInfoArray[i].getID(), "" + n);
                a.debug("updated p11list and id_p11list");
            }
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public final void init(KnownP11LibraryInfo object) throws CapiException {
        a.debug("init... " + ((KnownP11LibraryInfo)object).getDescription());
        try {
            object = ((KnownP11LibraryInfo)object).getID();
            this.b((String)object);
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public final void setSlot(String string) {
        a.debug("setting slot value to: " + string);
        this.d = string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void init() throws ATRException, CapiException {
        Token.a.debug("Token.init() start");
        try {
            block13: {
                var1_1 = Token.getATR();
                v0 = ATR.toHexString((byte[])var1_1).toLowerCase();
                var1_1 = v0;
                if (v0 == null || var1_1.length() == 0) {
                    Token.a.error("No ATR returned");
                    throw new CapiException("No ATR returned", 1003);
                }
                Token.a.debug("finding lib for ATR <" + (String)var1_1 + ">");
                var2_5 = 0;
                block9: while (var2_5 < 2) {
                    block14: {
                        var3_6 /* !! */  = (String[])Token.f.get((String)var1_1 + ".lib" + var2_5);
                        if (var3_6 /* !! */  != null) break block14;
                        Token.a.debug("getMatching ATR <" + (String)var1_1 + ">");
                        var3_6 /* !! */  = (String)Token.f.getMatching((String)var1_1 + ".lib" + var2_5);
                        if (var3_6 /* !! */  == null) ** GOTO lbl26
                        Token.a.debug("found lib for ATR <" + (String)var3_6 /* !! */  + ">");
                    }
                    if (var2_5 != 0) break block13;
                    Token.a.debug(var2_5 + ":" + (String)var1_1 + ":" + (String)var3_6 /* !! */ );
                    try {
                        this.b((String)var3_6 /* !! */ );
                        return;
                    }
                    catch (Exception var3_7) {
                        Token.a.debug(var3_7.getMessage(), (Throwable)var3_7);
lbl26:
                        // 3 sources

                        while (true) {
                            ++var2_5;
                            continue block9;
                            break;
                        }
                    }
                }
                return;
            }
            Token.a.debug(var2_5 + ":" + (String)var1_1 + ":" + (String)var3_6 /* !! */ );
        }
        catch (ATRException var1_2) {
            Token.a.debug(var1_2.getMessage(), (Throwable)var1_2);
            throw var1_2;
        }
        catch (Exception var1_3) {
            Token.a.debug(var1_3.getMessage(), (Throwable)var1_3);
            throw new CapiException("Internal error", 1003);
        }
        var3_6 /* !! */  = var3_6 /* !! */ .split(";");
        this.init(var3_6 /* !! */ );
        ** while (true)
        finally {
            Token.a.debug("Token.init() end");
        }
    }

    public boolean verifyATRMatchTokenConfig() throws CapiException {
        a.debug("verifyATRMatchTokenConfig");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        try {
            if (!this.isAvailable()) {
                throw new CapiException("Token not inserted", 10011);
            }
            Object object = Token.getATR();
            String string = ATR.toHexString((byte[])object);
            object = string;
            if (string == null || ((String)object).length() == 0) {
                return true;
            }
            boolean bl = this.verifyATRMatchTokenConfig((String)object);
            return bl;
        }
        catch (ATRException aTRException) {
            a.debug(aTRException.getMessage(), (Throwable)aTRException);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return true;
    }

    private boolean a(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                try {
                    a.debug(i + ":" + stringArray[i]);
                    if (!Token.a(stringArray[i])) continue;
                    return true;
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    private static boolean a(String string) {
        try {
            String string2;
            a.debug("finding args for ID <" + string + ">");
            Object object = (String)g.get(string);
            if (object == null) {
                return false;
            }
            a.debug("found   position <" + (String)object + ">");
            if (h == null || h.startsWith("Win")) {
                string2 = Token.c("lib." + (String)object + ".p11lib");
                a.debug("lib." + (String)object + ".p11lib=" + string2);
            } else {
                string2 = Token.c("lib." + (String)object + ".p11lib." + h);
                a.debug("lib." + (String)object + ".p11lib." + h + "=" + string2);
            }
            a.debug(string + ":" + Token.c("lib." + (String)object + ".descr"));
            a.debug("verifying ... ");
            string = k.getLibName();
            try {
                object = new File(string);
                ((File)object).getName();
                File file = new File(string2);
                file.getName();
                if (((File)object).getName() != null && file.getName() != null) {
                    string = ((File)object).getName();
                    string2 = file.getName();
                }
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            if (k != null && string != null && string2.compareToIgnoreCase(string) == 0) {
                a.debug("verifyLib returning true");
                return true;
            }
            a.debug("verifyLib returning false");
            return false;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean verifyATRMatchTokenConfig(String string) {
        boolean bl = false;
        try {
            string = string.toLowerCase();
            if (string == null || string.length() == 0) {
                return true;
            }
            a.debug("finding lib for ATR <" + string + ">");
            for (int i = 0; i < 2; ++i) {
                String[] stringArray = (String[])f.get(string + ".lib" + i);
                if (stringArray == null) {
                    a.debug("getMatching ATR <" + string + ">");
                    stringArray = (String)f.getMatching(string + ".lib" + i);
                    if (stringArray == null) continue;
                    a.debug("found lib for ATR <" + (String)stringArray + ">");
                }
                bl = true;
                if (i == 0) {
                    a.debug(i + ":" + string + ":" + (String)stringArray);
                    try {
                        if (Token.a((String)stringArray)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        a.debug(exception.getMessage(), (Throwable)exception);
                    }
                    continue;
                }
                a.debug(i + ":" + string + ":" + (String)stringArray);
                stringArray = stringArray.split(";");
                if (!this.a(stringArray)) continue;
                return true;
            }
        }
        catch (ATRException aTRException) {
            a.debug(aTRException.getMessage(), (Throwable)aTRException);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return !bl;
    }

    public static KnownSmartcardInfo[] getKnownSmartcards() {
        a.debug("getKnownSmartcards");
        return i;
    }

    public static KnownP11LibraryInfo[] getKnownP11Libraries() {
        a.debug("getKnownP11Libraries ");
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PrivateKey getPrivateKey(String object) throws CapiException {
        a.debug("getPrivateKey (alias= " + (String)object + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            TokenSpi tokenSpi = k;
            synchronized (tokenSpi) {
                object = k.getPrivateKey((String)object);
            }
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PublicKey getPublicKey(String object) throws CapiException {
        a.debug("getPublicKey (alias= " + (String)object + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            TokenSpi tokenSpi = k;
            synchronized (tokenSpi) {
                object = k.getPublicKey((String)object);
            }
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public static final TokenSpi getTokenSpi() throws CapiException {
        return Token.getTokenSpi(null);
    }

    public static final TokenSpi getTokenSpi(String string) throws CapiException {
        if (tokenTable == null || tokenTable.isEmpty()) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null) {
            return (TokenSpi)tokenTable.values().iterator().next();
        }
        for (TokenSpi tokenSpi : tokenTable.values()) {
            if (!tokenSpi.exist(string)) continue;
            return tokenSpi;
        }
        throw new CapiException("Object not found .", 10023);
    }

    private static void a(String string, int n, int n2, int n3) throws CapiException {
        if (n < n2 || n > n3) {
            throw new CapiException("Parameter " + string + " value ( " + n + " ) is out of the range allowed [" + n2 + " : " + n3 + "]", 1002);
        }
    }

    public final long getMinRSAKeyLength() throws CapiException {
        a.debug("getMinRSAKeyLength");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getMinRSAKeyLength();
    }

    public final long getMinPINLength() throws CapiException {
        a.debug("getMinPINLength");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getMinPINLen();
    }

    public final long getMaxPINLength() throws CapiException {
        a.debug("getMaxPINLength");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        return k.getMaxPINLen();
    }

    private void a(int n) throws CapiException {
        if (n < 768) {
            throw new CapiException("Key not secure (length is " + n + ")", 10031);
        }
        long l = this.getMinRSAKeyLength();
        if ((long)n < l) {
            throw new CapiException(n + ": key length not available on the token (minimum length available is " + l + ")", 10031);
        }
    }

    private static void a(it.actalis.ellips.capi.core.Certificate certificate) throws CertificateExpiredException, CapiException {
        try {
            certificate.isValid();
            return;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            a.debug(certificateExpiredException.getMessage(), (Throwable)certificateExpiredException);
            throw certificateExpiredException;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            a.debug(certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException);
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
    }

    private void b(String string) throws CapiException {
        try {
            a.debug("finding args for ID <" + string + ">");
            String string2 = (String)g.get(string);
            if (string2 == null) {
                a.debug("ID not present");
                throw new Exception("ID not present");
            }
            a.debug("found   position <" + string2 + ">");
            String[] stringArray = new String[4];
            if (h == null || h.startsWith("Win")) {
                stringArray[0] = Token.c("lib." + string2 + ".p11lib");
                a.debug("lib." + string2 + ".p11lib=" + stringArray[0]);
            } else {
                stringArray[0] = Token.c("lib." + string2 + ".p11lib." + h);
                a.debug("lib." + string2 + ".p11lib." + h + "=" + stringArray[0]);
            }
            if (this.d != null) {
                stringArray[1] = this.d;
                a.debug("customized slot number to: " + this.d);
            } else {
                stringArray[1] = Token.c("lib." + string2 + ".slot");
            }
            stringArray[2] = Token.c("lib." + string2 + ".flags");
            stringArray[3] = Token.c("lib." + string2 + ".timeout");
            a.debug(string + ":" + Token.c("lib." + string2 + ".descr"));
            for (int i = 0; i < 4; ++i) {
                a.debug(i + ":" + stringArray[i]);
            }
            this.init("PKCS11Token", stringArray);
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException(exception.getMessage(), 1003);
        }
    }

    private static Map a(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = resourceBundle.getObject(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private static void b() {
        a.debug("setKnownSmartcards start");
        i = new KnownSmartcardInfo[0];
        try {
            int n = Integer.parseInt(Token.c("ncards"));
            i = new KnownSmartcardInfo[n];
            int n2 = 1;
            int n3 = 0;
            while (n2 <= n) {
                Token.i[n3] = new KnownSmartcardInfo(Token.c("card." + n2 + ".ATR"), Token.c("card." + n2 + ".descr"), Token.c("card." + n2 + ".lib"), Token.c("card." + n2 + ".backuplib"));
                ++n2;
                ++n3;
            }
            a.debug(n + " known smartcards data loaded");
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
            return;
        }
        finally {
            a.debug("setKnownSmartcards end");
        }
    }

    private static void c() {
        a.debug("setKnownP11Library start");
        j = new KnownP11LibraryInfo[0];
        try {
            int n = Integer.parseInt(Token.c("nlibs"));
            j = new KnownP11LibraryInfo[n];
            int n2 = 1;
            int n3 = 0;
            while (n2 <= n) {
                Token.j[n3] = new KnownP11LibraryInfo(Token.c("lib." + n2 + ".ID"), Token.c("lib." + n2 + ".descr"), Token.c("lib." + n2 + ".p11lib"), Token.c("lib." + n2 + ".slot"), Token.c("lib." + n2 + ".flags"), Token.c("lib." + n2 + ".timeout"));
                ++n2;
                ++n3;
            }
            a.debug(n + " known libraries data loaded");
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
            return;
        }
        finally {
            a.debug("setKnownP11Library end");
        }
    }

    private static String c(String string) {
        String string2 = null;
        try {
            string2 = (String)e.get(string);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {}
        return string2;
    }

    protected boolean isTokenSoftSia() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importCredential(String string, PrivateKey privateKey, it.actalis.ellips.capi.core.Certificate certificate, int n, int n2, boolean bl, boolean bl2) throws CertificateExpiredException, CapiException {
        a.debug("importCredential (alias= " + string + ")");
        if (k == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        if (string == null || string.length() == 0 || privateKey == null || certificate == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Token.a("mode", n, 0, 2);
        Token.a("usage", n2, 1, 3);
        if (!this.isLogged()) {
            throw new CapiException("Session not opened", 10013);
        }
        if (certificate.getInternalCert().getKeyUsage() == null || !certificate.getInternalCert().getKeyUsage()[2] && !certificate.getInternalCert().getKeyUsage()[3] && !certificate.getInternalCert().getKeyUsage()[7] && !certificate.getInternalCert().getKeyUsage()[8]) {
            Token.a(certificate);
        }
        int n3 = ((RSAPublicKey)certificate.getPublicKey()).getModulus().bitLength();
        a.debug("importCredential key length=" + n3);
        this.a(n3);
        if (bl) {
            a.debug("importCredential check key usage");
            if (!k.checkKeyUsage(n2, certificate.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        TokenSpi tokenSpi = k;
        synchronized (tokenSpi) {
            a.debug("importCredential impcred ...");
            string = k.impCred(string, privateKey, n2, n);
            a.debug("importCredential instcert...");
            try {
                k.instCert(string, certificate, false, bl2);
                a.debug("importCredential instcert ok");
            }
            catch (CapiException capiException) {
                a.debug("install cert KO. Deleting keys for " + string + " ...");
                try {
                    k.deleteObject(string);
                    a.debug("importCredential import failed. Keys deleted");
                }
                catch (CapiException capiException2) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                    a.debug("importCredential import failed. Keys left on token.");
                }
                throw capiException;
            }
            return;
        }
    }

    static {
        a.debug("Token static initialization - start");
        try {
            h = System.getProperty("os.name", null);
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
            h = null;
        }
        try {
            String string;
            String string2;
            int n;
            a.debug("start pkcs11devices file parsing");
            e = Token.a(ResourceBundle.getBundle("pkcs11devices"));
            f = new ATRHashtable();
            g = new Hashtable();
            int n2 = Integer.parseInt((String)e.get("nlibs"));
            int n3 = Integer.parseInt((String)e.get("ncards"));
            a.debug("read library db items and check for map index conflicts and duplicates");
            for (n = 1; n <= n2; ++n) {
                string2 = null;
                try {
                    string2 = (String)e.get("lib." + n + ".ID");
                }
                catch (Exception exception) {}
                if (string2 == null) {
                    a.debug("library " + n + " has not an ID: skipped");
                    continue;
                }
                string = g.put(string2, "" + n);
                if (string == null) continue;
                a.debug("library id " + string2 + " now assigned to " + n + " was already assigned to " + string + ". Duplicated library ID");
            }
            a.debug("read cards db items and check for map index conflicts and duplicates");
            for (n = 1; n <= n3; ++n) {
                String string3;
                string2 = null;
                string = null;
                String string4 = null;
                try {
                    string2 = (String)e.get("card." + n + ".ATR");
                }
                catch (Exception exception) {}
                if (string2 == null) {
                    a.debug("card " + n + " has not an assigned ATR: skip it");
                    continue;
                }
                try {
                    string = (String)e.get("card." + n + ".descr");
                }
                catch (Exception exception) {}
                if (string != null) {
                    string3 = (String)f.put(string2 + ".descr", string);
                    if (string3 != null) {
                        a.debug("description " + string + " now assigned to " + string2 + " was already assigned to " + string3 + ". Duplicated ATR");
                    }
                } else {
                    a.debug("card " + n + " has not a description: use Unknown");
                    string3 = (String)f.put(string2 + ".descr", "Unknown");
                    if (string3 != null) {
                        a.debug("Unknown description now assigned to " + n + " was already assigned to " + string3 + ". Duplicated ATR?");
                    }
                }
                try {
                    string4 = (String)e.get("card." + n + ".lib");
                }
                catch (Exception exception) {}
                if (string4 != null && (string3 = (String)f.put(string2 + ".lib0", string4)) != null) {
                    a.debug("library " + string4 + " now assigned to " + string2 + " was already assigned to " + string3 + ". Duplicated ATR");
                }
                try {
                    string4 = (String)e.get("card." + n + ".backuplib");
                }
                catch (Exception exception) {}
                if (string4 == null || (string3 = (String)f.put(string2 + ".lib1", string4)) == null) continue;
                a.debug("backup library " + string4 + " now assigned to " + string2 + " was already assigned to " + string3 + ". Duplicated ATR");
            }
            Token.b();
            Token.c();
            a.debug("end pkcs11devices file parsing");
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
            return;
        }
        finally {
            a.debug("Token static initialization - end");
        }
    }
}

