/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.ini;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniFile;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.IniSerializableObject;
import it.actalis.ellips.capi.util.ini.IniStringHashMap;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class SignedIniFile
extends IniFile {
    private static Logger b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private byte[] c = null;
    private byte[] d = null;
    private boolean e = false;

    public SignedIniFile() {
    }

    public SignedIniFile(String string) {
        try {
            this.c = Util.getBytes(string);
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw new RuntimeException(capiException.getMessage());
        }
        this.e = false;
    }

    public SignedIniFile(String string, byte[] byArray) throws IOException, IniFileException, UnrecoverableKeyException, InstantiationException, IllegalAccessException {
        this(string, byArray, IniStringHashMap.class);
    }

    public SignedIniFile(String object, byte[] object2, Class<? extends IniSerializableObject> object3) throws IOException, IniFileException, UnrecoverableKeyException, InstantiationException, IllegalAccessException {
        Class<? extends IniSerializableObject> clazz = object3;
        object3 = object2;
        object2 = object;
        object = this;
        b.debug("loading " + (String)object2);
        byte[] byArray = SignedIniFile.a((String)object2);
        b.debug("loaded " + byArray.length + " bytes from " + (String)object2);
        object2 = new int[]{-1, -1};
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 13 || byArray[i + 1] != 10) continue;
            object2[n++] = i;
            if (n == 2) break;
        }
        if (object2[1] == -1) {
            throw new IniFileException("No HMAC present", 3);
        }
        ((SignedIniFile)object).c = new byte[object2[0] - 1];
        ((SignedIniFile)object).d = new byte[object2[1] - object2[0] - 3];
        byte[] byArray2 = new byte[byArray.length - object2[1] - 4];
        System.arraycopy(byArray, 1, ((SignedIniFile)object).c, 0, ((SignedIniFile)object).c.length);
        System.arraycopy(byArray, object2[0] + 3, ((SignedIniFile)object).d, 0, ((SignedIniFile)object).d.length);
        System.arraycopy(byArray, object2[1] + 4, byArray2, 0, byArray2.length);
        object2 = SignedIniFile.a(byArray2, (byte[])object3);
        b.debug("loadhmac:" + new String(((SignedIniFile)object).d, "ISO8859_1"));
        b.debug("datahmac:" + new String((byte[])object2, "ISO8859_1"));
        if (!Arrays.areEqual((byte[])((SignedIniFile)object).d, (byte[])object2)) {
            throw new UnrecoverableKeyException("The password is wrong.");
        }
        ((IniFile)object).load(byArray, clazz);
        this.e = true;
    }

    private static byte[] a(String object) throws IOException {
        object = new File((String)object);
        byte[] byArray = new byte[(int)((File)object).length()];
        object = new FileInputStream((File)object);
        ((FileInputStream)object).read(byArray);
        ((FileInputStream)object).close();
        return byArray;
    }

    public void store(String object, byte[] byArray, boolean bl) throws IniFileException, IOException, UnrecoverableKeyException {
        if (!bl && this.e) {
            try {
                this.loadHeader((String)object, true);
            }
            catch (IniFileException iniFileException) {
                b.debug(iniFileException.getMessage(), (Throwable)iniFileException);
                throw iniFileException;
            }
            catch (Exception exception) {
                b.debug(exception.getMessage(), (Throwable)exception);
                throw new IniFileException("token probably removed after opening session", 0);
            }
        }
        Object object2 = new ByteArrayOutputStream();
        this.store((ByteArrayOutputStream)object2);
        byte[] byArray2 = ((ByteArrayOutputStream)object2).toByteArray();
        object2 = byArray2;
        byArray = SignedIniFile.a(byArray2, byArray);
        b.debug("storing new hmac " + new String(byArray, "ISO8859_1"));
        object = new FileOutputStream((String)object);
        try {
            ((FileOutputStream)object).write(Util.getBytes("#"));
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw new IOException(capiException.getMessage());
        }
        ((FileOutputStream)object).write(this.c);
        ((FileOutputStream)object).write(13);
        ((FileOutputStream)object).write(10);
        try {
            ((FileOutputStream)object).write(Util.getBytes("#"));
        }
        catch (CapiException capiException) {
            b.debug(capiException.getMessage(), (Throwable)capiException);
            throw new IOException(capiException.getMessage());
        }
        ((FileOutputStream)object).write(byArray);
        ((FileOutputStream)object).write(13);
        ((FileOutputStream)object).write(10);
        ((FileOutputStream)object).write(13);
        ((FileOutputStream)object).write(10);
        ((FileOutputStream)object).write((byte[])object2);
        ((FileOutputStream)object).close();
        b.debug("closed output file.");
        this.d = byArray;
        b.debug("storhmac:" + new String(this.d, "ISO8859_1"));
    }

    public void store(String string, byte[] byArray) throws IniFileException, IOException, UnrecoverableKeyException {
        this.store(string, byArray, false);
    }

    public byte[] loadHeader(String object, boolean bl) throws IOException, UnrecoverableKeyException, IniFileException {
        b.debug("loadingHeader from " + (String)object);
        byte[] byArray = SignedIniFile.a((String)object);
        b.debug("loaded " + byArray.length + " bytes from " + (String)object);
        object = new int[]{-1, -1};
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 13 || byArray[i + 1] != 10) continue;
            object[n++] = i;
            if (n == 2) break;
        }
        if (object[1] == -1) {
            throw new UnrecoverableKeyException("No HMAC present.");
        }
        byte[] byArray2 = new byte[object[0] - true];
        byte[] byArray3 = new byte[object[1] - object[0] - 3];
        b.debug("currtkid:" + new String(byArray2, "ISO8859_1"));
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        b.debug("currtkid:" + new String(byArray2, "ISO8859_1"));
        System.arraycopy(byArray, (int)(object[0] + 3), byArray3, 0, byArray3.length);
        b.debug("currhmac:" + new String(byArray3, "ISO8859_1"));
        if (this.d != null) {
            b.debug("loadhmac:" + new String(this.d, "ISO8859_1"));
        }
        if (!bl) {
            return byArray2;
        }
        if (!Arrays.areEqual((byte[])byArray3, (byte[])this.d)) {
            throw new IniFileException("Different token password present", 2);
        }
        return this.c;
    }

    private static byte[] a(byte[] byArray, byte[] byArray2) throws UnrecoverableKeyException {
        try {
            Mac mac = Mac.getInstance("HMac-SHA1", ProvUtils.bcProvider);
            mac.init(new SecretKeySpec(byArray2, "HMac-SHA1"));
            byArray = mac.doFinal(byArray);
            return Util.base64Encode(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            b.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new SecurityException("Algorithm not specified: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            b.debug(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            throw new UnrecoverableKeyException("The password is wrong.");
        }
    }

    public int size() {
        return this.a.size();
    }

    public byte[] getLoadTkId() {
        return this.c;
    }

    public void setLoadTkId(byte[] byArray) {
        this.c = byArray;
    }
}

