/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import it.actalis.ellips.capi.logging.FileAppender;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class RandomFileAppender
extends FileAppender {
    protected RandomAccessFile logFileWriter;
    protected FileLock lockAppender;

    public RandomFileAppender(String logFilePath) throws FileNotFoundException, IOException {
        super(logFilePath);
        long fileLength = new File(logFilePath).length();
        this.logFileWriter = new RandomAccessFile(logFilePath, "rw");
        this.logFileWriter.seek(fileLength);
        this.lockAppender = null;
        this.nReferences = 1;
    }

    @Override
    public synchronized void release() throws IOException {
        if (this.nReferences > 0) {
            --this.nReferences;
        }
        if (this.nReferences == 0) {
            this.unlock();
            this.logFileWriter.close();
            this.appenderPath = "";
        }
    }

    @Override
    synchronized void writeData(byte[] data) throws IOException {
        if (this.logFileWriter.getFilePointer() > this.logFileWriter.length()) {
            this.logFileWriter.seek(this.logFileWriter.length());
        }
        this.logFileWriter.write(data);
    }

    @Override
    public synchronized void addReference() {
        ++this.nReferences;
    }

    @Override
    public int getReferences() {
        return this.nReferences;
    }

    @Override
    protected synchronized void lock() throws IOException {
        if (this.isLocked()) {
            return;
        }
        this.lockAppender = this.logFileWriter.getChannel().tryLock();
        if (this.lockAppender == null) {
            System.err.println("Appender resource file not available for " + this.appenderPath);
            throw new IOException("Appender resource file not available for " + this.appenderPath);
        }
    }

    @Override
    protected synchronized void unlock() throws IOException {
        if (!this.isLocked()) {
            return;
        }
        try {
            this.lockAppender.release();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Appender resource cannot be released! " + ex.getMessage(), ex);
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lockAppender != null && this.lockAppender.isValid();
    }

    @Override
    public synchronized void backup(String backupFilePath, String backupFileExtension, int baseIndex, boolean compress) throws IOException {
        if (!this.isLocked()) {
            boolean fileCreated = false;
            File backupFile = null;
            try {
                this.lock();
                File fappender = new File(this.appenderPath);
                if (fappender.length() > 0L) {
                    if (baseIndex >= 0) {
                        backupFile = new File(backupFilePath + "-" + baseIndex + backupFileExtension);
                        while (!backupFile.createNewFile()) {
                            backupFile = new File(backupFilePath + "-" + ++baseIndex + backupFileExtension);
                        }
                        ++baseIndex;
                    } else {
                        backupFile = new File(backupFilePath + backupFileExtension);
                        if (backupFile.exists()) {
                            return;
                        }
                        if (!backupFile.createNewFile()) {
                            throw new IOException("Unable to create backup file: " + backupFilePath + backupFileExtension);
                        }
                    }
                    fileCreated = true;
                    if (compress) {
                        this.zipFile(backupFile);
                    } else {
                        this.copyFile(backupFile);
                    }
                    this.logFileWriter.getChannel().truncate(0L);
                }
            }
            catch (Throwable t) {
                if (fileCreated) {
                    backupFile.delete();
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException("Unable to backup file: " + t.getMessage(), t);
            }
            finally {
                if (this.isLocked()) {
                    this.unlock();
                }
            }
        }
    }

    private boolean zipFile(File fileZipPath) throws IOException {
        if (fileZipPath == null) {
            return false;
        }
        if (this.logFileWriter == null) {
            return false;
        }
        RandomAccessFile input = this.logFileWriter;
        input.seek(0L);
        String entryName = new File(this.appenderPath).getName();
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(fileZipPath);
            zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry(entryName));
            byte[] bytes = new byte[(int)input.length()];
            input.readFully(bytes);
            zos.write(bytes, 0, bytes.length);
            zos.closeEntry();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable to compress the backup: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable to compress the backup " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean copyFile(File backupFilePath) throws IOException {
        if (backupFilePath == null) {
            return false;
        }
        if (this.logFileWriter == null) {
            return false;
        }
        RandomAccessFile input = this.logFileWriter;
        input.seek(0L);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(backupFilePath);
            byte[] bytes = new byte[(int)input.length()];
            input.readFully(bytes);
            fos.write(bytes, 0, bytes.length);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable copy into backup: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable copy into backup " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                return false;
            }
        }
        return true;
    }
}

