/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator;

import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.sqllite.ArubaCdbManifestValidator;
import esecurity.tsl.sqllite.ManifestValidator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;

public class ValidatorConfig {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    protected static final String EQ_SEP = "=";
    protected static final String LINK_INDICATOR = "@";
    protected Properties configdb = null;
    protected NetworkConfig netConf = null;
    protected String fullPath = null;
    private LanguagesCode b = LanguagesCode.EN;
    private MessageFactory c = null;
    private TimeZone d = Constants.DEFAULT_TIMEZONE;
    private ManifestValidator e;

    public ValidatorConfig() {
        this.fullPath = null;
        this.configdb = new Properties();
    }

    public ValidatorConfig(String string) {
        this.fullPath = string;
        this.configdb = new Properties();
    }

    public ValidatorConfig(ValidatorConfig validatorConfig, String string) {
        this.fullPath = string;
        this.configdb = new Properties(validatorConfig.configdb);
    }

    public ValidatorConfig(ConfigFile object) {
        this.configdb = new Properties(((ConfigFile)object).getConfigDB());
        this.configdb.putAll((Map<?, ?>)((ConfigFile)object).getConfigDB());
        if (this.configdb.getProperty("timeZone", null) != null) {
            this.d = TimeZone.getTimeZone(this.configdb.getProperty("timeZone"));
        }
        this.netConf = new NetworkConfig(a, false);
        object = this.configdb.getProperty("http.proxy.noProxyHosts", null);
        this.netConf.setProxynohosts(object != null ? ((String)object).split(",") : null);
        this.netConf.setAutomaticProxyDiscovery(this.configdb.getProperty("http.proxy.auto", FALSE).equalsIgnoreCase(TRUE));
        this.netConf.setProxy(this.configdb.getProperty("http.proxy.host", null));
        this.netConf.setProxyPort(this.configdb.getProperty("http.proxy.port", null));
        this.netConf.setUserProxy(this.configdb.getProperty("http.proxy.user", null));
        this.netConf.setPasswordProxy(this.configdb.getProperty("http.proxy.pass", null));
        if (this.configdb.getProperty("language", null) != null) {
            try {
                this.b = LanguagesCode.valueOf(this.configdb.getProperty("language", null).toUpperCase());
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.b = LanguagesCode.EN;
                return;
            }
            catch (NullPointerException nullPointerException) {
                this.b = LanguagesCode.EN;
            }
        }
    }

    public void loadConfigFile() throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fullPath);
            this.configdb.load(fileInputStream);
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public String getElement(String string) {
        return this.getElement(string, null);
    }

    public String getElement(String string, String string2) {
        if ((string = this.configdb.getProperty(string, string2)) != null && (string = string.trim()).startsWith(LINK_INDICATOR)) {
            string = string.substring(1);
            string = this.getElement(string, string2);
        }
        return string;
    }

    public int getIntElement(String string, int n) {
        try {
            return Integer.parseInt(this.getElement(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean getBinElement(String string, boolean bl) {
        if ((string = this.getElement(string)) == null) {
            return bl;
        }
        return TRUE.equals(string = string.toLowerCase());
    }

    public String[] getElements(String string, String string2, int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            stringArray[i] = this.getElement(string + n2, string2);
        }
        return stringArray;
    }

    public void setElement(String string, String string2) {
        if (string2 == null) {
            this.configdb.setProperty(string.trim(), null);
            return;
        }
        this.configdb.setProperty(string.trim(), string2.trim());
    }

    public void setBinElement(String string, boolean bl) {
        if (bl) {
            this.configdb.setProperty(string.trim(), TRUE);
            return;
        }
        this.configdb.setProperty(string.trim(), FALSE);
    }

    public boolean saveConfigFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fullPath, false);
            this.configdb.store(fileOutputStream, null);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return false;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String string) {
        this.fullPath = string;
    }

    public void setLanguage(LanguagesCode languagesCode) {
        this.b = languagesCode;
        this.configdb.setProperty("language", languagesCode.name());
        this.c = null;
    }

    public LanguagesCode getLanguage() {
        String string = this.configdb.getProperty("language", this.b.name());
        if (string == LanguagesCode.DE.name()) {
            this.b = LanguagesCode.DE;
        } else if (string == LanguagesCode.IT.name()) {
            this.b = LanguagesCode.IT;
        } else {
            LanguagesCode.EN.name();
            this.b = LanguagesCode.EN;
        }
        return this.b;
    }

    public MessageFactory getMessageFactory() {
        if (this.c == null) {
            try {
                this.c = new MessageFactory(this.b);
            }
            catch (VolException volException) {
                a.error(volException.getMessage(), (Throwable)volException);
            }
        }
        return this.c;
    }

    public NetworkConfig getNetConfiguration() {
        if (this.netConf == null) {
            this.netConf = new NetworkConfig(a, false);
            this.netConf.setProxy(this.configdb.getProperty("http.proxy.host", null));
            this.netConf.setProxyType(this.configdb.getProperty("http.proxy.type", ""));
            this.netConf.setProxyPort(this.configdb.getProperty("http.proxy.port", "8080"));
            this.netConf.setUserProxy(this.configdb.getProperty("http.proxy.user", null));
            this.netConf.setPasswordProxy(this.configdb.getProperty("http.proxy.pass", null));
            String string = this.configdb.getProperty("http.proxy.noProxyHosts", null);
            this.netConf.setProxynohosts(string != null ? string.split(",") : null);
            this.netConf.setAutomaticProxyDiscovery(this.configdb.getProperty("http.proxy.auto", FALSE).equalsIgnoreCase(TRUE));
            this.netConf.setLdapProxy(this.configdb.getProperty("ldap.proxy.host", null));
            this.netConf.setLdapProxyType(this.configdb.getProperty("ldap.proxy.type", ""));
            this.netConf.setLdapProxyPort(this.configdb.getProperty("ldap.proxy.port", "8080"));
            this.netConf.setLdapUserProxy(this.configdb.getProperty("ldap.proxy.user", null));
            this.netConf.setLdapPasswordProxy(this.configdb.getProperty("ldap.proxy.pass", null));
        }
        return this.netConf;
    }

    public void setNetConfiguration(NetworkConfig networkConfig) {
        this.netConf = networkConfig;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.d = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.d;
    }

    public void setProxyAuthenticator(ProxyAutenticator proxyAutenticator) {
        this.netConf.setProxyauthenticator(proxyAutenticator);
    }

    public void setManifestValidator(ManifestValidator manifestValidator) {
        this.e = manifestValidator;
    }

    public ManifestValidator getManifestValidator() {
        return this.e;
    }

    public CertDb getCertDB() throws CapiException {
        String string = this.getElement("certdb.file");
        try {
            if (this.e == null) {
                this.e = new ArubaCdbManifestValidator();
            }
            return CertDbBuilder.get().setFile(new File(string)).setNetworkConfig(this.getNetConfiguration()).setType(CertDbType.SQLLITE).setManifestValidator(this.e).build();
        }
        catch (IOException iOException) {
            throw new CapiException("Impossibile trovare il certdb", 1003, iOException);
        }
    }
}

