/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static String a(byte[] byArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] >>> 4 & 0xF;
            int n2 = 0;
            do {
                if (n >= 0 && n <= 9) {
                    stringBuilder.append((char)(n + 48));
                } else {
                    stringBuilder.append((char)(97 + (n - 10)));
                }
                n = byArray[i] & 0xF;
            } while (n2++ <= 0);
        }
        String string = stringBuilder.toString();
        if (bl) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    public static byte[] calculate(DigestAlgorithm object, InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        object = MessageDigest.getInstance(((DigestAlgorithm)((Object)object)).toString());
        inputStream = new BufferedInputStream(inputStream);
        inputStream = new DigestInputStream(inputStream, (MessageDigest)object);
        while (((DigestInputStream)inputStream).read() != -1) {
        }
        return ((MessageDigest)object).digest();
    }

    public static byte[] calculate(DigestAlgorithm object, byte[] object2) throws IOException, NoSuchAlgorithmException {
        object2 = new ByteArrayInputStream((byte[])object2);
        try {
            object = DigestUtils.calculate(object, (InputStream)object2);
        }
        finally {
            Util.closeQuietly((Closeable)object2);
        }
        return object;
    }

    public static String calculateHexString(DigestAlgorithm object, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        byte[] byArray = DigestUtils.calculate(object, inputStream);
        object = byArray;
        return DigestUtils.a(byArray, false);
    }

    public static String calculateHexString(DigestAlgorithm object, InputStream inputStream, boolean bl) throws IOException, NoSuchAlgorithmException {
        byte[] byArray = DigestUtils.calculate(object, inputStream);
        object = byArray;
        return DigestUtils.a(byArray, bl);
    }

    public static String calculateHexString(DigestAlgorithm object, byte[] byArray) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = DigestUtils.calculate(object, byArray);
        object = byArray2;
        return DigestUtils.a(byArray2, false);
    }

    public static String calculateHexString(DigestAlgorithm object, byte[] byArray, boolean bl) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = DigestUtils.calculate(object, byArray);
        object = byArray2;
        return DigestUtils.a(byArray2, bl);
    }
}

