/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;

public class Utils {
    public static final String BLOB_MAGIC_ID = "BLOB";
    public static Gson gson = null;

    public static Gson Gson() {
        if (gson == null) {
            gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        }
        return gson;
    }

    public static boolean isBLOB(String array) {
        boolean isABLOB = false;
        if (array != null && !"".equals(array) && (array = array.trim()).startsWith("[") && array.endsWith("']")) {
            String[] values = array.substring(1, array.length() - 1).split(",");
            isABLOB = values.length == 2 && BLOB_MAGIC_ID.equalsIgnoreCase(values[0]);
        }
        return isABLOB;
    }

    public static String makeBLOBEntry(byte[] data) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(BLOB_MAGIC_ID);
        b.append(",");
        b.append(data);
        b.append("]");
        return b.toString();
    }

    public static boolean isBLOB(JsonArray array) {
        return array != null && array.size() == 2 && BLOB_MAGIC_ID.equals(array.get(0).getAsString());
    }
}

